/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.maven.bootstrap;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckForNull;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.converters.basic.StringConverter;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonarsource.scanner.maven.bootstrap.MavenUtils;

public class JavaVersionResolver {
    private static final String MAVEN_COMPILER_PLUGIN = "maven-compiler-plugin";
    private static final String COMPILE_GOAL = "org.apache.maven.plugins:maven-compiler-plugin:compile";
    private final MavenSession session;
    private final Log log;
    private List<MojoExecution> mojoExecutions;

    public JavaVersionResolver(MavenSession session, LifecycleExecutor lifecycleExecutor, Log log) {
        this.session = session;
        this.log = log;
        this.mojoExecutions = new LinkedList<MojoExecution>();
        try {
            this.mojoExecutions = lifecycleExecutor.calculateExecutionPlan(session, true, new String[]{COMPILE_GOAL}).getMojoExecutions();
        }
        catch (Exception e) {
            log.warn((CharSequence)String.format("Failed to get mojo executions for goal '%s': %s", COMPILE_GOAL, e.getMessage()));
        }
    }

    @CheckForNull
    public String getTarget(MavenProject pom) {
        return MavenUtils.coalesce(this.getString(pom, "target"), MavenUtils.getPluginSetting(pom, "org.apache.maven.plugins", MAVEN_COMPILER_PLUGIN, "target", null));
    }

    @CheckForNull
    public String getSource(MavenProject pom) {
        return MavenUtils.coalesce(this.getString(pom, "source"), MavenUtils.getPluginSetting(pom, "org.apache.maven.plugins", MAVEN_COMPILER_PLUGIN, "source", null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private String getString(MavenProject pom, String parameter) {
        MavenProject oldProject = this.session.getCurrentProject();
        try {
            this.session.setCurrentProject(pom);
            Iterator<MojoExecution> iterator = this.mojoExecutions.iterator();
            while (iterator.hasNext()) {
                PluginParameterExpressionEvaluator expressionEvaluator;
                BasicStringConverter converter = new BasicStringConverter();
                MojoExecution exec = iterator.next();
                Xpp3Dom configuration = exec.getConfiguration();
                XmlPlexusConfiguration pomConfiguration = new XmlPlexusConfiguration(configuration);
                PlexusConfiguration config = pomConfiguration.getChild(parameter);
                String value = converter.fromExpression(config, (ExpressionEvaluator)(expressionEvaluator = new PluginParameterExpressionEvaluator(this.session, exec)));
                if (value == null) continue;
                String string = value;
                return string;
            }
        }
        catch (Exception e) {
            this.log.warn((CharSequence)String.format("Failed to get parameter '%s' for goal '%s': %s", parameter, COMPILE_GOAL, e.getMessage()));
        }
        finally {
            this.session.setCurrentProject(oldProject);
        }
        return null;
    }

    static class BasicStringConverter
    extends StringConverter {
        BasicStringConverter() {
        }

        public String fromExpression(PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator) throws ComponentConfigurationException {
            return (String)super.fromExpression(configuration, expressionEvaluator);
        }
    }
}

