/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zel.impl.parser;

import java.util.ArrayList;
import org.zkoss.zel.ELException;
import org.zkoss.zel.LambdaExpression;
import org.zkoss.zel.impl.ValueExpressionImpl;
import org.zkoss.zel.impl.lang.EvaluationContext;
import org.zkoss.zel.impl.parser.AstLambdaParameters;
import org.zkoss.zel.impl.parser.AstMethodParameters;
import org.zkoss.zel.impl.parser.Node;
import org.zkoss.zel.impl.parser.SimpleNode;
import org.zkoss.zel.impl.util.MessageFactory;

public class AstLambdaExpression
extends SimpleNode {
    private NestedState nestedState = null;

    public AstLambdaExpression(int id) {
        super(id);
    }

    public Object getValue(EvaluationContext ctx) throws ELException {
        NestedState state = this.getNestedState();
        int methodParameterSetCount = this.jjtGetNumChildren() - 2;
        if (methodParameterSetCount > state.getNestingCount()) {
            throw new ELException(MessageFactory.get("error.lambda.tooManyMethodParameterSets"));
        }
        AstLambdaParameters formalParametersNode = (AstLambdaParameters)this.children[0];
        Node[] formalParamNodes = formalParametersNode.children;
        ValueExpressionImpl ve = new ValueExpressionImpl("", this.children[1], ctx.getFunctionMapper(), ctx.getVariableMapper(), null);
        ArrayList<String> formalParameters = new ArrayList<String>();
        if (formalParamNodes != null) {
            for (Node formalParamNode : formalParamNodes) {
                formalParameters.add(formalParamNode.getImage());
            }
        }
        LambdaExpression le = new LambdaExpression(formalParameters, ve);
        le.setELContext(ctx);
        if (this.jjtGetNumChildren() == 2) {
            if (state.getHasFormalParameters()) {
                return le;
            }
            return le.invoke(ctx, (Object[])null);
        }
        int methodParameterIndex = 2;
        Object result = le.invoke(((AstMethodParameters)this.children[methodParameterIndex]).getParameters(ctx));
        ++methodParameterIndex;
        while (result instanceof LambdaExpression && methodParameterIndex < this.jjtGetNumChildren()) {
            result = ((LambdaExpression)result).invoke(((AstMethodParameters)this.children[methodParameterIndex]).getParameters(ctx));
            ++methodParameterIndex;
        }
        return result;
    }

    private NestedState getNestedState() {
        if (this.nestedState == null) {
            this.setNestedState(new NestedState());
        }
        return this.nestedState;
    }

    private void setNestedState(NestedState nestedState) {
        if (this.nestedState != null) {
            throw new IllegalStateException("nestedState may only be set once");
        }
        this.nestedState = nestedState;
        nestedState.incrementNestingCount();
        if (this.jjtGetNumChildren() > 1) {
            Node firstChild = this.jjtGetChild(0);
            if (firstChild instanceof AstLambdaParameters) {
                if (firstChild.jjtGetNumChildren() > 0) {
                    nestedState.setHasFormalParameters();
                }
            } else {
                return;
            }
            Node secondChild = this.jjtGetChild(1);
            if (secondChild instanceof AstLambdaExpression) {
                ((AstLambdaExpression)secondChild).setNestedState(nestedState);
            }
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Node n : this.children) {
            result.append(n.toString());
        }
        return result.toString();
    }

    private static class NestedState {
        private int nestingCount = 0;
        private boolean hasFormalParameters = false;

        private NestedState() {
        }

        private void incrementNestingCount() {
            ++this.nestingCount;
        }

        private int getNestingCount() {
            return this.nestingCount;
        }

        private void setHasFormalParameters() {
            this.hasFormalParameters = true;
        }

        private boolean getHasFormalParameters() {
            return this.hasFormalParameters;
        }
    }
}

