/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.connectors.rocci;

import integratedtoolkit.connectors.AbstractSSHConnector;
import integratedtoolkit.connectors.ConnectorException;
import integratedtoolkit.connectors.rocci.RocciClient;
import integratedtoolkit.types.resources.description.CloudMethodResourceDescription;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ROCCI
extends AbstractSSHConnector {
    private static Integer MAX_VM_CREATION_TIME = 10;
    private static Integer MAX_ALLOWED_ERRORS = 3;
    private static Integer RETRY_TIME = 5;
    private static final String ROCCI_CLIENT_VERSION = "4.2.5";
    private RocciClient client;
    private ArrayList<String> cmd_string;
    private String attributes = "Not Defined";
    private static final long DEFAULT_TIME_SLOT = 300000L;
    private long timeSlot = 300000L;

    public ROCCI(String providerName, HashMap<String, String> props) {
        super(providerName, props);
        String time;
        logger.info((Object)"Initializing rOCCI connector with version4.2.5");
        this.cmd_string = new ArrayList();
        if (props.get("Server") != null) {
            this.cmd_string.add("--endpoint " + props.get("Server"));
        }
        if (props.get("auth") != null) {
            this.cmd_string.add("--auth " + props.get("auth"));
        }
        if (props.get("timeout") != null) {
            this.cmd_string.add("--timeout " + props.get("timeout"));
        }
        if (props.get("username") != null) {
            this.cmd_string.add("--username " + props.get("username"));
        }
        if (props.get("password") != null) {
            this.cmd_string.add("--password " + props.get("password"));
        }
        if (props.get("ca-path") != null) {
            this.cmd_string.add("--ca-path " + props.get("ca-path"));
        }
        if (props.get("ca-file") != null) {
            this.cmd_string.add("--ca-file " + props.get("ca-file"));
        }
        if (props.get("skip-ca-check") != null) {
            this.cmd_string.add("--skip-ca-check " + props.get("skip-ca-check"));
        }
        if (props.get("filter") != null) {
            this.cmd_string.add("--filter " + props.get("filter"));
        }
        if (props.get("user-cred") != null) {
            this.cmd_string.add("--user-cred " + props.get("user-cred"));
        }
        if (props.get("voms") != null) {
            this.cmd_string.add("--voms");
        }
        if (props.get("media-type") != null) {
            this.cmd_string.add("--media-type " + props.get("media-type"));
        }
        if (props.get("resource") != null) {
            this.cmd_string.add("--resource " + props.get("resource"));
        }
        if (props.get("attributes") != null) {
            this.cmd_string.add("--attributes " + props.get("attributes"));
        }
        if (props.get("context") != null) {
            this.cmd_string.add("--context " + props.get("context"));
        }
        if (props.get("action") != null) {
            this.cmd_string.add("--action " + props.get("action"));
        }
        if (props.get("mixin") != null) {
            this.cmd_string.add("--mixin " + props.get("mixin"));
        }
        if (props.get("link") != null) {
            this.cmd_string.add("--link " + props.get("link"));
        }
        if (props.get("trigger-action") != null) {
            this.cmd_string.add("--trigger-action " + props.get("trigger-action"));
        }
        if (props.get("log-to") != null) {
            this.cmd_string.add("--log-to " + props.get("log-to"));
        }
        this.cmd_string.add("--output-format json_extended_pretty");
        if (props.get("dump-model") != null) {
            this.cmd_string.add("--dump-model");
        }
        if (props.get("debug") != null) {
            this.cmd_string.add("--debug");
        }
        if (props.get("verbose") != null) {
            this.cmd_string.add("--verbose");
        }
        if (props.get("max-vm-creation-time") != null) {
            MAX_VM_CREATION_TIME = Integer.parseInt(props.get("max-vm-creation-time"));
        }
        if (props.get("max-connection-errors") != null) {
            MAX_ALLOWED_ERRORS = Integer.parseInt(props.get("max-connection-errors"));
        }
        if (props.get("owner") != null && props.get("jobname") != null) {
            this.attributes = props.get("owner") + "-" + props.get("jobname");
        }
        this.timeSlot = (time = props.get("time-slot")) != null ? (long)(Integer.parseInt(time) * 1000) : 300000L;
        this.client = new RocciClient(this.cmd_string, this.attributes);
    }

    public Object create(String name, CloudMethodResourceDescription rd) throws ConnectorException {
        logger.info((Object)"Creating a VM with rOCCI connector.");
        try {
            String instanceCode = rd.getType();
            String vmId = this.client.create_compute(rd.getImage().getName(), instanceCode);
            if (debug) {
                logger.debug((Object)("VM " + vmId + " created"));
            }
            return vmId;
        }
        catch (Exception e) {
            logger.error((Object)"Error creating a VM", (Throwable)e);
            throw new ConnectorException(e);
        }
    }

    public void destroy(Object vm) throws ConnectorException {
        String vmId = (String)vm;
        logger.info((Object)(" Destroy VM " + vmId + " with rOCCI connector"));
        this.client.delete_compute(vmId);
    }

    public CloudMethodResourceDescription waitUntilCreation(Object vm, CloudMethodResourceDescription requested) throws ConnectorException {
        String vmId = vm.toString();
        logger.info((Object)("Waiting until VM " + vmId + " is created"));
        CloudMethodResourceDescription granted = new CloudMethodResourceDescription();
        Integer polls = 0;
        int errors = 0;
        String status = null;
        status = this.client.get_resource_status(vmId);
        try {
            Thread.sleep(RETRY_TIME * 1000);
        }
        catch (InterruptedException e1) {
            logger.warn((Object)"Sleep Interrumped", (Throwable)e1);
        }
        while (!status.equals("active")) {
            try {
                Integer e1 = polls;
                Integer n = polls = Integer.valueOf(polls + 1);
                Thread.sleep(RETRY_TIME * 1000);
                if (RETRY_TIME * polls >= MAX_VM_CREATION_TIME * 60) {
                    logger.error((Object)"Maximum VM waiting for creation time reached.");
                    throw new ConnectorException("Maximum VM creation time reached.");
                }
                status = this.client.get_resource_status(vmId);
                errors = 0;
            }
            catch (Exception e) {
                if (++errors != MAX_ALLOWED_ERRORS) continue;
                logger.error((Object)("ERROR_MSG = [\n\tError = " + e.getMessage() + "\n]"));
                throw new ConnectorException("Error getting the status of the request");
            }
        }
        String IP = this.client.get_resource_address(vmId);
        granted.setProcessorCPUCount(1);
        granted.setProcessorCoreCount(requested.getProcessorCoreCount());
        granted.setMemoryPhysicalSize(requested.getMemoryPhysicalSize());
        granted.setStorageElemSize(requested.getStorageElemSize());
        granted.setName(IP);
        granted.setProcessorArchitecture(requested.getProcessorArchitecture());
        granted.setProcessorSpeed(requested.getProcessorSpeed());
        granted.setMemoryVirtualSize(requested.getMemoryVirtualSize());
        granted.setMemorySTR(requested.getMemorySTR());
        granted.setMemoryAccessTime(requested.getMemoryAccessTime());
        granted.setStorageElemAccessTime(requested.getStorageElemAccessTime());
        granted.setStorageElemSTR(requested.getStorageElemSTR());
        granted.setOperatingSystemType("Linux");
        granted.setSlots(requested.getSlots());
        List apps = requested.getAppSoftware();
        for (int i = 0; i < apps.size(); ++i) {
            granted.addAppSoftware((String)apps.get(i));
        }
        granted.setImage(requested.getImage());
        granted.setType(requested.getType());
        granted.setValue(requested.getValue().floatValue());
        granted.setValue(this.getMachineCostPerTimeSlot(granted));
        return granted;
    }

    public float getMachineCostPerTimeSlot(CloudMethodResourceDescription rd) {
        return rd.getValue().floatValue();
    }

    public long getTimeSlot() {
        return this.timeSlot;
    }
}

