/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.gat.worker;

import integratedtoolkit.util.Serializer;
import java.lang.reflect.Method;

public class GATWorker {
    protected static final int NUM_HEADER_PARS = 5;
    protected static final int FILE_PAR = 0;
    protected static final int BOOL_PAR = 1;
    protected static final int CHAR_PAR = 2;
    protected static final int STRING_PAR = 3;
    protected static final int BYTE_PAR = 4;
    protected static final int SHORT_PAR = 5;
    protected static final int INT_PAR = 6;
    protected static final int LONG_PAR = 7;
    protected static final int FLOAT_PAR = 8;
    protected static final int DOUBLE_PAR = 9;
    protected static final int OBJECT_PAR = 10;

    public static void main(String[] args) {
        Object[] values;
        Class[] types;
        boolean debug = Boolean.parseBoolean(args[0]);
        String className = args[1];
        String methodName = args[2];
        boolean hasTarget = Boolean.parseBoolean(args[3]);
        int numParams = Integer.parseInt(args[4]);
        if (args.length < 2 * numParams + 5) {
            System.err.println("Insufficient number of arguments");
            System.exit(1);
        }
        if (hasTarget) {
            types = new Class[numParams - 1];
            values = new Object[numParams - 1];
        } else {
            types = new Class[numParams];
            values = new Object[numParams];
        }
        boolean[] mustWrite = new boolean[numParams];
        String[] renamings = new String[numParams];
        int pos = 5;
        Object target = null;
        for (int i = 0; i < numParams; ++i) {
            switch (Integer.parseInt(args[pos])) {
                case 0: {
                    types[i] = String.class;
                    values[i] = args[pos + 1];
                    break;
                }
                case 10: {
                    String renaming = renamings[i] = args[pos + 1];
                    mustWrite[i] = args[pos + 2].equals("W");
                    Object o = null;
                    try {
                        o = Serializer.deserialize(renaming);
                    }
                    catch (Exception e) {
                        System.err.println("Error deserializing object parameter " + i + " with renaming " + renaming + ", method " + methodName + ", class " + className);
                        System.exit(1);
                    }
                    if (hasTarget && i == numParams - 1) {
                        if (o == null) {
                            System.err.println("Target object with renaming " + renaming + ", method " + methodName + ", class " + className + " is null!");
                            System.exit(1);
                        }
                        target = o;
                    } else {
                        if (o == null) {
                            System.err.println("Object parameter " + i + " with renaming " + renaming + ", method " + methodName + ", class " + className + " is null!");
                            System.exit(1);
                        }
                        types[i] = o.getClass();
                        values[i] = o;
                    }
                    ++pos;
                    break;
                }
                case 1: {
                    types[i] = Boolean.TYPE;
                    values[i] = new Boolean(args[pos + 1]);
                    break;
                }
                case 2: {
                    types[i] = Character.TYPE;
                    values[i] = new Character(args[pos + 1].charAt(0));
                    break;
                }
                case 3: {
                    types[i] = String.class;
                    int numSubStrings = Integer.parseInt(args[pos + 1]);
                    String aux = "";
                    for (int j = 2; j <= numSubStrings + 1; ++j) {
                        aux = aux + args[pos + j];
                        if (j >= numSubStrings + 1) continue;
                        aux = aux + " ";
                    }
                    values[i] = aux;
                    pos += numSubStrings;
                    break;
                }
                case 4: {
                    types[i] = Byte.TYPE;
                    values[i] = new Byte(args[pos + 1]);
                    break;
                }
                case 5: {
                    types[i] = Short.TYPE;
                    values[i] = new Short(args[pos + 1]);
                    break;
                }
                case 6: {
                    types[i] = Integer.TYPE;
                    values[i] = new Integer(args[pos + 1]);
                    break;
                }
                case 7: {
                    types[i] = Long.TYPE;
                    values[i] = new Long(args[pos + 1]);
                    break;
                }
                case 8: {
                    types[i] = Float.TYPE;
                    values[i] = new Float(args[pos + 1]);
                    break;
                }
                case 9: {
                    types[i] = Double.TYPE;
                    values[i] = new Double(args[pos + 1]);
                }
            }
            pos += 2;
        }
        if (debug) {
            System.out.println("WORKER - Parameters of execution:");
            System.out.println("  * Method class: " + className);
            System.out.println("  * Method name: " + methodName);
            System.out.print("  * Parameter types:");
            for (Class c : types) {
                System.out.print(" " + c.getName());
            }
            System.out.println("");
            System.out.print("  * Parameter values:");
            for (Object v : values) {
                System.out.print(" " + v);
            }
            System.out.println("");
        }
        Method method = null;
        try {
            Class<?> methodClass = Class.forName(className);
            method = methodClass.getMethod(methodName, types);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Application class not found");
            System.exit(1);
        }
        catch (SecurityException e) {
            System.err.println("Security exception");
            e.printStackTrace();
            System.exit(1);
        }
        catch (NoSuchMethodException e) {
            System.err.println("Requested method not found");
            System.exit(1);
        }
        Object retValue = null;
        try {
            retValue = method.invoke(target, values);
        }
        catch (Exception e) {
            System.err.println("Error invoking requested method");
            e.printStackTrace();
            System.exit(1);
        }
        for (int i = 0; i < numParams; ++i) {
            if (!mustWrite[i]) continue;
            try {
                if (hasTarget && i == numParams - 1) {
                    Serializer.serialize(target, renamings[i]);
                    continue;
                }
                Serializer.serialize(values[i], renamings[i]);
                continue;
            }
            catch (Exception e) {
                System.err.println("Error serializing object parameter " + i + " with renaming " + renamings[i] + ", method " + methodName + ", class " + className);
                System.exit(1);
            }
        }
        if (retValue != null) {
            String renaming = args[pos + 1];
            try {
                Serializer.serialize(retValue, renaming);
            }
            catch (Exception e) {
                System.err.println("Error serializing object return value with renaming " + renaming + ", method " + methodName + ", class " + className);
                System.exit(1);
            }
        }
    }
}

