/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.components.impl;

import integratedtoolkit.comm.Comm;
import integratedtoolkit.components.impl.TaskDispatcher;
import integratedtoolkit.types.data.AccessParams;
import integratedtoolkit.types.data.DataAccessId;
import integratedtoolkit.types.data.DataInfo;
import integratedtoolkit.types.data.DataInstanceId;
import integratedtoolkit.types.data.FileInfo;
import integratedtoolkit.types.data.LogicalData;
import integratedtoolkit.types.data.ObjectInfo;
import integratedtoolkit.types.data.ResultFile;
import integratedtoolkit.types.data.Transferable;
import integratedtoolkit.types.data.location.DataLocation;
import integratedtoolkit.types.data.operation.DataOperation;
import integratedtoolkit.types.data.operation.FileTransferable;
import integratedtoolkit.types.data.operation.ObjectTransferable;
import integratedtoolkit.types.data.operation.OneOpWithSemListener;
import integratedtoolkit.types.data.operation.ResultListener;
import integratedtoolkit.types.request.ap.TransferObjectRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Logger;

public class DataInfoProvider {
    private static final String RES_FILE_TRANSFER_ERR = "Error transferring result files";
    private TaskDispatcher TD;
    private TreeMap<String, Integer> nameToId;
    private TreeMap<Integer, Integer> codeToId;
    private TreeMap<Integer, DataInfo> idToData;
    private TreeMap<String, Object> renamingToValue;
    private LinkedList<Integer> blockedData;
    private HashMap<String, Boolean> renamingToIsSerialized;
    LinkedList<String> pendingObsoleteRenamings = new LinkedList();
    private static final Logger logger = Logger.getLogger("integratedtoolkit.Components.TaskProcessor.DataInfoProvider");
    private static final boolean debug = logger.isDebugEnabled();

    public DataInfoProvider() {
        this.nameToId = new TreeMap();
        this.codeToId = new TreeMap();
        this.idToData = new TreeMap();
        this.renamingToValue = new TreeMap();
        this.renamingToIsSerialized = new HashMap();
        this.blockedData = new LinkedList();
        this.pendingObsoleteRenamings = new LinkedList();
        DataInfo.init();
        logger.info("Initialization finished");
    }

    public void setCoWorkers(TaskDispatcher TD) {
        this.TD = TD;
    }

    public DataAccessId registerDataAccess(AccessParams access) {
        if (access instanceof AccessParams.FileAccessParams) {
            AccessParams.FileAccessParams fAccess = (AccessParams.FileAccessParams)access;
            return this.registerFileAccess(fAccess.getMode(), fAccess.getLocation(), -1);
        }
        AccessParams.ObjectAccessParams oAccess = (AccessParams.ObjectAccessParams)access;
        return this.registerObjectAccess(oAccess.getMode(), oAccess.getValue(), oAccess.getCode(), -1);
    }

    public List<DataAccessId> registerDataAccesses(List<AccessParams> accesses, int readerMethodId) {
        ArrayList<DataAccessId> daIds = new ArrayList<DataAccessId>(accesses.size());
        for (AccessParams access : accesses) {
            if (access instanceof AccessParams.FileAccessParams) {
                AccessParams.FileAccessParams fAccess = (AccessParams.FileAccessParams)access;
                daIds.add(this.registerFileAccess(fAccess.getMode(), fAccess.getLocation(), readerMethodId));
                continue;
            }
            AccessParams.ObjectAccessParams oAccess = (AccessParams.ObjectAccessParams)access;
            daIds.add(this.registerObjectAccess(oAccess.getMode(), oAccess.getValue(), oAccess.getCode(), readerMethodId));
        }
        return daIds;
    }

    private DataAccessId registerFileAccess(AccessParams.AccessMode mode, DataLocation location, int readerId) {
        DataInfo fileInfo;
        String locationKey = location.getLocationKey();
        Integer fileId = this.nameToId.get(locationKey);
        if (fileId == null) {
            if (debug) {
                logger.debug("FIRST access to " + location.getLocationKey());
            }
            fileInfo = new FileInfo(location);
            fileId = fileInfo.getDataId();
            this.nameToId.put(locationKey, fileId);
            this.idToData.put(fileId, fileInfo);
            if (mode != AccessParams.AccessMode.W) {
                Comm.registerLocation(fileInfo.getLastDataInstanceId().getRenaming(), location);
            }
        } else {
            if (debug) {
                logger.debug("Another access to " + location.getLocationKey());
            }
            fileInfo = this.idToData.get(fileId);
        }
        return fileInfo.manageAccess(mode, readerId, debug, logger);
    }

    private DataAccessId registerObjectAccess(AccessParams.AccessMode mode, Object value, int code, int readerId) {
        DataInfo oInfo;
        Integer aoId = this.codeToId.get(code);
        if (aoId == null) {
            if (debug) {
                logger.debug("FIRST access to object " + code);
            }
            oInfo = new ObjectInfo(code);
            aoId = oInfo.getDataId();
            this.codeToId.put(code, aoId);
            this.idToData.put(aoId, oInfo);
            DataInstanceId lastDID = oInfo.getLastDataInstanceId();
            String renaming = lastDID.getRenaming();
            if (mode != AccessParams.AccessMode.W) {
                Comm.registerValue(renaming, value);
            }
        } else {
            if (debug) {
                logger.debug("Another access to object " + code);
            }
            oInfo = this.idToData.get(aoId);
        }
        return oInfo.manageAccess(mode, readerId, debug, logger);
    }

    public boolean alreadyAccessed(DataLocation loc) {
        String locationKey = loc.getLocationKey();
        Integer fileId = this.nameToId.get(locationKey);
        return fileId != null;
    }

    public String getLastRenaming(int code) {
        Integer aoId = this.codeToId.get(code);
        DataInfo oInfo = this.idToData.get(aoId);
        return oInfo.getLastDataInstanceId().getRenaming();
    }

    public DataLocation getOriginalLocation(int fileId) {
        FileInfo info = (FileInfo)this.idToData.get(fileId);
        return info.getOriginalLocation();
    }

    public void dataHasBeenRead(List<DataAccessId> dataIds, int readerId) {
        if (!this.pendingObsoleteRenamings.isEmpty() && this.blockedData.isEmpty()) {
            for (String renaming : this.pendingObsoleteRenamings) {
                Comm.removeData(renaming);
            }
            this.pendingObsoleteRenamings.clear();
        }
        for (DataAccessId dAccId : dataIds) {
            DataInfo fileInfo;
            Integer rDataId = null;
            Integer rVersionId = null;
            String rRenaming = null;
            Integer wDataId = null;
            Integer wVersionId = null;
            String wRenaming = null;
            if (dAccId instanceof DataAccessId.RAccessId) {
                rDataId = ((DataAccessId.RAccessId)dAccId).getReadDataInstance().getDataId();
                rVersionId = ((DataAccessId.RAccessId)dAccId).getReadDataInstance().getVersionId();
                rRenaming = ((DataAccessId.RAccessId)dAccId).getReadDataInstance().getRenaming();
            } else if (dAccId instanceof DataAccessId.RWAccessId) {
                rDataId = ((DataAccessId.RWAccessId)dAccId).getReadDataInstance().getDataId();
                rVersionId = ((DataAccessId.RWAccessId)dAccId).getReadDataInstance().getVersionId();
                rRenaming = ((DataAccessId.RWAccessId)dAccId).getReadDataInstance().getRenaming();
                wDataId = ((DataAccessId.RWAccessId)dAccId).getWrittenDataInstance().getDataId();
                wVersionId = ((DataAccessId.RWAccessId)dAccId).getWrittenDataInstance().getVersionId();
                wRenaming = ((DataAccessId.RWAccessId)dAccId).getWrittenDataInstance().getRenaming();
            } else {
                wDataId = ((DataAccessId.WAccessId)dAccId).getWrittenDataInstance().getDataId();
                wVersionId = ((DataAccessId.WAccessId)dAccId).getWrittenDataInstance().getVersionId();
                wRenaming = ((DataAccessId.WAccessId)dAccId).getWrittenDataInstance().getRenaming();
            }
            if (rDataId != null && (fileInfo = this.idToData.get(rDataId)).versionHasBeenRead(rVersionId, readerId) == 0 && (fileInfo.getLastVersionId() != rVersionId.intValue() || fileInfo.isToDelete())) {
                if (this.blockedData.contains(rDataId)) {
                    logger.debug("File " + rRenaming + " is in pending obsolete renamings");
                    this.pendingObsoleteRenamings.add(rRenaming);
                } else {
                    logger.debug("Detected file " + rRenaming + " as obsolete");
                    Comm.removeData(rRenaming);
                }
            }
            if (wDataId == null) continue;
            fileInfo = this.idToData.get(wDataId);
            if (fileInfo == null) {
                if (this.blockedData.contains(wDataId)) {
                    logger.debug("File " + wRenaming + " is in pending obsolete renamings");
                    this.pendingObsoleteRenamings.add(wRenaming);
                    continue;
                }
                logger.debug("Detected file " + wRenaming + " as obsolete");
                Comm.removeData(wRenaming);
                continue;
            }
            if (!fileInfo.isToDelete()) continue;
            this.idToData.remove(wDataId);
            if (this.blockedData.contains(wDataId)) {
                logger.debug("File " + wRenaming + " is in pending obsolete renamings");
                this.pendingObsoleteRenamings.add(wRenaming);
                continue;
            }
            logger.debug("Detected file " + wRenaming + " as obsolete");
            Comm.removeData(wRenaming);
        }
    }

    public void setObjectVersionValue(String renaming, Object value) {
        this.renamingToValue.put(renaming, value);
        Comm.registerValue(renaming, value);
    }

    public boolean isHere(DataInstanceId dId) {
        return this.renamingToValue.get(dId.getRenaming()) != null;
    }

    public Object getObject(String renaming) {
        return this.renamingToValue.get(renaming);
    }

    public void newVersionSameValue(String rRenaming, String wRenaming) {
        this.renamingToValue.put(wRenaming, this.renamingToValue.get(rRenaming));
    }

    public DataInstanceId getLastDataAccess(int code) {
        Integer aoId = this.codeToId.get(code);
        DataInfo oInfo = this.idToData.get(aoId);
        return oInfo.getLastDataInstanceId();
    }

    public List<DataInstanceId> getLastVersions(TreeSet<Integer> dataIds) {
        ArrayList<DataInstanceId> versionIds = new ArrayList<DataInstanceId>(dataIds.size());
        for (Integer dataId : dataIds) {
            DataInfo dataInfo = this.idToData.get(dataId);
            if (dataInfo != null) {
                versionIds.add(dataInfo.getLastDataInstanceId());
                continue;
            }
            versionIds.add(null);
        }
        return versionIds;
    }

    public void blockDataIds(TreeSet<Integer> dataIds) {
        this.blockedData.addAll(dataIds);
    }

    public void unblockDataId(Integer dataId) {
        this.blockedData.remove(dataId);
    }

    public FileInfo deleteData(DataLocation loc) {
        String locationKey = loc.getLocationKey();
        Integer fileId = this.nameToId.get(locationKey);
        if (fileId == null) {
            return null;
        }
        FileInfo fileInfo = (FileInfo)this.idToData.get(fileId);
        if (fileInfo.getReaders() == 0) {
            this.nameToId.remove(locationKey);
            this.idToData.remove(fileId);
            Comm.removeData(fileInfo.getLastDataInstanceId().getRenaming());
        } else {
            fileInfo.setToDelete(true);
        }
        return fileInfo;
    }

    public void transferObjectValue(TransferObjectRequest toRequest) {
        Semaphore sem = toRequest.getSemaphore();
        DataAccessId daId = toRequest.getDaId();
        DataAccessId.RWAccessId rwaId = (DataAccessId.RWAccessId)daId;
        String sourceName = rwaId.getReadDataInstance().getRenaming();
        LogicalData ld = Comm.getData(sourceName);
        if (ld.isInMemory()) {
            if (!ld.isOnFile()) {
                try {
                    ld.writeToFile();
                }
                catch (Exception e) {
                    logger.fatal("Exception  writing object to file.", e);
                }
            }
            ld.removeValue();
            toRequest.setResponse(ld.getValue());
            toRequest.getSemaphore().release();
        } else {
            DataLocation targetLocation = DataLocation.getLocation(Comm.appHost, Comm.appHost.getTempDirPath() + sourceName);
            Comm.appHost.getData(sourceName, targetLocation, (Transferable)new ObjectTransferable(), (DataOperation.EventListener)new OneOpWithSemListener(sem));
        }
    }

    public ResultFile blockDataAndGetResultFile(int dataId, ResultListener listener) {
        FileInfo fileInfo = (FileInfo)this.idToData.get(dataId);
        if (fileInfo != null) {
            String[] splitPath = fileInfo.getOriginalLocation().getPath().split(File.separator);
            String origName = splitPath[splitPath.length - 1];
            if (origName.startsWith("compss-serialized-obj_")) {
                if (debug) {
                    logger.debug("Discarding file " + origName + " as a result");
                }
                return null;
            }
            DataInstanceId lastVersion = fileInfo.getLastDataInstanceId();
            this.blockedData.add(dataId);
            ResultFile rf = new ResultFile(lastVersion, fileInfo.getOriginalLocation());
            DataInstanceId fId = rf.getFileInstanceId();
            String renaming = fId.getRenaming();
            while (renaming != null && !Comm.existsData(renaming)) {
                renaming = DataInstanceId.previousVersionRenaming(renaming);
            }
            if (renaming == null) {
                logger.error("Error transferring result files: Cannot transfer file " + fId.getRenaming() + " nor any of its previous versions");
                return null;
            }
            listener.addOperation();
            Comm.appHost.getData(renaming, rf.getOriginalLocation(), (Transferable)new FileTransferable(), (DataOperation.EventListener)listener);
            return rf;
        }
        return null;
    }

    public void shutdown() {
    }
}

