/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.components.scheduler.impl;

import integratedtoolkit.components.ResourceUser;
import integratedtoolkit.components.impl.TaskScheduler;
import integratedtoolkit.components.scheduler.SchedulerPolicies;
import integratedtoolkit.components.scheduler.impl.DefaultSchedulerPolicies;
import integratedtoolkit.types.Implementation;
import integratedtoolkit.types.Task;
import integratedtoolkit.types.resources.Worker;
import integratedtoolkit.util.CoreManager;
import integratedtoolkit.util.ResourceManager;
import integratedtoolkit.util.TaskSets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.PriorityQueue;

public class DefaultTaskScheduler
extends TaskScheduler {
    private static final int MAX_TASK = 100;
    private final TaskSets taskSets = new TaskSets();

    public DefaultTaskScheduler() {
        this.schedulerPolicies = new DefaultSchedulerPolicies();
        logger.info("Initialization finished");
    }

    @Override
    public void resizeDataStructures() {
        super.resizeDataStructures();
        this.taskSets.resizeDataStructures();
    }

    @Override
    public boolean isPendingWork(Integer coreId) {
        return this.taskSets.getToRescheduleCount(coreId) + this.taskSets.getNoResourceCount(coreId) + this.taskSets.getPriorityCount(coreId) + this.taskSets.getRegularCount(coreId) != 0;
    }

    @Override
    public void resourcesCreated(Worker<?> res) {
        super.resourcesCreated(res);
        logger.info("Resource " + res.getName() + " created");
        if (this.taskSets.getNoResourceCount() > 0) {
            int[] simTasks = res.getSimultaneousTasks();
            for (int coreId = 0; coreId < CoreManager.getCoreCount(); ++coreId) {
                if (this.taskSets.getNoResourceCount(coreId) <= 0 || simTasks[coreId] <= 0) continue;
                this.taskSets.resourceFound(coreId);
            }
        }
        this.scheduleToResource(res);
    }

    @Override
    public void reduceResource(Worker<?> res) {
    }

    @Override
    public void removeNode(Worker<?> res) {
        super.removeNode(res);
    }

    @Override
    public void scheduleTask(Task currentTask) {
        Worker chosenResource = null;
        int coreId = currentTask.getTaskParams().getId();
        if (currentTask.isSchedulingForced()) {
            chosenResource = this.JM.enfDataToService.get(currentTask.getEnforcingData().getDataId());
        }
        if (chosenResource != null) {
            logger.info("Task " + currentTask.getId() + " forced to run in " + chosenResource.getName());
            LinkedList<Implementation<?>> runnable = chosenResource.getRunnableImplementations(coreId);
            if (runnable.isEmpty()) {
                this.taskSets.newRegularTask(currentTask);
                logger.info("Pending: Task(" + currentTask.getId() + ", " + currentTask.getTaskParams().getName() + ") " + "Resource(" + chosenResource.getName() + ")");
            } else {
                LinkedList<Implementation<?>> run = this.schedulerPolicies.sortImplementationsForResource(runnable, chosenResource, this.profile);
                logger.info("Match: Task(" + currentTask.getId() + ", " + currentTask.getTaskParams().getName() + ") " + "Resource(" + chosenResource.getName() + ")");
                logger.info("Sending job " + currentTask + ", to res name " + chosenResource.getName() + ", resource " + chosenResource + ", with impl " + run.getFirst());
                this.sendJob(currentTask, chosenResource, run.getFirst());
            }
        } else {
            LinkedList<Worker<?>> validResources = ResourceManager.findCompatibleWorkers(coreId);
            if (validResources.isEmpty()) {
                this.taskSets.waitWithoutNode(currentTask);
                logger.info("Blocked: Task(" + currentTask.getId() + ", " + currentTask.getTaskParams().getName() + ") ");
            } else {
                HashMap<Worker<?>, LinkedList<Implementation<?>>> resourceToImpls = ResourceManager.findAvailableWorkers(validResources, coreId);
                PriorityQueue<SchedulerPolicies.ObjectValue<Worker<?>>> orderedResources = this.schedulerPolicies.sortResourcesForTask(currentTask, resourceToImpls.keySet(), this.profile);
                for (SchedulerPolicies.ObjectValue<Worker<?>> entry : orderedResources) {
                    chosenResource = (Worker)entry.o;
                    LinkedList<Implementation<?>> orderedImpls = this.schedulerPolicies.sortImplementationsForResource(resourceToImpls.get(chosenResource), chosenResource, this.profile);
                    logger.info("Match: Task(" + currentTask.getId() + ", " + currentTask.getTaskParams().getName() + ") " + "Resource(" + chosenResource.getName() + ")");
                    if (!this.sendJob(currentTask, chosenResource, orderedImpls.getFirst())) continue;
                    return;
                }
                if (currentTask.getTaskParams().hasPriority()) {
                    this.taskSets.newPriorityTask(currentTask);
                } else {
                    this.taskSets.newRegularTask(currentTask);
                }
                logger.info("Pending: Task(" + currentTask.getId() + ", " + currentTask.getTaskParams().getName() + ")");
            }
        }
    }

    @Override
    public void rescheduleTask(Task task, Worker<?> failedResource) {
        int coreId = task.getTaskParams().getId();
        LinkedList<Worker<?>> validResources = ResourceManager.findCompatibleWorkers(coreId);
        if (!validResources.isEmpty()) {
            HashMap<Worker<?>, LinkedList<Implementation<?>>> resourceToImpls = ResourceManager.findAvailableWorkers(validResources, coreId);
            resourceToImpls.remove(failedResource);
            PriorityQueue<SchedulerPolicies.ObjectValue<Worker<?>>> orderedResources = this.schedulerPolicies.sortResourcesForTask(task, resourceToImpls.keySet(), this.profile);
            for (SchedulerPolicies.ObjectValue<Worker<?>> entry : orderedResources) {
                Worker chosenResource = (Worker)entry.o;
                LinkedList<Implementation<?>> orderedImpls = this.schedulerPolicies.sortImplementationsForResource(resourceToImpls.get(chosenResource), chosenResource, this.profile);
                logger.info("Match: Task(" + task.getId() + ", " + task.getTaskParams().getName() + ") " + "Resource(" + chosenResource.getName() + ")");
                if (!this.sendJobRescheduled(task, chosenResource, orderedImpls.getFirst())) continue;
                return;
            }
            task.setLastResource(failedResource.getName());
            this.taskSets.newTaskToReschedule(task);
            logger.info("To Reschedule: Task(" + task.getId() + ", " + task.getTaskParams().getName() + ") ");
        } else {
            this.taskSets.newTaskToReschedule(task);
            task.setLastResource(failedResource.getName());
            logger.info("To Reschedule: Task(" + task.getId() + ", " + task.getTaskParams().getName() + ") ");
        }
    }

    @Override
    public boolean scheduleToResource(Worker<?> resource) {
        boolean assigned = false;
        LinkedList<Integer> compatibleCores = resource.getExecutableCores();
        LinkedList<Integer> executableCores = new LinkedList<Integer>();
        LinkedList[] fittingImplementations = new LinkedList[CoreManager.getCoreCount()];
        LinkedList<Implementation<?>>[] executableCoreImpls = resource.getRunnableImplementations();
        for (int coreId = 0; coreId < executableCoreImpls.length; ++coreId) {
            fittingImplementations[coreId] = this.schedulerPolicies.sortImplementationsForResource(resource.getRunnableImplementations(coreId), resource, this.profile);
        }
        if (this.taskSets.areTasksToReschedule()) {
            for (Integer coreId : compatibleCores) {
                if (fittingImplementations[coreId].isEmpty()) continue;
                executableCores.add(coreId);
            }
            LinkedList<Task>[] tasks = this.taskSets.getTasksToReschedule();
            assigned = this.assignTasks(tasks, executableCores, resource, fittingImplementations);
            executableCores.clear();
        }
        if (this.taskSets.arePriorityTasks()) {
            for (Integer coreId : compatibleCores) {
                if (fittingImplementations[coreId].isEmpty()) continue;
                executableCores.add(coreId);
            }
            LinkedList[] tasks = new LinkedList[CoreManager.getCoreCount()];
            for (Integer coreId : executableCores) {
                tasks[coreId.intValue()] = this.trimTaskList(this.taskSets.getPriorityTasks()[coreId]);
            }
            assigned = assigned || this.assignTasks(tasks, executableCores, resource, fittingImplementations);
            executableCores.clear();
        }
        if (this.taskSets.areRegularTasks()) {
            for (Integer coreId : compatibleCores) {
                if (fittingImplementations[coreId].isEmpty()) continue;
                executableCores.add(coreId);
            }
            LinkedList[] tasks = new LinkedList[CoreManager.getCoreCount()];
            for (Integer coreId : executableCores) {
                tasks[coreId.intValue()] = this.trimTaskList(this.taskSets.getRegularTasks()[coreId]);
            }
            assigned = assigned || this.assignTasks(tasks, executableCores, resource, fittingImplementations);
            executableCores.clear();
        }
        if (debug && !assigned) {
            logger.debug("Resource " + resource.getName() + " FREE");
        }
        return assigned;
    }

    private LinkedList<Task> trimTaskList(LinkedList<Task> original) {
        LinkedList<Task> result = new LinkedList<Task>();
        Iterator it = original.iterator();
        while (it.hasNext() && result.size() < 100) {
            result.add((Task)it.next());
        }
        return result;
    }

    private boolean assignTasks(LinkedList<Task>[] tasks, LinkedList<Integer> executableCores, Worker<?> resource, LinkedList<Implementation<?>>[] fittingImplementations) {
        boolean assigned = false;
        PriorityQueue[] sortedTasks = new PriorityQueue[CoreManager.getCoreCount()];
        LinkedList<Integer> unloadedCores = new LinkedList<Integer>();
        for (Integer coreId : executableCores) {
            if (tasks[coreId] == null || tasks[coreId].size() == 0) {
                unloadedCores.add(coreId);
                continue;
            }
            sortedTasks[coreId.intValue()] = this.schedulerPolicies.sortTasksForResource(resource, tasks[coreId], this.profile);
            if (!sortedTasks[coreId].isEmpty()) continue;
            unloadedCores.add(coreId);
        }
        for (Integer coreId : unloadedCores) {
            executableCores.remove(coreId);
        }
        while (!executableCores.isEmpty()) {
            Integer coreId = null;
            int maxValue = Integer.MIN_VALUE;
            for (Integer i : executableCores) {
                if (((SchedulerPolicies.ObjectValue)sortedTasks[i.intValue()].peek()).value <= maxValue) continue;
                maxValue = ((SchedulerPolicies.ObjectValue)sortedTasks[i.intValue()].peek()).value;
                coreId = i;
            }
            SchedulerPolicies.ObjectValue ov = (SchedulerPolicies.ObjectValue)sortedTasks[coreId].poll();
            Task t = (Task)ov.o;
            if (t.getLastResource() != null) {
                if (t.getLastResource().compareTo(resource.getName()) == 0) {
                    if (!sortedTasks[coreId].isEmpty()) continue;
                    executableCores.remove(coreId);
                    continue;
                }
                this.taskSets.rescheduledTask(t);
            } else if (t.getTaskParams().hasPriority()) {
                this.taskSets.priorityTaskScheduled(t);
            } else {
                this.taskSets.regularTaskScheduled(t);
            }
            if (this.sendJob(t, resource, fittingImplementations[coreId].get(0))) {
                assigned = true;
                if (sortedTasks[coreId].isEmpty()) {
                    executableCores.remove(coreId);
                }
            } else {
                sortedTasks[coreId].offer(ov);
            }
            unloadedCores.clear();
            for (Integer i : executableCores) {
                fittingImplementations[i.intValue()] = resource.canRunNow(fittingImplementations[t.getTaskParams().getId()]);
                if (!fittingImplementations[i].isEmpty()) continue;
                unloadedCores.add(i);
            }
            for (Integer i : unloadedCores) {
                executableCores.remove(i);
            }
        }
        return assigned;
    }

    @Override
    public void getWorkloadState(ResourceUser.WorkloadStatus ss) {
        super.getWorkloadState(ss);
        try {
            this.taskSets.getWorkloadState(ss);
        }
        catch (Exception e) {
            logger.fatal("Cannot get the current schedule", e);
            System.exit(1);
        }
    }

    @Override
    public String getCoresMonitoringData(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getCoresMonitoringData(prefix));
        sb.append(this.taskSets.getMonitoringInfo());
        return sb.toString();
    }
}

