/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.loader;

import integratedtoolkit.loader.CustomLoader;
import java.lang.reflect.Method;
import java.net.URL;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ITAppLoader {
    protected static final String ERROR_COMPSs_BASE_DIR = "ERROR: Cannot create .COMPSs base directory";
    private static final Logger logger = Logger.getLogger("integratedtoolkit.Loader");

    protected static void load(String chosenLoader, String appName, String[] appArgs) throws Exception {
        try (CustomLoader myLoader = null;){
            myLoader = new CustomLoader(new URL[0]);
            String itHome = System.getenv("IT_HOME");
            myLoader.addFile(itHome + "/compss-engine.jar");
            String loaderName = "integratedtoolkit.loader." + chosenLoader + ".ITAppModifier";
            Class<?> modifierClass = myLoader.loadClass(loaderName);
            Object modifier = modifierClass.newInstance();
            logger.debug("Modifying application " + appName + " with loader " + chosenLoader);
            Method method = modifierClass.getMethod("modify", String.class);
            Class modAppClass = (Class)method.invoke(modifier, appName);
            if (modAppClass != null) {
                logger.debug("Application " + appName + " instrumented, executing...");
                Method main = modAppClass.getDeclaredMethod("main", String[].class);
                main.invoke(null, new Object[]{appArgs});
            }
        }
    }

    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configure(System.getProperty("log4j.configuration"));
        if (args.length < 2) {
            logger.fatal("Error: missing arguments for loader");
            System.exit(1);
        }
        String[] appArgs = new String[args.length - 2];
        System.arraycopy(args, 2, appArgs, 0, appArgs.length);
        ITAppLoader.load(args[0], args[1], appArgs);
    }
}

