/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types;

import integratedtoolkit.util.CoreManager;
import java.util.HashMap;
import java.util.Map;

public class ResourcesState {
    private final HashMap<String, HostInfo> currentResources_nameToInfo = new HashMap();
    private final HashMap<String, HostInfo> pendingResources_nameToInfo = new HashMap();
    private boolean useCloud;
    private int currentCloudVMCount;
    private long creationTime;

    public void setUseCloud(boolean useCloud) {
        this.useCloud = useCloud;
    }

    public boolean getUseCloud() {
        return this.useCloud;
    }

    public void setCurrentCloudVMCount(int currentCloudVMCount) {
        this.currentCloudVMCount = currentCloudVMCount;
    }

    public int getCurrentCloudVMCount() {
        return this.currentCloudVMCount;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void addHost(String hostName, String type, int cpus, float memory, int[] coreSimultaneousTasks, boolean active) {
        HostInfo hi = new HostInfo(hostName, type, cpus, memory);
        hi.setCoreSlots(coreSimultaneousTasks);
        if (active) {
            this.currentResources_nameToInfo.put(hi.getHostName(), hi);
        } else {
            this.pendingResources_nameToInfo.put(hi.getHostName(), hi);
        }
    }

    public void updateHostInfo(String hostName, String type, int cpus, float memory, int coreId, int coreSimTasks, boolean active) {
        HostInfo hi = this.pendingResources_nameToInfo.get(hostName);
        if (hi == null && (hi = this.currentResources_nameToInfo.get(hostName)) == null) {
            hi = new HostInfo(hostName, type, cpus, memory);
            if (active) {
                this.currentResources_nameToInfo.put(hi.getHostName(), hi);
            } else {
                this.pendingResources_nameToInfo.put(hi.getHostName(), hi);
            }
        }
        hi.updateCoreSlots(coreId, coreSimTasks);
    }

    public String toString() {
        HostInfo hi;
        String resourceName;
        StringBuilder sb = new StringBuilder();
        sb.append("RESOURCES_INFO = [").append("\n");
        for (Map.Entry<String, HostInfo> entry : this.currentResources_nameToInfo.entrySet()) {
            resourceName = entry.getKey();
            hi = entry.getValue();
            sb.append("\t").append("RESOURCE = [").append("\n");
            sb.append("\t").append("\t").append("NAME = ").append(resourceName).append("\n");
            sb.append("\t").append("\t").append("TYPE = ").append(hi.getType()).append("\n");
            sb.append("\t").append("\t").append("CPUS = ").append(hi.getCPUS()).append("\n");
            sb.append("\t").append("\t").append("MEMORY = ").append(hi.getMemory()).append("\n");
            sb.append("\t").append("\t").append("CAN_RUN = [").append("\n");
            sb.append(hi.getCoreSlots("\t\t\t"));
            sb.append("\t").append("\t").append("]").append("\n");
            sb.append("\t").append("]").append("\n");
        }
        sb.append("]").append("\n");
        sb.append("CLOUD_INFO = [").append("\n");
        if (this.useCloud) {
            sb.append("\t").append("CURRENT_CLOUD_VM_COUNT = ").append(this.currentCloudVMCount).append("\n");
            sb.append("\t").append("CREATION_TIME = ").append(this.creationTime).append("\n");
            sb.append("\t").append("PENDING_RESOURCES = [").append("\n");
            for (Map.Entry<String, HostInfo> entry : this.pendingResources_nameToInfo.entrySet()) {
                resourceName = entry.getKey();
                hi = entry.getValue();
                sb.append("\t").append("RESOURCE = [").append("\n");
                sb.append("\t").append("\t").append("NAME = ").append(resourceName).append("\n");
                sb.append("\t").append("\t").append("TYPE = ").append(hi.getType()).append("\n");
                sb.append("\t").append("\t").append("CPUS = ").append(hi.getCPUS()).append("\n");
                sb.append("\t").append("\t").append("MEMORY = ").append(hi.getMemory()).append("\n");
                sb.append("\t").append("\t").append("CAN_RUN = [").append("\n");
                sb.append(hi.getCoreSlots("\t\t\t"));
                sb.append("\t").append("\t").append("]").append("\n");
                sb.append("\t").append("]").append("\n");
            }
            sb.append("\t").append("]").append("\n");
        }
        sb.append("]");
        return sb.toString();
    }

    private static class HostInfo {
        private String hostName;
        private String type;
        private int cpus;
        private float memory;
        private int[] coreSlots;

        public HostInfo(String hostName, String type, int cpus, float memory) {
            this.hostName = hostName;
            this.type = type;
            this.cpus = cpus;
            this.memory = memory;
            this.coreSlots = new int[CoreManager.getCoreCount()];
        }

        public String getHostName() {
            return this.hostName;
        }

        public String getType() {
            return this.type.toString();
        }

        public int getCPUS() {
            return this.cpus;
        }

        public double getMemory() {
            return this.memory;
        }

        public String getCoreSlots(String prefix) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.coreSlots.length; ++i) {
                sb.append(prefix).append("CORE = [").append("\n");
                sb.append(prefix).append("\t").append("COREID = ").append(i).append("\n");
                sb.append(prefix).append("\t").append("NUM_SLOTS = ").append(this.coreSlots[i]).append("\n");
                sb.append(prefix).append("]").append("\n");
            }
            return sb.toString();
        }

        public void setCoreSlots(int[] coreSlots) {
            this.coreSlots = coreSlots;
        }

        public void updateCoreSlots(int coreId, int coreSimTasks) {
            if (coreId < this.coreSlots.length) {
                int n = coreId;
                this.coreSlots[n] = this.coreSlots[n] + coreSimTasks;
            }
        }
    }
}

