/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.data;

import integratedtoolkit.comm.Comm;
import integratedtoolkit.types.data.location.DataLocation;
import integratedtoolkit.types.data.location.URI;
import integratedtoolkit.types.data.operation.Copy;
import integratedtoolkit.types.data.operation.SafeCopyListener;
import integratedtoolkit.types.resources.Resource;
import integratedtoolkit.util.Serializer;
import integratedtoolkit.util.SharedDiskManager;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Logger;

public class LogicalData {
    protected String name;
    protected Object value;
    protected boolean onFile;
    protected final TreeSet<DataLocation> locations = new TreeSet();
    private static final ConcurrentHashMap<String, LinkedList<CopyInProgress>> inProgress = new ConcurrentHashMap();
    public static final TreeMap<Resource, HashSet<LogicalData>> hostToPrivateFiles = new TreeMap();
    public static final TreeMap<String, HashSet<LogicalData>> sharedDiskToSharedFiles = new TreeMap();
    private boolean isBeingSaved = false;
    private Semaphore removeHostLock = new Semaphore(1);
    private static final Logger logger = Logger.getLogger("integratedtoolkit.Communication");

    public LogicalData() {
    }

    public LogicalData(String name) {
        this.name = name;
        this.value = null;
        this.onFile = false;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<Resource> getAllHosts() {
        HashSet<Resource> list = new HashSet<Resource>();
        TreeSet<DataLocation> treeSet = this.locations;
        synchronized (treeSet) {
            for (DataLocation loc : this.locations) {
                list.addAll(loc.getHosts());
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<URI> getURIs() {
        LinkedList<URI> list = new LinkedList<URI>();
        TreeSet<DataLocation> treeSet = this.locations;
        synchronized (treeSet) {
            for (DataLocation loc : this.locations) {
                list.addAll(loc.getURIs());
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<URI> getRepresentativeURIs() {
        LinkedList<URI> list = new LinkedList<URI>();
        TreeSet<DataLocation> treeSet = this.locations;
        synchronized (treeSet) {
            for (DataLocation loc : this.locations) {
                list.addAll(loc.getURIs());
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocation(DataLocation loc) {
        TreeSet<DataLocation> treeSet = this.locations;
        synchronized (treeSet) {
            this.isBeingSaved = false;
            this.locations.add(loc);
            switch (loc.getType()) {
                case PRIVATE: {
                    for (Resource host : loc.getHosts()) {
                        HashSet<LogicalData> files;
                        if (host == null) {
                            host = Comm.appHost;
                        }
                        if ((files = hostToPrivateFiles.get(host)) == null) {
                            files = new HashSet();
                            hostToPrivateFiles.put(host, files);
                        }
                        files.add(this);
                    }
                    if (!loc.getPath().startsWith(File.separator)) break;
                    this.onFile = true;
                    break;
                }
                case SHARED: {
                    String shared = loc.getSharedDisk();
                    HashSet<LogicalData> files = sharedDiskToSharedFiles.get(shared);
                    if (files == null) {
                        files = new HashSet();
                        sharedDiskToSharedFiles.put(shared, files);
                    }
                    files.add(this);
                    this.onFile = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeValue() {
        DataLocation location = DataLocation.getLocation(Comm.appHost, this.name);
        Object val = this.value;
        TreeSet<DataLocation> treeSet = this.locations;
        synchronized (treeSet) {
            this.value = null;
            this.locations.remove(location);
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataLocation removeHostAndCheckLocationToSave(Resource host, HashMap<String, String> sharedMountPoints) {
        this.lockHostRemove();
        DataLocation hostLocation = null;
        boolean hasToSave = true;
        if (this.isBeingSaved) {
            this.releaseHostRemoveLock();
            return null;
        }
        TreeSet<DataLocation> treeSet = this.locations;
        synchronized (treeSet) {
            Iterator<DataLocation> it = this.locations.iterator();
            while (it.hasNext()) {
                DataLocation loc = it.next();
                if (loc.getType() == DataLocation.Type.PRIVATE) {
                    if (loc.getURIInHost(host) != null) {
                        hostLocation = loc;
                        it.remove();
                        continue;
                    }
                    this.releaseHostRemoveLock();
                    return null;
                }
                if (loc.getHosts().isEmpty()) {
                    String sharedDisk = loc.getSharedDisk();
                    if (sharedDisk != null) {
                        String mountPoint = sharedMountPoints.get(sharedDisk);
                        if (mountPoint != null) {
                            hostLocation = DataLocation.getPrivateLocation(host, mountPoint + loc.getPath());
                            continue;
                        }
                        this.releaseHostRemoveLock();
                        return null;
                    }
                    this.releaseHostRemoveLock();
                    return null;
                }
                this.releaseHostRemoveLock();
                return null;
            }
        }
        if (hasToSave) {
            this.isBeingSaved = true;
            this.releaseHostRemoveLock();
            return hostLocation;
        }
        this.releaseHostRemoveLock();
        return null;
    }

    public boolean isInMemory() {
        return this.value != null;
    }

    public boolean isOnFile() {
        return this.onFile;
    }

    public void setValue(Object o) {
        this.value = o;
    }

    public Object getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile() throws Exception {
        TreeSet<DataLocation> treeSet = this.locations;
        synchronized (treeSet) {
            String path = Comm.appHost.getWorkingDirectory() + this.name;
            DataLocation loc = DataLocation.getLocation(Comm.appHost, path);
            Serializer.serialize(this.value, path);
            this.addLocation(loc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Copy> getCopiesInProgress() {
        LinkedList<CopyInProgress> stored = inProgress.get(this.name);
        if (stored == null) {
            return null;
        }
        LinkedList<Copy> copies = new LinkedList<Copy>();
        LinkedList<CopyInProgress> linkedList = stored;
        synchronized (linkedList) {
            for (CopyInProgress cp : stored) {
                copies.add(cp.getCopy());
            }
        }
        return copies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI alreadyAvailable(Resource targetHost) {
        TreeSet<DataLocation> treeSet = this.locations;
        synchronized (treeSet) {
            for (DataLocation loc : this.locations) {
                URI u = loc.getURIInHost(targetHost);
                if (u == null) continue;
                return u;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Copy alreadyCopying(DataLocation target) {
        LinkedList<CopyInProgress> copying = inProgress.get(this.name);
        if (copying != null) {
            LinkedList<CopyInProgress> linkedList = copying;
            synchronized (linkedList) {
                for (CopyInProgress cip : copying) {
                    if (!cip.hasTarget(target)) continue;
                    return cip.getCopy();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCopy(Copy c, DataLocation target) {
        LinkedList<CopyInProgress> cips;
        Serializable serializable = inProgress;
        synchronized (serializable) {
            cips = inProgress.get(this.name);
            if (cips == null) {
                cips = new LinkedList();
                inProgress.put(this.name, cips);
            }
        }
        serializable = cips;
        synchronized (serializable) {
            cips.add(new CopyInProgress(c, target));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataLocation finishedCopy(Copy c) {
        DataLocation loc = null;
        ConcurrentHashMap<String, LinkedList<CopyInProgress>> concurrentHashMap = inProgress;
        synchronized (concurrentHashMap) {
            LinkedList<CopyInProgress> cips;
            LinkedList<CopyInProgress> linkedList = cips = inProgress.get(this.name);
            synchronized (linkedList) {
                Iterator it = cips.iterator();
                while (it.hasNext()) {
                    CopyInProgress cip = (CopyInProgress)it.next();
                    if (cip.c != c) continue;
                    it.remove();
                    loc = cip.loc;
                    break;
                }
                if (cips.isEmpty()) {
                    inProgress.remove(this.name);
                }
            }
        }
        return loc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Logical Data name: ").append(this.name).append(":\n");
        sb.append("\t Value: ").append(this.value).append("\n");
        sb.append("\t Locations:\n");
        TreeSet<DataLocation> treeSet = this.locations;
        synchronized (treeSet) {
            for (DataLocation dl : this.locations) {
                sb.append("\t\t * ").append(dl).append("\n");
            }
        }
        return sb.toString();
    }

    public static HashSet<LogicalData> getAllDataFromHost(Resource host) {
        LinkedList<String> shareds = SharedDiskManager.getAllSharedNames(host);
        if (shareds.isEmpty()) {
            if (hostToPrivateFiles.get(host) != null) {
                return hostToPrivateFiles.get(host);
            }
            return new HashSet<LogicalData>();
        }
        HashSet<LogicalData> data = new HashSet<LogicalData>();
        for (String shared : shareds) {
            HashSet<LogicalData> sharedData = sharedDiskToSharedFiles.get(shared);
            if (sharedData == null) continue;
            data.addAll(sharedData);
        }
        if (hostToPrivateFiles.get(host) != null) {
            data.addAll((Collection<LogicalData>)hostToPrivateFiles.get(host));
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyToInProgressCopiesEnd(SafeCopyListener listener) {
        LinkedList<CopyInProgress> copies = inProgress.get(this.name);
        if (copies != null) {
            LinkedList<CopyInProgress> linkedList = copies;
            synchronized (linkedList) {
                for (CopyInProgress copy : copies) {
                    listener.addOperation();
                    copy.c.addEventListener(listener);
                }
            }
        }
    }

    public void isObsolete() {
        for (Resource res : this.getAllHosts()) {
            res.addObsolete(this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromFile() throws Exception {
        TreeSet<DataLocation> treeSet = this.locations;
        synchronized (treeSet) {
            if (this.value != null) {
                return;
            }
            for (DataLocation loc : this.locations) {
                URI u = loc.getURIInHost(Comm.appHost);
                if (u == null) continue;
                String path = u.getPath();
                if (path.startsWith("/")) {
                    this.value = Serializer.deserialize(path);
                    DataLocation tgtLoc = DataLocation.getLocation(Comm.appHost, this.name);
                    this.addLocation(tgtLoc);
                }
                return;
            }
        }
        if (this.value == null) {
            throw new Exception("File does not exists in the master");
        }
    }

    public void lockHostRemove() {
        try {
            this.removeHostLock.acquire();
        }
        catch (InterruptedException e) {
            logger.error(e);
        }
    }

    public void releaseHostRemoveLock() {
        this.removeHostLock.release();
    }

    public boolean isBeingSaved() {
        return this.isBeingSaved;
    }

    private static class CopyInProgress {
        private final Copy c;
        private final DataLocation loc;

        CopyInProgress(Copy c, DataLocation loc) {
            this.c = c;
            this.loc = loc;
        }

        public Copy getCopy() {
            return this.c;
        }

        private boolean hasTarget(DataLocation target) {
            return this.loc.isTarget(target);
        }

        public String toString() {
            return this.c.getName() + " to " + this.loc.toString();
        }
    }
}

