/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.request.ap;

import integratedtoolkit.components.impl.DataInfoProvider;
import integratedtoolkit.components.impl.TaskAnalyser;
import integratedtoolkit.components.impl.TaskDispatcher;
import integratedtoolkit.types.data.ResultFile;
import integratedtoolkit.types.data.operation.ResultListener;
import integratedtoolkit.types.request.ap.APRequest;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;

public class GetResultFilesRequest
extends APRequest {
    private Long appId;
    private Semaphore sem;
    private LinkedList<ResultFile> blockedData;

    public GetResultFilesRequest(Long appId, Semaphore sem) {
        this.appId = appId;
        this.sem = sem;
        this.blockedData = new LinkedList();
    }

    public Long getAppId() {
        return this.appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Semaphore getSemaphore() {
        return this.sem;
    }

    public void setSemaphore(Semaphore sem) {
        this.sem = sem;
    }

    public LinkedList<ResultFile> getBlockedData() {
        return this.blockedData;
    }

    @Override
    public void process(TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) {
        ResultListener listener = new ResultListener(this.sem);
        TreeSet<Integer> writtenDataIds = ta.getAndRemoveWrittenFiles(this.appId);
        if (writtenDataIds != null) {
            for (int dataId : writtenDataIds) {
                ResultFile rf = dip.blockDataAndGetResultFile(dataId, listener);
                if (rf == null) continue;
                this.blockedData.add(rf);
            }
            listener.enable();
        } else {
            this.sem.release();
        }
    }

    @Override
    public APRequest.APRequestType getRequestType() {
        return APRequest.APRequestType.BLOCK_AND_GET_RESULT_FILES;
    }
}

