/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.request.ap;

import integratedtoolkit.comm.Comm;
import integratedtoolkit.components.impl.DataInfoProvider;
import integratedtoolkit.components.impl.TaskAnalyser;
import integratedtoolkit.components.impl.TaskDispatcher;
import integratedtoolkit.types.data.DataAccessId;
import integratedtoolkit.types.data.DataInstanceId;
import integratedtoolkit.types.data.LogicalData;
import integratedtoolkit.types.data.Transferable;
import integratedtoolkit.types.data.location.DataLocation;
import integratedtoolkit.types.data.operation.DataOperation;
import integratedtoolkit.types.data.operation.FileTransferable;
import integratedtoolkit.types.data.operation.OneOpWithSemListener;
import integratedtoolkit.types.request.ap.APRequest;
import java.util.concurrent.Semaphore;

public class TransferOpenFileRequest
extends APRequest {
    private DataAccessId faId;
    private DataLocation location;
    private Semaphore sem;

    public TransferOpenFileRequest(DataAccessId faId, Semaphore sem) {
        this.faId = faId;
        this.sem = sem;
    }

    public Semaphore getSemaphore() {
        return this.sem;
    }

    public void setSemaphore(Semaphore sem) {
        this.sem = sem;
    }

    public DataAccessId getFaId() {
        return this.faId;
    }

    public void setFaId(DataAccessId faId) {
        this.faId = faId;
    }

    public DataLocation getLocation() {
        return this.location;
    }

    public void setLocation(DataLocation location) {
        this.location = location;
    }

    @Override
    public void process(TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) {
        DataLocation targetLocation;
        logger.debug("Process TransferOpenFileRequest");
        if (this.faId instanceof DataAccessId.WAccessId) {
            DataAccessId.WAccessId waId = (DataAccessId.WAccessId)this.faId;
            DataInstanceId targetFile = waId.getWrittenDataInstance();
            String targetName = targetFile.getRenaming();
            targetLocation = DataLocation.getLocation(Comm.appHost, Comm.appHost.getTempDirPath() + targetName);
            logger.debug(targetFile + " to be opened as " + targetLocation);
            Comm.registerLocation(targetName, targetLocation);
            this.sem.release();
        } else if (this.faId instanceof DataAccessId.RWAccessId) {
            DataAccessId.RWAccessId waId = (DataAccessId.RWAccessId)this.faId;
            String srcName = waId.getReadDataInstance().getRenaming();
            String targetName = waId.getWrittenDataInstance().getRenaming();
            targetLocation = DataLocation.getLocation(Comm.appHost, Comm.appHost.getTempDirPath() + targetName);
            Comm.appHost.getData(srcName, targetName, (LogicalData)null, (Transferable)new FileTransferable(), (DataOperation.EventListener)new OneOpWithSemListener(this.sem));
        } else {
            DataAccessId.RAccessId waId = (DataAccessId.RAccessId)this.faId;
            String srcName = waId.getReadDataInstance().getRenaming();
            String targetName = waId.getReadDataInstance().getRenaming();
            targetLocation = DataLocation.getLocation(Comm.appHost, Comm.appHost.getTempDirPath() + targetName);
            Comm.appHost.getData(srcName, srcName, (Transferable)new FileTransferable(), (DataOperation.EventListener)new OneOpWithSemListener(this.sem));
        }
        this.setLocation(targetLocation);
    }

    @Override
    public APRequest.APRequestType getRequestType() {
        return APRequest.APRequestType.TRANSFER_OPEN_FILE;
    }
}

