/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.request.td;

import integratedtoolkit.components.ResourceUser;
import integratedtoolkit.components.impl.JobManager;
import integratedtoolkit.components.impl.TaskScheduler;
import integratedtoolkit.types.request.td.TDRequest;
import integratedtoolkit.util.CoreManager;
import integratedtoolkit.util.ResourceManager;
import java.util.concurrent.Semaphore;

public class ShutdownRequest
extends TDRequest {
    private Semaphore semaphore;

    public ShutdownRequest(Semaphore sem) {
        this.semaphore = sem;
    }

    public Semaphore getSemaphore() {
        return this.semaphore;
    }

    public void setSemaphore(Semaphore sem) {
        this.semaphore = sem;
    }

    @Override
    public TDRequest.TDRequestType getRequestType() {
        return TDRequest.TDRequestType.SHUTDOWN;
    }

    @Override
    public void process(TaskScheduler ts, JobManager jm) throws ShutdownException {
        jm.shutdown();
        ResourceUser.WorkloadStatus status = new ResourceUser.WorkloadStatus(CoreManager.getCoreCount());
        ts.getWorkloadState(status);
        ResourceManager.stopNodes(status);
        this.semaphore.release();
        throw new ShutdownException();
    }

    public static class ShutdownException
    extends Exception {
    }
}

