/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import integratedtoolkit.ITConstants;
import integratedtoolkit.types.Implementation;
import integratedtoolkit.types.MethodImplementation;
import integratedtoolkit.types.ServiceImplementation;
import integratedtoolkit.types.annotations.Constraints;
import integratedtoolkit.types.annotations.Method;
import integratedtoolkit.types.annotations.MultiConstraints;
import integratedtoolkit.types.annotations.Parameter;
import integratedtoolkit.types.annotations.Service;
import integratedtoolkit.types.resources.MethodResourceDescription;
import integratedtoolkit.util.CoreManager;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class CEIParser {
    private static ITConstants.Lang lang = ITConstants.Lang.JAVA;
    private static final Logger logger = Logger.getLogger("integratedtoolkit.Components.TaskDispatcher.TaskScheduler");
    private static final boolean debug = logger.isDebugEnabled();
    private static final String CONSTR_LOAD_ERR = "Error loading constraints";

    public static LinkedList<Integer> parse() {
        LinkedList<Integer> updatedCores = new LinkedList();
        switch (lang) {
            case JAVA: {
                String appName = System.getProperty("it.appName");
                try {
                    updatedCores = CEIParser.loadJava(Class.forName(appName + "Itf"));
                    break;
                }
                catch (ClassNotFoundException ex) {
                    throw new CoreManager.UndefinedConstraintsSourceException(appName + "Itf class cannot be found.");
                }
            }
            case C: {
                String constraintsFile = System.getProperty("it.constraints.file");
                updatedCores = CEIParser.loadC(constraintsFile);
                break;
            }
            case PYTHON: {
                updatedCores = CEIParser.loadPython();
                break;
            }
            default: {
                throw new CoreManager.LangNotDefinedException();
            }
        }
        return updatedCores;
    }

    public static LinkedList<Integer> loadJava(Class<?> annotItfClass) {
        LinkedList<Integer> updatedMethods = new LinkedList<Integer>();
        int coreCount = annotItfClass.getDeclaredMethods().length;
        if (debug) {
            logger.debug("Detected methods " + coreCount);
        }
        if (CoreManager.getCoreCount() == 0) {
            CoreManager.resizeStructures(coreCount);
        } else {
            CoreManager.resizeStructures(CoreManager.getCoreCount() + coreCount);
        }
        for (java.lang.reflect.Method m : annotItfClass.getDeclaredMethods()) {
            if (debug) {
                logger.debug("Evaluating method " + m.getName());
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append(m.getName()).append("(");
            int numPars = m.getParameterAnnotations().length;
            if (numPars > 0) {
                String type = CEIParser.inferType(m.getParameterTypes()[0], ((Parameter)m.getParameterAnnotations()[0][0]).type());
                buffer.append(type);
                for (int i = 1; i < numPars; ++i) {
                    type = CEIParser.inferType(m.getParameterTypes()[i], ((Parameter)m.getParameterAnnotations()[i][0]).type());
                    buffer.append(",").append(type);
                }
            }
            buffer.append(")");
            if (m.isAnnotationPresent(Method.class)) {
                int i;
                String methodSignature = buffer.toString();
                Method methodAnnot = m.getAnnotation(Method.class);
                String[] declaringClasses = methodAnnot.declaringClass();
                int implementationCount = declaringClasses.length;
                String[] signatures = new String[implementationCount];
                for (int i2 = 0; i2 < signatures.length; ++i2) {
                    signatures[i2] = methodSignature + declaringClasses[i2];
                }
                Integer methodId = CoreManager.getCoreId(signatures);
                updatedMethods.add(methodId);
                if (methodId == CoreManager.getCoreCount()) {
                    CoreManager.increaseCoreCount();
                }
                MethodResourceDescription defaultConstraints = new MethodResourceDescription();
                MethodResourceDescription[] implConstraints = new MethodResourceDescription[implementationCount];
                if (m.isAnnotationPresent(Constraints.class)) {
                    defaultConstraints = new MethodResourceDescription(m.getAnnotation(Constraints.class));
                }
                if (m.isAnnotationPresent(MultiConstraints.class)) {
                    MultiConstraints mc = m.getAnnotation(MultiConstraints.class);
                    mc.value();
                    for (int i3 = 0; i3 < implementationCount; ++i3) {
                        MethodResourceDescription specificConstraints = new MethodResourceDescription(mc.value()[i3]);
                        specificConstraints.join(defaultConstraints);
                        if (specificConstraints.getProcessorCoreCount() == 0) {
                            specificConstraints.setProcessorCoreCount(1);
                        }
                        implConstraints[i3] = specificConstraints;
                    }
                } else {
                    for (i = 0; i < implementationCount; ++i) {
                        implConstraints[i] = defaultConstraints;
                        if (defaultConstraints.getProcessorCoreCount() != 0) continue;
                        defaultConstraints.setProcessorCoreCount(1);
                    }
                }
                for (i = 0; i < implementationCount; ++i) {
                    CEIParser.loadMethodConstraints(methodId, implementationCount, declaringClasses, implConstraints);
                }
                continue;
            }
            Service serviceAnnot = m.getAnnotation(Service.class);
            buffer.append(serviceAnnot.namespace()).append(',').append(serviceAnnot.name()).append(',').append(serviceAnnot.port());
            String signature = buffer.toString();
            Integer methodId = CoreManager.getCoreId(new String[]{signature});
            if (methodId == CoreManager.getCoreCount()) {
                CoreManager.increaseCoreCount();
                updatedMethods.add(methodId);
            }
            CEIParser.loadServiceConstraints(methodId, serviceAnnot);
        }
        return updatedMethods;
    }

    private static void loadServiceConstraints(int coreId, Service service) {
        Implementation[] implementations = new Implementation[]{new ServiceImplementation(coreId, service.namespace(), service.name(), service.port(), service.operation())};
        CoreManager.registerImplementations(coreId, implementations);
    }

    private static void loadMethodConstraints(int coreId, int implementationCount, String[] declaringClasses, MethodResourceDescription[] cts) {
        Implementation[] implementations = new Implementation[implementationCount];
        for (int i = 0; i < implementationCount; ++i) {
            if (cts[i].getProcessorCoreCount() == 0) {
                cts[i].setProcessorCoreCount(1);
            }
            implementations[i] = new MethodImplementation(declaringClasses[i], coreId, i, cts[i]);
        }
        CoreManager.registerImplementations(coreId, implementations);
    }

    private static LinkedList<Integer> loadC(String constraintsFile) {
        LinkedList<Integer> updatedMethods = new LinkedList<Integer>();
        HashMap<Integer, MethodImplementation> readMethods = new HashMap<Integer, MethodImplementation>();
        MethodResourceDescription defaultCtr = new MethodResourceDescription();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(constraintsFile));
            int coreCount = 0;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("//")) continue;
                StringBuilder buffer = new StringBuilder();
                if (!line.matches(".*[(].*[)].*;")) continue;
                line = line.replaceAll("[(|)|,|;]", " ");
                String[] splits = line.split("\\s+");
                String methodName = splits[1];
                buffer.append(methodName).append("(");
                for (int i = 2; i < splits.length; ++i) {
                    String paramDirection = splits[i++];
                    String paramType = splits[i++];
                    String type = "OBJECT_T";
                    if (paramDirection.toUpperCase().compareTo("INOUT") == 0) {
                        type = "FILE_T";
                    } else if (paramDirection.toUpperCase().compareTo("OUT") == 0) {
                        type = "FILE_T";
                    } else if (paramType.toUpperCase().compareTo("FILE") == 0) {
                        type = "FILE_T";
                    } else if (paramType.compareTo("boolean") == 0) {
                        type = "BOOLEAN_T";
                    } else if (paramType.compareTo("char") == 0) {
                        type = "CHAR_T";
                    } else if (paramType.compareTo("int") == 0) {
                        type = "INT_T";
                    } else if (paramType.compareTo("float") == 0) {
                        type = "FLOAT_T";
                    } else if (paramType.compareTo("double") == 0) {
                        type = "DOUBLE_T";
                    } else if (paramType.compareTo("byte") == 0) {
                        type = "BYTE_T";
                    } else if (paramType.compareTo("short") == 0) {
                        type = "SHORT_T";
                    } else if (paramType.compareTo("long") == 0) {
                        type = "LONG_T";
                    } else if (paramType.compareTo("string") == 0) {
                        type = "STRING_T";
                    }
                    buffer.append(type).append(",");
                }
                buffer.deleteCharAt(buffer.lastIndexOf(","));
                buffer.append(")");
                String declaringClass = "NULL";
                buffer.append(declaringClass);
                String signature = buffer.toString();
                Integer methodId = CoreManager.getCoreId(new String[]{signature});
                updatedMethods.add(methodId);
                MethodImplementation m = new MethodImplementation(declaringClass, methodId, 0, new MethodResourceDescription(defaultCtr));
                readMethods.put(methodId, m);
                ++coreCount;
            }
            CoreManager.resizeStructures(coreCount);
            for (int i = 0; i < coreCount; ++i) {
                Implementation[] implementations = new Implementation[]{(Implementation)readMethods.get(i)};
                CoreManager.registerImplementations(i, implementations);
            }
            CoreManager.setCoreCount(coreCount);
            br.close();
        }
        catch (Exception e) {
            logger.fatal(CONSTR_LOAD_ERR, e);
        }
        return updatedMethods;
    }

    private static LinkedList<Integer> loadPython() {
        Integer coreCount;
        String countProp = System.getProperty("it.core.count");
        if (countProp == null) {
            coreCount = 50;
            if (debug) {
                logger.debug("Warning: using " + coreCount + " as default for number of task types");
            }
        } else {
            coreCount = Integer.parseInt(countProp);
        }
        CoreManager.resizeStructures(coreCount);
        for (int i = 0; i < coreCount; ++i) {
            Implementation[] implementations = new Implementation[]{new MethodImplementation("", i, 0, new MethodResourceDescription())};
            CoreManager.registerImplementations(i, implementations);
        }
        CoreManager.setCoreCount(coreCount);
        LinkedList<Integer> updatedMethods = new LinkedList<Integer>();
        for (int i = 0; i < coreCount; ++i) {
            updatedMethods.add(i);
        }
        return updatedMethods;
    }

    private static String inferType(Class<?> formalType, Parameter.Type annotType) {
        if (annotType.equals((Object)Parameter.Type.UNSPECIFIED)) {
            if (formalType.isPrimitive()) {
                if (formalType.equals(Boolean.TYPE)) {
                    return "BOOLEAN_T";
                }
                if (formalType.equals(Character.TYPE)) {
                    return "CHAR_T";
                }
                if (formalType.equals(Byte.TYPE)) {
                    return "BYTE_T";
                }
                if (formalType.equals(Short.TYPE)) {
                    return "SHORT_T";
                }
                if (formalType.equals(Integer.TYPE)) {
                    return "INT_T";
                }
                if (formalType.equals(Long.TYPE)) {
                    return "LONG_T";
                }
                if (formalType.equals(Float.TYPE)) {
                    return "FLOAT_T";
                }
                return "DOUBLE_T";
            }
            return "OBJECT_T";
        }
        return (Object)((Object)annotType) + "_T";
    }

    static {
        String l = System.getProperty("it.lang");
        lang = ITConstants.Lang.JAVA;
        if (l != null) {
            if (l.equalsIgnoreCase("c")) {
                lang = ITConstants.Lang.C;
            } else if (l.equalsIgnoreCase("python")) {
                lang = ITConstants.Lang.PYTHON;
            }
        }
    }
}

