/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import integratedtoolkit.types.Task;
import integratedtoolkit.util.ElementNotFoundException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class Graph<K, T> {
    private Map<K, Node<T>> graph = new TreeMap<K, Node<T>>();

    public T get(K key) {
        Node<T> n = this.graph.get(key);
        if (n == null) {
            return null;
        }
        return n.getElement();
    }

    public Set<T> getPredecessors(K key) throws ElementNotFoundException {
        Node<T> n = this.graph.get(key);
        if (n == null) {
            throw new ElementNotFoundException();
        }
        return n.getPredecessors();
    }

    public Set<T> getSuccessors(K key) throws ElementNotFoundException {
        Node<T> n = this.graph.get(key);
        if (n == null) {
            throw new ElementNotFoundException();
        }
        return n.getSuccessors();
    }

    public Iterator<T> getIteratorOverPredecessors(K key) throws ElementNotFoundException {
        Node<T> n = this.graph.get(key);
        if (n == null) {
            throw new ElementNotFoundException();
        }
        return n.getIteratorOverPredecessors();
    }

    public Iterator<T> getIteratorOverSuccessors(K key) throws ElementNotFoundException {
        Node<T> n = this.graph.get(key);
        if (n == null) {
            throw new ElementNotFoundException();
        }
        return n.getIteratorOverSuccessors();
    }

    public int getSize() {
        return this.graph.size();
    }

    public boolean hasPredecessors(K key) throws ElementNotFoundException {
        return !this.getPredecessors(key).isEmpty();
    }

    public boolean hasSuccessors(K key) throws ElementNotFoundException {
        return !this.getSuccessors(key).isEmpty();
    }

    public void addNode(K key, T element) {
        this.graph.put(key, new Node<T>(element));
    }

    public void addEdge(K sourceKey, K destKey) throws ElementNotFoundException {
        Node<T> pred = this.graph.get(sourceKey);
        Node<T> succ = this.graph.get(destKey);
        if (pred == null || succ == null) {
            throw new ElementNotFoundException("Cannot add the edge: predecessor and/or successor don't exist");
        }
        pred.addSuccessor(succ.getElement());
        succ.addPredecessor(pred.getElement());
    }

    public T removeNode(K key) {
        Node<T> n = this.graph.remove(key);
        if (n != null) {
            return n.getElement();
        }
        return null;
    }

    public void removeEdge(K sourceKey, K destKey) throws ElementNotFoundException {
        Node<T> pred = this.graph.get(sourceKey);
        Node<T> succ = this.graph.get(destKey);
        if (pred == null || succ == null) {
            throw new ElementNotFoundException("Cannot remove the edge: predecessor and/or successor don't exist");
        }
        pred.removeSuccessor(succ.getElement());
        succ.removePredecessor(pred.getElement());
    }

    public void clear() {
        this.graph.clear();
    }

    public String getGraphDotFormat() {
        StringBuilder nodes = new StringBuilder();
        StringBuilder edges = new StringBuilder();
        for (Map.Entry<K, Node<T>> e : this.graph.entrySet()) {
            Task t = (Task)e.getValue().getElement();
            nodes.append(t.getDotDescription()).append("\n");
            for (T task : e.getValue().getSuccessors()) {
                edges.append(e.getKey()).append(" -> ").append(((Task)task).getId()).append("\n");
            }
        }
        return nodes.toString() + edges.toString();
    }

    private class Node<E> {
        private E element;
        private TreeSet<E> predecessors;
        private TreeSet<E> successors;

        public Node(E element) {
            this.element = element;
            this.predecessors = new TreeSet();
            this.successors = new TreeSet();
        }

        public E getElement() {
            return this.element;
        }

        public Set<E> getPredecessors() {
            return this.predecessors;
        }

        public Set<E> getSuccessors() {
            return this.successors;
        }

        public Iterator<E> getIteratorOverPredecessors() {
            return ((Set)this.predecessors.clone()).iterator();
        }

        public Iterator<E> getIteratorOverSuccessors() {
            return ((Set)this.successors.clone()).iterator();
        }

        public void addPredecessor(E pred) {
            this.predecessors.add(pred);
        }

        public void addSuccessor(E succ) {
            this.successors.add(succ);
        }

        public void removePredecessor(E pred) {
            this.predecessors.remove(pred);
        }

        public void removeSuccessor(E succ) {
            this.successors.remove(succ);
        }
    }
}

