/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.connectors;

import integratedtoolkit.connectors.Connector;
import integratedtoolkit.connectors.ConnectorException;
import integratedtoolkit.connectors.Cost;
import integratedtoolkit.connectors.VM;
import integratedtoolkit.connectors.utils.CreationThread;
import integratedtoolkit.connectors.utils.DeletionThread;
import integratedtoolkit.connectors.utils.Operations;
import integratedtoolkit.types.ResourceCreationRequest;
import integratedtoolkit.types.resources.CloudMethodWorker;
import integratedtoolkit.types.resources.ShutdownListener;
import integratedtoolkit.types.resources.description.CloudMethodResourceDescription;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;

public abstract class AbstractConnector
implements Connector,
Operations,
Cost {
    private float currentCostPerHour;
    private final float deletedMachinesCost;
    private long meanCreationTime;
    private int createdVMs;
    protected String providerName;
    private final ConcurrentHashMap<String, VM> IPToVM;
    private final ConcurrentHashMap<Object, Long> powerOnVMTimestamp;
    private boolean terminate = false;
    private boolean check = false;
    private final DeadlineThread dead;
    private final TreeSet<VM> vmsToDelete;
    private final LinkedList<VM> vmsAlive;
    public static final long ONE_HOUR = 3600000L;
    public static final long FIFTY_EIGHT_MIN = 3480000L;
    public static final long FIFTY_MIN = 3000000L;
    public static final long FIVE_MIN = 300000L;
    public static final long TWO_MIN = 120000L;
    public static final long TEN_MIN = 600000L;
    public static final long ONE_MIN = 60000L;
    public static final long HALF_MIN = 30000L;
    protected static long INITIAL_CREATION_TIME = 120000L;
    protected static long MINIM_DEADLINE_INTERVAL = 120000L;
    protected static long DELETE_SAFETY_INTERVAL = 30000L;

    public AbstractConnector(String providerName, HashMap<String, String> props) {
        this.providerName = providerName;
        this.IPToVM = new ConcurrentHashMap();
        this.powerOnVMTimestamp = new ConcurrentHashMap();
        this.vmsToDelete = new TreeSet();
        this.vmsAlive = new LinkedList();
        String creationTimeStr = props.get("estimated-creation-time");
        this.meanCreationTime = creationTimeStr != null ? (long)(Integer.parseInt(creationTimeStr) * 1000) : INITIAL_CREATION_TIME;
        logger.debug((Object)("Initial mean creation time is" + this.meanCreationTime));
        this.createdVMs = 0;
        this.currentCostPerHour = 0.0f;
        this.deletedMachinesCost = 0.0f;
        this.terminate = false;
        this.check = false;
        this.dead = new DeadlineThread();
        this.dead.start();
        Runtime.getRuntime().addShutdownHook(new Ender(this));
    }

    @Override
    public boolean turnON(String name, ResourceCreationRequest rR) {
        if (this.terminate) {
            return false;
        }
        logger.info((Object)("Requesting a resource creation " + name + " : " + rR.getRequested().toString()));
        VM vmInfo = this.tryToReuseVM(rR.getRequested());
        if (vmInfo != null) {
            logger.info((Object)("Reusing VM: " + vmInfo));
            CreationThread ct = new CreationThread(this, vmInfo.getName(), this.providerName, rR, vmInfo);
            ct.start();
            return true;
        }
        try {
            CreationThread ct = new CreationThread(this, name, this.providerName, rR, null);
            ct.start();
        }
        catch (Exception e) {
            logger.info((Object)"ResourceRequest failed");
            return false;
        }
        return true;
    }

    private synchronized VM tryToReuseVM(CloudMethodResourceDescription requested) {
        String imageReq = requested.getImage().getName();
        VM reusedVM = null;
        for (VM vm : this.vmsToDelete) {
            if (!vm.rd.getImage().getName().equals(imageReq) || vm.rd.getProcessorCoreCount() < requested.getProcessorCoreCount() || vm.rd.getMemoryPhysicalSize() < requested.getMemoryPhysicalSize() || vm.rd.getStorageElemSize() < requested.getStorageElemSize()) continue;
            reusedVM = vm;
            reusedVM.setToDelete(false);
            this.vmsToDelete.remove(reusedVM);
            break;
        }
        return reusedVM;
    }

    @Override
    public void stopReached() {
        this.check = true;
    }

    @Override
    public Long getNextCreationTime() throws ConnectorException {
        return this.meanCreationTime;
    }

    @Override
    public void terminate(CloudMethodWorker worker, CloudMethodResourceDescription reduction) {
        new DeletionThread(this, worker, reduction).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminateAll() {
        this.terminate = true;
        this.dead.terminate();
        for (VM vm : this.IPToVM.values()) {
            logger.info((Object)("Destroying VM " + vm.getName()));
            Semaphore sem = new Semaphore(0);
            ShutdownListener sl = new ShutdownListener(sem);
            vm.getWorker().stop(false, sl);
            sl.enable();
            try {
                sem.acquire();
            }
            catch (Exception e) {
                logger.error((Object)"ERROR: Exception raised on worker shutdown");
            }
            try {
                this.destroy(vm.getEnvId());
            }
            catch (Exception e) {
                logger.error((Object)("Error while trying to shut down the virtual machine " + vm.getName()), (Throwable)e);
            }
        }
        AbstractConnector abstractConnector = this;
        synchronized (abstractConnector) {
            this.IPToVM.clear();
            this.vmsToDelete.clear();
            this.vmsAlive.clear();
        }
    }

    @Override
    public Object poweron(String name, CloudMethodResourceDescription rd) throws ConnectorException {
        long requestTime = System.currentTimeMillis();
        Object vmId = this.create(name, rd);
        this.powerOnVMTimestamp.put(vmId, new Long(requestTime));
        return vmId;
    }

    public abstract Object create(String var1, CloudMethodResourceDescription var2) throws ConnectorException;

    @Override
    public VM waitCreation(Object envId, CloudMethodResourceDescription requested) throws ConnectorException {
        CloudMethodResourceDescription granted = this.waitUntilCreation(envId, requested);
        VM vm = new VM(envId, granted);
        vm.requestTime = this.powerOnVMTimestamp.remove(envId);
        logger.info((Object)("Virtual machine created: " + vm));
        float oneHourCost = this.getMachineCostPerHour(granted).floatValue();
        this.currentCostPerHour += oneHourCost;
        this.addMachine(vm);
        return vm;
    }

    public abstract CloudMethodResourceDescription waitUntilCreation(Object var1, CloudMethodResourceDescription var2) throws ConnectorException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void vmReady(VM vmInfo) throws ConnectorException {
        AbstractConnector abstractConnector = this;
        synchronized (abstractConnector) {
            vmInfo.startTime = System.currentTimeMillis();
            vmInfo.computeCreationTime();
            long totaltime = this.meanCreationTime * (long)this.createdVMs;
            ++this.createdVMs;
            this.meanCreationTime = (totaltime += vmInfo.creationTime) / (long)this.createdVMs;
            logger.debug((Object)("New mean creation time :" + this.meanCreationTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VM pause(CloudMethodWorker worker) {
        String ip = worker.getName();
        VM vmInfo = this.IPToVM.get(ip);
        if (this.canBeSaved(vmInfo)) {
            logger.info((Object)("Virtual machine saved: " + vmInfo));
            vmInfo.setToDelete(true);
            AbstractConnector abstractConnector = this;
            synchronized (abstractConnector) {
                this.vmsToDelete.add(vmInfo);
            }
            return null;
        }
        return vmInfo;
    }

    @Override
    public void poweroff(VM vm) throws ConnectorException {
        this.destroy(vm.getEnvId());
        this.removeMachine(vm);
    }

    private long getNumSlots(long time1, long time2) {
        long dif = time1 - time2;
        long slotTime = this.getTimeSlot();
        if (slotTime <= 0L) {
            return time1 - time2;
        }
        long numSlots = dif / slotTime;
        if (dif % slotTime > 0L) {
            ++numSlots;
        }
        return numSlots;
    }

    private synchronized void addMachine(VM vmInfo) {
        String ip = vmInfo.getName();
        this.IPToVM.put(ip, vmInfo);
        this.vmsAlive.add(vmInfo);
    }

    private synchronized void removeMachine(VM vmInfo) {
        this.IPToVM.remove(vmInfo.getName());
        this.vmsAlive.remove(vmInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Float getTotalCost() {
        float aliveMachinesCost = 0.0f;
        AbstractConnector abstractConnector = this;
        synchronized (abstractConnector) {
            long now = System.currentTimeMillis();
            for (VM vm : this.vmsAlive) {
                long numSlots = this.getNumSlots(now, vm.getStartTime());
                float pricePerSlot = this.getMachineCostPerTimeSlot(vm.rd);
                aliveMachinesCost += (float)numSlots * pricePerSlot;
            }
        }
        float totalCost = aliveMachinesCost + this.deletedMachinesCost;
        return Float.valueOf(totalCost);
    }

    public abstract float getMachineCostPerTimeSlot(CloudMethodResourceDescription var1);

    @Override
    public abstract long getTimeSlot();

    @Override
    public Float currentCostPerHour() {
        return Float.valueOf(this.currentCostPerHour);
    }

    @Override
    public Float getMachineCostPerHour(CloudMethodResourceDescription rc) {
        if (this.getTimeSlot() > 0L) {
            return Float.valueOf(this.getMachineCostPerTimeSlot(rc) * 3600000.0f / (float)this.getTimeSlot());
        }
        return Float.valueOf(this.getMachineCostPerTimeSlot(rc));
    }

    @Override
    public boolean getTerminate() {
        return this.terminate;
    }

    @Override
    public boolean getCheck() {
        return this.check;
    }

    private boolean canBeSaved(VM vmInfo) {
        long now = System.currentTimeMillis();
        long vmStart = vmInfo.getStartTime();
        long limit = this.getTimeSlot();
        if (limit <= 0L) {
            return false;
        }
        long dif = now - vmStart;
        long mod = dif % limit;
        return mod < limit - DELETE_SAFETY_INTERVAL;
    }

    private class Ender
    extends Thread {
        final AbstractConnector ac;

        public Ender(AbstractConnector ac) {
            this.ac = ac;
        }

        @Override
        public void run() {
            for (VM vm : AbstractConnector.this.IPToVM.values()) {
                try {
                    Connector.logger.info((Object)("Destroying VM " + vm.getName()));
                    this.ac.destroy(vm.getEnvId());
                }
                catch (Exception e) {
                    Connector.logger.info((Object)("Error while trying to shut down the virtual machine " + vm.getName()));
                }
            }
        }
    }

    private class DeadlineThread
    extends Thread {
        private boolean keepGoing = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread.currentThread().setName("Connector " + AbstractConnector.this.providerName + " deadline");
            long sleepTime = 1000L;
            while (this.keepGoing) {
                try {
                    Connector.logger.debug((Object)("Deadline thread sleeps " + sleepTime + " ms."));
                    Thread.sleep(sleepTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                AbstractConnector abstractConnector = AbstractConnector.this;
                synchronized (abstractConnector) {
                    if (AbstractConnector.this.vmsAlive.isEmpty()) {
                        long slTime = this.getSleepTime();
                        sleepTime = AbstractConnector.this.meanCreationTime > slTime ? AbstractConnector.this.meanCreationTime : slTime;
                        Connector.logger.debug((Object)("No VMs alive deadline sleep set to " + sleepTime + " ms."));
                        continue;
                    }
                    sleepTime = this.getSleepTime();
                    Connector.logger.debug((Object)("VMs alive initial sleep se to " + sleepTime + " ms."));
                    for (VM vmInfo : AbstractConnector.this.vmsAlive) {
                        long timeLeft = this.timeLeft(vmInfo.getStartTime());
                        if (timeLeft < DELETE_SAFETY_INTERVAL) {
                            if (!vmInfo.isToDelete()) continue;
                            Connector.logger.info((Object)("Deleting vm " + vmInfo.getName() + " because is marked to delete and it is on the safety delete interval"));
                            AbstractConnector.this.vmsAlive.pollFirst();
                            AbstractConnector.this.vmsToDelete.remove(vmInfo);
                            DeletionThread dt = new DeletionThread(AbstractConnector.this, vmInfo);
                            dt.start();
                            continue;
                        }
                        if (sleepTime <= timeLeft - DELETE_SAFETY_INTERVAL) continue;
                        sleepTime = timeLeft - DELETE_SAFETY_INTERVAL;
                        Connector.logger.debug((Object)("Reseting sleep time because a interval near to finish " + sleepTime + " ms."));
                    }
                }
            }
        }

        private long getSleepTime() {
            long time = AbstractConnector.this.getTimeSlot();
            if (time <= 0L) {
                return MINIM_DEADLINE_INTERVAL - DELETE_SAFETY_INTERVAL;
            }
            return time - DELETE_SAFETY_INTERVAL;
        }

        public void terminate() {
            this.keepGoing = false;
            this.interrupt();
        }

        private long timeLeft(long time) {
            long now = System.currentTimeMillis();
            long limit = AbstractConnector.this.getTimeSlot();
            if (limit <= 0L) {
                return 0L;
            }
            long result = limit - (now - time) % limit;
            return result;
        }
    }
}

