/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudstack.domain.IPForwardingRule;
import org.jclouds.cloudstack.domain.NIC;
import org.jclouds.cloudstack.domain.Tag;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Location;
import org.jclouds.location.predicates.LocationPredicates;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.InetAddresses2;
import org.jclouds.util.Throwables2;

@Singleton
public class VirtualMachineToNodeMetadata
implements Function<VirtualMachine, NodeMetadata> {
    public static final Map<VirtualMachine.State, NodeMetadata.Status> vmStateToNodeStatus = ImmutableMap.builder().put(VirtualMachine.State.STARTING, NodeMetadata.Status.PENDING).put(VirtualMachine.State.RUNNING, NodeMetadata.Status.RUNNING).put(VirtualMachine.State.STOPPING, NodeMetadata.Status.PENDING).put(VirtualMachine.State.STOPPED, NodeMetadata.Status.SUSPENDED).put(VirtualMachine.State.DESTROYED, NodeMetadata.Status.TERMINATED).put(VirtualMachine.State.EXPUNGING, NodeMetadata.Status.TERMINATED).put(VirtualMachine.State.MIGRATING, NodeMetadata.Status.PENDING).put(VirtualMachine.State.ERROR, NodeMetadata.Status.ERROR).put(VirtualMachine.State.UNKNOWN, NodeMetadata.Status.UNRECOGNIZED).put(VirtualMachine.State.SHUTDOWNED, NodeMetadata.Status.PENDING).put(VirtualMachine.State.UNRECOGNIZED, NodeMetadata.Status.UNRECOGNIZED).build();
    private final Supplier<Set<? extends Location>> locations;
    private final Supplier<Set<? extends Image>> images;
    private final LoadingCache<String, Set<IPForwardingRule>> getIPForwardingRulesByVirtualMachine;
    private final GroupNamingConvention nodeNamingConvention;

    @Inject
    VirtualMachineToNodeMetadata(@Memoized Supplier<Set<? extends Location>> locations, @Memoized Supplier<Set<? extends Image>> images, LoadingCache<String, Set<IPForwardingRule>> getIPForwardingRulesByVirtualMachine, GroupNamingConvention.Factory namingConvention) {
        this.nodeNamingConvention = Preconditions.checkNotNull(namingConvention, "namingConvention").createWithoutPrefix();
        this.locations = Preconditions.checkNotNull(locations, "locations");
        this.images = Preconditions.checkNotNull(images, "images");
        this.getIPForwardingRulesByVirtualMachine = Preconditions.checkNotNull(getIPForwardingRulesByVirtualMachine, "getIPForwardingRulesByVirtualMachine");
    }

    @Override
    public NodeMetadata apply(final VirtualMachine from) {
        HashSet<String> privateAddresses;
        HashSet<String> publicAddresses;
        NodeMetadataBuilder builder;
        block14: {
            builder = new NodeMetadataBuilder();
            builder.ids(from.getId() + "");
            builder.name(from.getName());
            builder.hostname(from.getDisplayName());
            builder.location(FluentIterable.from(this.locations.get()).firstMatch(LocationPredicates.idEquals(from.getZoneId())).orNull());
            if (from.getGroup() != null) {
                builder.group(from.getGroup());
            } else if (from.getDisplayName() != null) {
                builder.group(this.nodeNamingConvention.groupInUniqueNameOrNull(from.getDisplayName()));
            }
            Image image = FluentIterable.from(this.images.get()).firstMatch(new Predicate<Image>(){

                @Override
                public boolean apply(Image input) {
                    return input.getProviderId().equals(from.getTemplateId() + "") && (input.getLocation() == null || input.getId().equals(from.getZoneId() + ""));
                }
            }).orNull();
            if (image != null) {
                builder.imageId(image.getId());
                builder.operatingSystem(image.getOperatingSystem());
            }
            if (!from.getTags().isEmpty()) {
                ImmutableMap.Builder<String, String> tagsBuilder = ImmutableMap.builder();
                for (Tag tag : from.getTags()) {
                    tagsBuilder.put(tag.getKey(), tag.getValue());
                }
                ImmutableMap tagMap = tagsBuilder.build();
                ((NodeMetadataBuilder)builder.tags((Iterable)Maps.filterValues(tagMap, Predicates.equalTo("jclouds-empty-tag-placeholder")).keySet())).userMetadata(Maps.filterValues(tagMap, Predicates.not(Predicates.equalTo("jclouds-empty-tag-placeholder"))));
            }
            builder.hardware(new HardwareBuilder().ids(from.getServiceOfferingId() + "").name(from.getServiceOfferingName() + "").processors(ImmutableList.of(new Processor(from.getCpuCount(), from.getCpuSpeed()))).ram((int)from.getMemory()).hypervisor(from.getHypervisor()).build());
            builder.status(vmStateToNodeStatus.get((Object)from.getState()));
            publicAddresses = Sets.newHashSet();
            privateAddresses = Sets.newHashSet();
            if (from.getIPAddress() != null) {
                boolean isPrivate = InetAddresses2.isPrivateIPAddress(from.getIPAddress());
                if (isPrivate) {
                    privateAddresses.add(from.getIPAddress());
                } else {
                    publicAddresses.add(from.getIPAddress());
                }
            }
            if (from.getPublicIP() != null) {
                publicAddresses.add(from.getPublicIP());
            }
            for (NIC nic : from.getNICs()) {
                if (nic.getIPAddress() == null) continue;
                if (InetAddresses2.isPrivateIPAddress(nic.getIPAddress())) {
                    privateAddresses.add(nic.getIPAddress());
                    continue;
                }
                publicAddresses.add(nic.getIPAddress());
            }
            try {
                Iterables.addAll(publicAddresses, Iterables.transform(Iterables.filter((Iterable)this.getIPForwardingRulesByVirtualMachine.getUnchecked(from.getId()), new Predicate<IPForwardingRule>(){

                    @Override
                    public boolean apply(IPForwardingRule rule) {
                        return !"Deleting".equals(rule.getState());
                    }
                }), new Function<IPForwardingRule, String>(){

                    @Override
                    public String apply(IPForwardingRule rule) {
                        return rule.getIPAddress();
                    }
                }));
            }
            catch (UncheckedExecutionException e) {
                if (Throwables2.getFirstThrowableOfType(e, ResourceNotFoundException.class) != null) break block14;
                Throwables.propagateIfPossible(e.getCause());
                throw e;
            }
        }
        return builder.privateAddresses(privateAddresses).publicAddresses(publicAddresses).build();
    }
}

