/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.utils;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import org.jclouds.util.Strings2;

public class Queries {
    private static final Function<String, Multimap<String, String>> parseQueryToDecodedMap = new Function<String, Multimap<String, String>>(){

        @Override
        public Multimap<String, String> apply(String in) {
            LinkedListMultimap<String, String> map = LinkedListMultimap.create();
            if (in != null) {
                if (in.indexOf(38) == -1) {
                    if (in.indexOf(61) != -1) {
                        Queries.parseKeyValueFromStringToDecodedMap(in, map);
                    } else {
                        map.put(in, null);
                    }
                } else {
                    for (String part : Splitter.on('&').split(in)) {
                        Queries.parseKeyValueFromStringToDecodedMap(part, map);
                    }
                }
            }
            return map;
        }
    };

    public static Function<String, Multimap<String, String>> queryParser() {
        return parseQueryToDecodedMap;
    }

    private static void parseKeyValueFromStringToDecodedMap(String stringToParse, Multimap<String, String> map) {
        int indexOfFirstEquals = stringToParse.indexOf(61);
        String key = indexOfFirstEquals == -1 ? stringToParse : stringToParse.substring(0, indexOfFirstEquals);
        String value = indexOfFirstEquals == -1 ? null : stringToParse.substring(indexOfFirstEquals + 1);
        map.put(Strings2.urlDecode(key), Strings2.urlDecode(value));
    }

    public static String encodeQueryLine(Multimap<String, ?> queryParams) {
        if (queryParams.isEmpty()) {
            return null;
        }
        return Queries.buildQueryLine(queryParams, new EncodeAndAppendParam());
    }

    public static String encodeQueryLine(Multimap<String, ?> queryParams, Iterable<Character> skips) {
        if (queryParams.isEmpty()) {
            return null;
        }
        return Queries.buildQueryLine(queryParams, new EncodeAndAppendParam(skips));
    }

    public static String buildQueryLine(Multimap<String, ?> queryParams) {
        if (queryParams.isEmpty()) {
            return null;
        }
        return Queries.buildQueryLine(queryParams, new AppendParam());
    }

    private static String buildQueryLine(Multimap<String, ?> queryParams, AppendParam appendParam) {
        StringBuilder queryBuilder = appendParam.b;
        for (Map.Entry<String, ?> pair : queryParams.entries()) {
            queryBuilder.append('&');
            appendParam.appendKey(pair.getKey());
            if (pair.getValue() != null) {
                queryBuilder.append('=');
            }
            if (pair.getValue() == null || pair.getValue().equals("")) continue;
            appendParam.appendValue(pair.getValue());
        }
        queryBuilder.deleteCharAt(0);
        return queryBuilder.toString();
    }

    private static class EncodeAndAppendParam
    extends AppendParam {
        private Iterable<Character> skips;

        private EncodeAndAppendParam() {
            this(ImmutableList.of(Character.valueOf('/'), Character.valueOf(',')));
        }

        private EncodeAndAppendParam(Iterable<Character> skips) {
            this.skips = skips;
        }

        @Override
        void append(Object in) {
            super.append(Strings2.urlEncode(in.toString(), this.skips));
        }
    }

    private static class AppendParam {
        final StringBuilder b = new StringBuilder();

        private AppendParam() {
        }

        private void appendKey(String key) {
            this.append(key);
        }

        private void appendValue(Object val) {
            this.append(val);
        }

        void append(Object in) {
            this.b.append(in.toString());
        }
    }
}

