/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.security.sshtrilead;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gridlab.gat.CouldNotInitializeCredentialException;
import org.gridlab.gat.CredentialExpiredException;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.InvalidUsernameOrPasswordException;
import org.gridlab.gat.URI;
import org.gridlab.gat.security.cpi.SecurityContextCreator;
import org.gridlab.gat.security.cpi.SecurityContextUtils;
import org.gridlab.gat.security.sshtrilead.SshTrileadContextCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SshTrileadSecurityUtils {
    public static Map<String, Object> getSshTrileadCredential(GATContext context, String adaptorName, URI location, int defaultPort) throws CouldNotInitializeCredentialException, CredentialExpiredException, InvalidUsernameOrPasswordException {
        Object data = SecurityContextUtils.getSecurityUserData((GATContext)context, (String)adaptorName, (String)"sshtrilead", (URI)location, (int)defaultPort, (SecurityContextCreator)new SshTrileadContextCreator());
        return (Map)data;
    }

    protected static Map<String, Object> getDefaultUserInfo(GATContext gatContext, URI location) throws CouldNotInitializeCredentialException, CredentialExpiredException, InvalidUsernameOrPasswordException {
        HashMap<String, Object> securityInfo = new HashMap<String, Object>();
        securityInfo.put("username", SecurityContextUtils.getUser((GATContext)gatContext, null, (URI)location));
        securityInfo.put("keyfile", SshTrileadSecurityUtils.getDefaultPrivateKeyfile());
        securityInfo.put("default", "");
        return securityInfo;
    }

    protected static File getDefaultPrivateKeyfile() {
        String keyfile = null;
        String home = System.getProperty("user.home");
        String fileSep = System.getProperty("file.separator");
        home = home == null ? "" : home + fileSep;
        keyfile = home + ".ssh" + fileSep + "id_dsa";
        File keyf = new File(keyfile);
        if (!(keyf.exists() || (keyf = new File(keyfile = home + ".ssh" + fileSep + "id_rsa")).exists() || (keyf = new File(keyfile = home + ".ssh" + fileSep + "identity")).exists() || (keyf = new File(keyfile = home + "ssh" + fileSep + "id_dsa")).exists() || (keyf = new File(keyfile = home + "ssh" + fileSep + "id_rsa")).exists() || (keyf = new File(keyfile = home + "ssh" + fileSep + "identity")).exists())) {
            return null;
        }
        return keyf;
    }
}

