/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.nio.event;

import es.bsc.comm.CommException;
import es.bsc.comm.EventManager;
import es.bsc.comm.event.Event;
import es.bsc.comm.nio.NIOConnection;
import es.bsc.comm.nio.event.NIOEvent;
import java.nio.channels.SocketChannel;

public class ErrorEvent
extends NIOEvent {
    private final CommException exception;

    public ErrorEvent(SocketChannel sc, CommException e) {
        super(sc, null);
        this.exception = e;
    }

    public Exception getException() {
        return this.exception;
    }

    @Override
    public Event.EventType getEventType() {
        return Event.EventType.ERROR;
    }

    @Override
    public void processEventOnConnection(EventManager<?> ntm) {
        if (this.sc != null) {
            this.connection = NIOConnection.getConnection(this.sc);
            this.connection.error(this.exception);
        } else {
            ntm.notifyError(null, null, this.exception);
        }
    }

    public String toString() {
        if (this.sc != null) {
            return "Error event on socket socket@" + this.sc.hashCode() + " caused by " + this.exception;
        }
        return "Error event caused by " + this.exception;
    }
}

