/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.transfers;

import es.bsc.comm.CommException;
import es.bsc.comm.Connection;
import es.bsc.comm.EventManager;
import es.bsc.comm.InternalConnection;
import es.bsc.comm.nio.NIOException;
import es.bsc.comm.nio.NIOProperties;
import es.bsc.comm.transfers.Transfer;
import es.bsc.comm.util.Serializer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.LinkedList;

public class SendTransfer
extends Transfer {
    private static int tokens = NIOProperties.MAX_SENDS;
    private static LinkedList<InternalConnection> pausedConnections = new LinkedList();
    protected InputStream streamIn;
    protected boolean failed = false;

    public SendTransfer(Transfer.Type type, byte[] array) {
        this.type = type;
        this.destination = Transfer.Destination.ARRAY;
        this.array = array;
        this.remainingSize = 0L;
    }

    public SendTransfer(Transfer.Type type, Object o) {
        this.type = type;
        this.destination = Transfer.Destination.OBJECT;
        this.object = o;
        this.remainingSize = 0L;
    }

    public SendTransfer(String name) {
        this.type = Transfer.Type.DATA;
        this.destination = Transfer.Destination.FILE;
        this.fileName = name;
        this.remainingSize = 0L;
    }

    private void setSize() {
        long length = 0L;
        if (this.destination == Transfer.Destination.OBJECT || this.destination == Transfer.Destination.ARRAY) {
            length = this.array.length;
        } else if (this.destination == Transfer.Destination.FILE) {
            File f = new File(this.fileName);
            length = f.length();
        }
        this.setSize(length);
    }

    private void openStream() {
        try {
            if (this.destination == Transfer.Destination.FILE) {
                this.streamIn = new FileInputStream(this.fileName);
            } else {
                if (this.destination == Transfer.Destination.OBJECT) {
                    this.array = Serializer.serialize(this.object);
                }
                this.streamIn = new ByteArrayInputStream(this.array);
            }
        }
        catch (IOException e) {
            LOGGER.error("Exception openning stream for " + this, e);
        }
    }

    public int readFirst(ByteBuffer bb) {
        int bytes = 0;
        try {
            bb.putLong(this.totalSize);
            bb.putInt(this.type.ordinal());
            bb.putInt(this.destination.ordinal());
            bytes = this.streamIn.read(bb.array(), 16, NIOProperties.PACKET_SIZE - 16);
            if (bytes != -1) {
                bb.position(bytes + 16);
                this.remainingSize -= (long)bytes;
            }
            bb.flip();
            if (this.remainingSize == 0L) {
                this.closeStream();
            }
        }
        catch (IOException e) {
            LOGGER.error("Exception reading first buffer for " + this, e);
        }
        return bytes;
    }

    public int read(ByteBuffer bb) throws IOException {
        int bytes = this.streamIn.read(bb.array());
        if (bytes != -1) {
            bb.position(bytes);
            this.remainingSize -= (long)bytes;
        }
        bb.flip();
        if (this.remainingSize == 0L) {
            this.closeStream();
        }
        return bytes;
    }

    private void closeStream() {
        try {
            this.streamIn.close();
        }
        catch (IOException e) {
            LOGGER.error("Error closing input stream on connection " + this, e);
        }
    }

    @Override
    public Transfer.Direction getDirection() {
        return Transfer.Direction.SEND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(LinkedList<ByteBuffer> received, LinkedList<ByteBuffer> transmit) {
        --tokens;
        this.openStream();
        this.setSize();
        ByteBuffer bb = ByteBuffer.allocate(NIOProperties.PACKET_SIZE);
        int bytes = this.readFirst(bb);
        LOGGER.debug("A packet with " + bytes + " was added to the transmit queue");
        LinkedList<ByteBuffer> linkedList = transmit;
        synchronized (linkedList) {
            transmit.add(bb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long progress(LinkedList<ByteBuffer> received, LinkedList<ByteBuffer> transmit) {
        int actual;
        LinkedList<ByteBuffer> linkedList = transmit;
        synchronized (linkedList) {
            actual = transmit.size();
        }
        int packets = NIOProperties.MAX_BUFFERED_PACKETS - actual;
        if (packets > 0) {
            LinkedList<ByteBuffer> list = new LinkedList<ByteBuffer>();
            for (int i = 0; i < packets && this.remainingSize != 0L; ++i) {
                ByteBuffer bb = ByteBuffer.allocate(NIOProperties.PACKET_SIZE);
                try {
                    int bytes = this.read(bb);
                    list.add(bb);
                    LOGGER.debug("A packet with " + bytes + " was added to the transmit queue");
                    continue;
                }
                catch (IOException e) {
                    LOGGER.error("Can not read from the input for connection " + this, e);
                    this.failed = true;
                }
            }
            LinkedList<ByteBuffer> linkedList2 = transmit;
            synchronized (linkedList2) {
                transmit.addAll(list);
            }
            return list.size();
        }
        return 0L;
    }

    @Override
    public void notifyCompletion(Connection c, EventManager<?> em) {
        em.writeFinished(c, this);
        ++tokens;
        if (pausedConnections.size() > 0) {
            InternalConnection ic = pausedConnections.removeFirst();
            ic.resume();
        }
    }

    @Override
    public void notifyError(Connection c, EventManager<?> em, CommException exc) {
        em.notifyError(c, this, exc);
        ++tokens;
        if (pausedConnections.size() > 0) {
            InternalConnection ic = pausedConnections.removeFirst();
            ic.resume();
        }
    }

    @Override
    public boolean checkViability(boolean closedCommunication, LinkedList<ByteBuffer> received, LinkedList<ByteBuffer> transmit) throws NIOException {
        if (!closedCommunication) {
            return tokens > 0;
        }
        throw new NIOException(NIOException.ErrorType.CLOSED_CONNECTION, (Throwable)new Exception("Channel was already closed for connection " + this));
    }

    @Override
    public void pause(InternalConnection ic) {
        pausedConnections.add(ic);
    }
}

