/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.nio;

import es.bsc.cepbatools.extrae.Wrapper;
import integratedtoolkit.util.StreamGobbler;
import integratedtoolkit.util.Tracer;
import java.io.File;
import java.io.IOException;

public class NIOTracer
extends Tracer {
    private static String scriptDir = "";
    private static String workingDir = "";
    private static String nodeName = "master";

    public static void startTracing(String workerName, String workerUser, String workerHost, Integer numThreads) {
        if (numThreads <= 0) {
            if (debug) {
                logger.debug("Resource " + workerName + " has 0 slots, it won't appear in the trace");
            }
            return;
        }
        if (debug) {
            try {
                logger.debug("NIO uri File: any:///" + System.getProperty("it.appLogDir") + "/trace/tracer.out");
                logger.debug("any:///" + System.getProperty("it.appLogDir") + "/trace/tracer.out");
            }
            catch (Exception e) {
                logger.error("Error initializing tracing output files");
            }
        }
    }

    public static void setWorkerInfo(String scriptDir, String nodeName, String workingDir) {
        NIOTracer.scriptDir = scriptDir;
        NIOTracer.workingDir = workingDir + File.separator + nodeName;
        NIOTracer.nodeName = nodeName;
        if (debug) {
            logger.debug("Tracer Worker Info\n\t" + NIOTracer.scriptDir + "\n\r" + NIOTracer.workingDir + "\n\r" + NIOTracer.nodeName);
        }
    }

    public static void wrapperEmit(String taskId, String eventType) {
        Wrapper.Event(Integer.parseInt(eventType), Long.parseLong(taskId));
    }

    public static void emitEvent(String command, String slot, String taskId, String eventType) {
        if (nodeName.equals("master")) {
            logger.debug("Master Transfers call");
            Wrapper.Event(Integer.parseInt(eventType), Long.parseLong(taskId));
        } else {
            if (debug) {
                logger.debug("Emitting synchronized event " + command + " " + " " + slot + " " + taskId + " " + eventType + "....");
                logger.debug("---\n\tScriptDir: " + scriptDir + "\n\tWorkingDir: " + workingDir + "\n\tNode Name: " + nodeName);
            }
            ProcessBuilder pb = null;
            pb = taskId.equals("0") ? new ProcessBuilder(scriptDir + File.separator + "trace.sh", command, workingDir, eventType, slot) : new ProcessBuilder(scriptDir + File.separator + "trace.sh", command, workingDir, eventType, taskId, slot);
            Process p = null;
            try {
                p = pb.start();
            }
            catch (IOException e) {
                logger.error("Error emiting", e);
                return;
            }
            if (debug) {
                StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream(), System.out);
                StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream(), System.err);
                outputGobbler.start();
                errorGobbler.start();
            }
            try {
                int exitCode = p.waitFor();
                if (exitCode != 0) {
                    logger.error("Error emitting, exit code " + exitCode);
                }
            }
            catch (InterruptedException e) {
                logger.error("Error emitting (interruptedException) : " + e.getMessage(), e);
            }
        }
    }

    public static void startTask(String slot, String taskId, String eventType) {
        String offsetedTaskId = String.valueOf(Integer.parseInt(taskId) + Tracer.getFixedOffset());
        NIOTracer.emitEvent("start", slot, offsetedTaskId, eventType);
    }

    public static void endTask(String slot, String eventType) {
        NIOTracer.emitEvent("end", slot, "0", eventType);
    }

    public static void generatePackage() {
        if (debug) {
            logger.debug("Generating package of " + nodeName + ", with " + scriptDir);
        }
        ProcessBuilder pb = new ProcessBuilder(scriptDir + File.separator + "trace.sh", "package", workingDir, nodeName);
        Process p = null;
        try {
            p = pb.start();
        }
        catch (IOException e) {
            logger.error("Error generating " + nodeName + " package", e);
            return;
        }
        if (debug) {
            StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream(), System.out);
            StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream(), System.err);
            outputGobbler.start();
            errorGobbler.start();
        }
        try {
            int exitCode = p.waitFor();
            if (exitCode != 0) {
                logger.error("Error generating " + nodeName + " package, exit code " + exitCode);
            }
        }
        catch (InterruptedException e) {
            logger.error("Error generating " + nodeName + " package (interruptedException) : " + e.getMessage());
        }
    }
}

