/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.nio.commands;

import integratedtoolkit.nio.NIOAgent;
import integratedtoolkit.nio.NIOURI;
import integratedtoolkit.types.data.LogicalData;
import integratedtoolkit.types.data.location.URI;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;

public class Data
implements Externalizable {
    private String name;
    private LinkedList<NIOURI> sources;

    public Data() {
    }

    public Data(String name, NIOURI uri) {
        this.name = name;
        this.sources = new LinkedList();
        this.sources.add(uri);
    }

    public Data(LogicalData ld) {
        this.name = ld.getName();
        this.sources = new LinkedList();
        for (URI uri : ld.getURIs()) {
            Object o = uri.getInternalURI(NIOAgent.ID);
            if (o == null) continue;
            this.sources.add((NIOURI)o);
        }
    }

    public Data(LogicalData ld, NIOURI source) {
        this.name = ld.getName();
        this.sources = new LinkedList();
        this.sources.add(source);
        for (URI uri : ld.getURIs()) {
            Object o = uri.getInternalURI(NIOAgent.ID);
            if (o == null) continue;
            this.sources.add((NIOURI)o);
        }
    }

    public boolean compareTo(Data n) {
        return n.name.compareTo(this.name) == 0;
    }

    public String getName() {
        return this.name;
    }

    public LinkedList<NIOURI> getSources() {
        return this.sources;
    }

    public NIOURI getFirstURI() {
        if (this.sources != null && !this.sources.isEmpty()) {
            return this.sources.getFirst();
        }
        return null;
    }

    public NIOURI getURIinHost(String hostname) {
        for (NIOURI loc : this.sources) {
            if (!loc.getHost().equals(hostname)) continue;
            return loc;
        }
        return null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.sources = (LinkedList)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeObject(this.sources);
    }

    public String toString() {
        return this.name + "@" + this.sources;
    }
}

