/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.nio.worker.executors;

import integratedtoolkit.nio.NIOTask;
import integratedtoolkit.nio.NIOTracer;
import integratedtoolkit.nio.worker.NIOWorker;
import integratedtoolkit.util.Tracer;
import org.apache.log4j.Logger;

public abstract class Executor {
    protected static final Logger logger = Logger.getLogger("integratedtoolkit.Worker");
    protected static final boolean tracing = System.getProperty("it.tracing") != null && System.getProperty("it.tracing").equals("true");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean execute(NIOTask nt, NIOWorker nw) {
        String sandBox;
        String threadName = Thread.currentThread().getName();
        String tracingSlot = threadName.substring(23);
        if (tracing) {
            NIOTracer.emitEvent("start", tracingSlot, String.valueOf(Tracer.Event.TASK_RUNNING.getId()), String.valueOf(Tracer.Event.TASK_RUNNING.getType()));
        }
        NIOWorker.registerOutputs(NIOWorker.workingDir + "/jobs/job" + nt.getJobId() + "_" + (Object)((Object)nt.getHist()));
        try {
            logger.debug("Creating sandbox for job " + nt.getJobId());
            sandBox = this.createSandBox();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            NIOWorker.unregisterOutputs();
            if (!tracing) return false;
            NIOTracer.endTask(tracingSlot, String.valueOf(Tracer.Event.TASK_RUNNING.getType()));
            return false;
        }
        try {
            this.executeTask(sandBox, nt, nw);
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                logger.debug("Removing sandbox for job " + nt.getJobId());
                this.removeSandBox(sandBox);
            }
            catch (Exception e1) {
                logger.error(e1.getMessage(), e1);
                boolean bl = false;
                return bl;
            }
            finally {
                NIOWorker.unregisterOutputs();
                if (tracing) {
                    NIOTracer.endTask(tracingSlot, String.valueOf(Tracer.Event.TASK_RUNNING.getType()));
                }
            }
        }
    }

    abstract String createSandBox() throws Exception;

    abstract void executeTask(String var1, NIOTask var2, NIOWorker var3) throws Exception;

    abstract void removeSandBox(String var1) throws Exception;

    public static class JobExecutionException
    extends Exception {
        public JobExecutionException(String message) {
            super(message);
        }

        public JobExecutionException(String message, Exception e) {
            super(message, e);
        }
    }
}

