/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.nio.worker.executors;

import integratedtoolkit.nio.NIOParam;
import integratedtoolkit.nio.NIOTask;
import integratedtoolkit.nio.NIOTracer;
import integratedtoolkit.nio.worker.NIOWorker;
import integratedtoolkit.nio.worker.executors.Executor;
import java.lang.reflect.Method;
import java.util.Iterator;

public class JavaExecutor
extends Executor {
    @Override
    String createSandBox() {
        return null;
    }

    @Override
    void executeTask(String sandBox, NIOTask nt, NIOWorker nw) throws Exception {
        int i;
        Object[] values;
        Class[] types;
        String threadName = Thread.currentThread().getName();
        String tracingSlot = threadName.substring(23);
        String taskType = String.valueOf(nt.getTaskType() + 1);
        String taskId = String.valueOf(nt.getTaskId());
        boolean debug = NIOWorker.workerDebug;
        String className = nt.getClassName();
        String methodName = nt.getMethodName();
        boolean hasTarget = nt.isHasTarget();
        int numParams = nt.getNumParams();
        if (hasTarget) {
            types = new Class[numParams - 1];
            values = new Object[numParams - 1];
        } else {
            types = new Class[numParams];
            values = new Object[numParams];
        }
        boolean[] mustWrite = new boolean[numParams];
        String[] renamings = new String[numParams];
        Object target = null;
        Iterator params = nt.getParams().iterator();
        block17: for (i = 0; i < numParams; ++i) {
            NIOParam np = (NIOParam)params.next();
            switch (np.getType()) {
                case FILE_T: {
                    types[i] = String.class;
                    values[i] = np.getValue();
                    continue block17;
                }
                case OBJECT_T: {
                    String renaming;
                    String name = renaming = (renamings[i] = np.getValue().toString());
                    mustWrite[i] = np.isWrite();
                    Object o = nw.getObject(name);
                    if (hasTarget && i == numParams - 1) {
                        if (o == null) {
                            throw new Executor.JobExecutionException("Target object with renaming " + name + ", method " + methodName + ", class " + className + " is null!" + "\n");
                        }
                        target = o;
                        continue block17;
                    }
                    if (o == null) {
                        throw new Executor.JobExecutionException("Object parameter " + i + " with renaming " + name + ", method " + methodName + ", class " + className + " is null!" + "\n");
                    }
                    types[i] = o.getClass();
                    values[i] = o;
                    continue block17;
                }
                case BOOLEAN_T: {
                    types[i] = Boolean.TYPE;
                    values[i] = np.getValue();
                    continue block17;
                }
                case CHAR_T: {
                    types[i] = Character.TYPE;
                    values[i] = np.getValue();
                    continue block17;
                }
                case STRING_T: {
                    types[i] = String.class;
                    values[i] = np.getValue();
                    continue block17;
                }
                case BYTE_T: {
                    types[i] = Byte.TYPE;
                    values[i] = np.getValue();
                    continue block17;
                }
                case SHORT_T: {
                    types[i] = Short.TYPE;
                    values[i] = np.getValue();
                    continue block17;
                }
                case INT_T: {
                    types[i] = Integer.TYPE;
                    values[i] = np.getValue();
                    continue block17;
                }
                case LONG_T: {
                    types[i] = Long.TYPE;
                    values[i] = np.getValue();
                    continue block17;
                }
                case FLOAT_T: {
                    types[i] = Float.TYPE;
                    values[i] = np.getValue();
                    continue block17;
                }
                case DOUBLE_T: {
                    types[i] = Double.TYPE;
                    values[i] = np.getValue();
                }
            }
        }
        if (debug) {
            System.out.println("WORKER - Parameters of execution:");
            System.out.println("  * Method class: " + className);
            System.out.println("  * Method name: " + methodName);
            System.out.print("  * Parameter types:");
            for (i = 0; i < types.length; ++i) {
                System.out.print(" " + types[i].getName());
            }
            System.out.println();
            System.out.print("  * Parameter values:");
            for (Object v : values) {
                System.out.print(" " + v);
            }
            System.out.println();
        }
        Class<?> methodClass = null;
        Method method = null;
        try {
            methodClass = Class.forName(className);
        }
        catch (Exception e) {
            throw new Executor.JobExecutionException("Can not get class by reflection", e);
        }
        try {
            method = methodClass.getMethod(methodName, types);
        }
        catch (Exception e) {
            throw new Executor.JobExecutionException("Can not get method by reflection", e);
        }
        Object retValue = null;
        if (tracing) {
            NIOTracer.startTask(tracingSlot, taskType, String.valueOf(NIOTracer.getEventsType()));
            NIOTracer.emitEvent("start", tracingSlot, taskId, String.valueOf(NIOTracer.getTaskSchedulingType()));
        }
        retValue = method.invoke(target, values);
        if (tracing) {
            NIOTracer.endTask(tracingSlot, String.valueOf(NIOTracer.getEventsType()));
            NIOTracer.endTask(tracingSlot, String.valueOf(NIOTracer.getTaskSchedulingType()));
        }
        for (int i2 = 0; i2 < numParams; ++i2) {
            if (!mustWrite[i2]) continue;
            if (hasTarget && i2 == numParams - 1) {
                nw.storeInCache(renamings[i2], target);
                continue;
            }
            nw.storeInCache(renamings[i2], values[i2]);
        }
        if (retValue != null) {
            String renaming = (String)nt.getParams().getLast().getValue();
            nw.storeInCache(renaming.substring(renaming.lastIndexOf(47) + 1), retValue);
        }
    }

    @Override
    void removeSandBox(String sandBox) {
    }
}

