/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.resources;

import integratedtoolkit.api.ITExecution;
import integratedtoolkit.comm.Comm;
import integratedtoolkit.types.AdaptorDescription;
import integratedtoolkit.types.COMPSsNode;
import integratedtoolkit.types.Implementation;
import integratedtoolkit.types.Task;
import integratedtoolkit.types.data.LogicalData;
import integratedtoolkit.types.data.Transferable;
import integratedtoolkit.types.data.location.DataLocation;
import integratedtoolkit.types.data.location.URI;
import integratedtoolkit.types.data.operation.DataOperation;
import integratedtoolkit.types.data.operation.SafeCopyListener;
import integratedtoolkit.types.data.operation.SafeCopyTransferable;
import integratedtoolkit.types.data.operation.TracingCopyListener;
import integratedtoolkit.types.data.operation.TracingCopyTransferable;
import integratedtoolkit.types.job.Job;
import integratedtoolkit.types.resources.ShutdownListener;
import integratedtoolkit.util.SharedDiskManager;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Logger;

public abstract class Resource
implements Comparable<Resource> {
    protected static final boolean tracing = System.getProperty("it.tracing") != null && System.getProperty("it.tracing").equals("true");
    protected static final Logger logger = Logger.getLogger("integratedtoolkit.Communication");
    public static final boolean debug = logger.isDebugEnabled();
    private final COMPSsNode node;
    private LinkedList<String> obsoletes = new LinkedList();

    public Resource(COMPSsNode node) {
        this.node = node;
        SharedDiskManager.addMachine(this);
    }

    public Resource(String name, HashMap<String, String> properties, TreeMap<String, AdaptorDescription> adaptorsDesc) throws Exception {
        this.node = Comm.initWorker(name, properties, adaptorsDesc);
        SharedDiskManager.addMachine(this);
    }

    public void addSharedDisk(String diskName, String diskMountpoint) {
        SharedDiskManager.addSharedToMachine(diskName, diskMountpoint, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addObsolete(String obsoleteFile) {
        LinkedList<String> linkedList = this.obsoletes;
        synchronized (linkedList) {
            this.obsoletes.add(obsoleteFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addObsoletes(LinkedList<String> obsoleteFiles) {
        LinkedList<String> linkedList = this.obsoletes;
        synchronized (linkedList) {
            this.obsoletes.addAll(obsoleteFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LinkedList<String> clearObsoletes() {
        LinkedList<String> linkedList = this.obsoletes;
        synchronized (linkedList) {
            LinkedList<String> obs = this.obsoletes;
            this.obsoletes = new LinkedList();
            return obs;
        }
    }

    public String getName() {
        return this.node.getName();
    }

    public COMPSsNode getNode() {
        return this.node;
    }

    public void setInternalURI(URI u) {
        this.node.setInternalURI(u);
    }

    public Job<?> newJob(Task task, Implementation<?> impl, Job.JobListener listener) {
        return this.node.newJob(task, impl, this, listener);
    }

    public void getData(String dataId, String tgtDataId, Transferable reason, DataOperation.EventListener listener) {
        LogicalData srcData = Comm.getData(dataId);
        LogicalData tgtData = null;
        if (tgtDataId != null) {
            tgtData = Comm.getData(tgtDataId);
        }
        this.getData(srcData, dataId, tgtData, reason, listener);
    }

    public void getData(LogicalData ld, LogicalData tgtData, Transferable reason, DataOperation.EventListener listener) {
        this.getData(ld, ld.getName(), tgtData, reason, listener);
    }

    public void getData(String dataId, String newName, String tgtDataId, Transferable reason, DataOperation.EventListener listener) {
        LogicalData srcData = Comm.getData(dataId);
        LogicalData tgtData = Comm.getData(tgtDataId);
        this.getData(srcData, newName, tgtData, reason, listener);
    }

    public void getData(String dataId, String newName, LogicalData tgtData, Transferable reason, DataOperation.EventListener listener) {
        LogicalData ld = Comm.getData(dataId);
        this.getData(ld, newName, tgtData, reason, listener);
    }

    public void getData(LogicalData ld, String newName, LogicalData tgtData, Transferable reason, DataOperation.EventListener listener) {
        String workingPath = this.node.getCompletePath(reason.getType(), newName);
        DataLocation target = DataLocation.getLocation(this, workingPath);
        this.getData(ld, target, tgtData, reason, listener);
    }

    public void getData(String dataId, DataLocation target, Transferable reason, DataOperation.EventListener listener) {
        LogicalData srcData = Comm.getData(dataId);
        this.getData(srcData, target, srcData, reason, listener);
    }

    public void getData(String dataId, DataLocation target, String tgtDataId, Transferable reason, DataOperation.EventListener listener) {
        LogicalData srcData = Comm.getData(dataId);
        LogicalData tgtData = Comm.getData(tgtDataId);
        this.getData(srcData, target, tgtData, reason, listener);
    }

    public void getData(String dataId, DataLocation target, LogicalData tgtData, Transferable reason, DataOperation.EventListener listener) {
        LogicalData ld = Comm.getData(dataId);
        this.getData(ld, target, tgtData, reason, listener);
    }

    public void getData(LogicalData srcData, DataLocation target, LogicalData tgtData, Transferable reason, DataOperation.EventListener listener) {
        this.node.obtainData(srcData, null, target, tgtData, reason, listener);
    }

    public String getCompleteRemotePath(ITExecution.ParamType type, String name) {
        return this.node.getCompletePath(type, name);
    }

    public void stop(boolean saveUniqueData, ShutdownListener sl) {
        if (debug) {
            logger.debug("Stopping resource " + this.getName());
        }
        Semaphore sem = new Semaphore(0);
        SafeCopyListener listener = new SafeCopyListener(sem);
        HashSet<LogicalData> lds = LogicalData.getAllDataFromHost(this);
        HashMap<String, String> disks = SharedDiskManager.terminate(this);
        COMPSsNode masterNode = Comm.appHost.getNode();
        for (LogicalData ld : lds) {
            ld.notifyToInProgressCopiesEnd(listener);
            DataLocation lastLoc = ld.removeHostAndCheckLocationToSave(this, disks);
            if (lastLoc == null || !saveUniqueData) continue;
            listener.addOperation();
            DataLocation safeLoc = DataLocation.getLocation(Comm.appHost, Comm.appHost.getTempDirPath() + ld.getName());
            masterNode.obtainData(ld, lastLoc, safeLoc, ld, new SafeCopyTransferable(), listener);
        }
        if (debug) {
            logger.debug("Waiting for finishing saving copies for " + this.getName());
        }
        listener.enable();
        try {
            sem.acquire();
        }
        catch (InterruptedException ex) {
            logger.error("Error waiting for files in resource " + this.getName() + " to get saved");
        }
        if (tracing) {
            this.node.generatePackage();
            this.getTracingPackageToMaster();
        }
        this.deleteIntermediate();
        sl.addOperation();
        this.node.stop(sl);
    }

    private void getTracingPackageToMaster() {
        COMPSsNode masterNode = Comm.appHost.getNode();
        Semaphore sem = new Semaphore(0);
        String fileName = this.getName() + "_compss_trace.tar.gz";
        String fileOriginPath = this.node.getCompletePath(ITExecution.ParamType.FILE_T, this.getName() + "/" + fileName);
        if (debug) {
            logger.debug("Copying tracing package from : " + fileOriginPath + ",to : " + Comm.appHost.getAppLogDirPath() + "trace/" + fileName);
        }
        TracingCopyListener tracingListener = new TracingCopyListener(sem);
        tracingListener.addOperation();
        DataLocation source = DataLocation.getLocation(this, fileOriginPath);
        DataLocation tgt = DataLocation.getLocation(Comm.appHost, Comm.appHost.getAppLogDirPath() + "trace/" + fileName);
        masterNode.obtainData(new LogicalData("tracing" + this.getName()), source, tgt, new LogicalData("tracing" + this.getName()), new TracingCopyTransferable(), tracingListener);
        tracingListener.enable();
        try {
            sem.acquire();
        }
        catch (InterruptedException ex) {
            logger.error("Error waiting for tracing files in resource " + this.getName() + " to get saved");
        }
        if (debug) {
            logger.debug("Removing " + this.getName() + " tracing temporary files");
        }
        File f = null;
        try {
            f = new File(source.getPath());
            f.delete();
        }
        catch (Exception e) {
            logger.error("Unable to remove tracing temporary files of node " + this.getName());
        }
    }

    public abstract Type getType();

    @Override
    public abstract int compareTo(Resource var1);

    public void deleteIntermediate() {
        this.node.deleteTemporary();
    }

    public static enum Type {
        MASTER,
        WORKER,
        SERVICE;

    }
}

