/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm;

import es.bsc.comm.CommException;
import es.bsc.comm.Connection;
import es.bsc.comm.EventManager;
import es.bsc.comm.MessageHandler;
import es.bsc.comm.Node;
import es.bsc.comm.nio.NIOEventManager;
import org.apache.log4j.Logger;

public class TransferManager {
    public static final String LOGGER_NAME = "Communication";
    private static final Logger LOGGER = Logger.getLogger("Communication");
    private static EventManager<?> em;
    private static final String PROPERTIES_ERROR = "Error loading properties file";

    private TransferManager() {
    }

    public static void init(String protocol, String properties, MessageHandler mh) {
        if (protocol.contentEquals("NIO")) {
            em = new NIOEventManager(mh);
        }
        try {
            em.init(properties);
        }
        catch (Exception e) {
            LOGGER.error(PROPERTIES_ERROR, e);
        }
        mh.init();
        em.start();
    }

    public static Connection startConnection(Node node) {
        return em.startConnection(node);
    }

    public static void startServer(Node n) throws CommException {
        em.startServer(n);
    }

    public static void shutdown(Connection notifyTo) {
        em.shutdown(notifyTo);
    }
}

