/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.nio;

import es.bsc.comm.Node;
import es.bsc.comm.nio.NIOConnection;
import es.bsc.comm.nio.NIOEventManager;
import es.bsc.comm.nio.NIOException;
import es.bsc.comm.nio.NIONode;
import es.bsc.comm.nio.NIOProperties;
import es.bsc.comm.nio.event.ClosedChannelEvent;
import es.bsc.comm.nio.event.EmptyBufferEvent;
import es.bsc.comm.nio.event.ErrorEvent;
import es.bsc.comm.nio.event.LowBufferEvent;
import es.bsc.comm.nio.event.NewTransferEvent;
import es.bsc.comm.nio.event.PacketEntry;
import es.bsc.comm.transfers.ReceiveTransfer;
import es.bsc.comm.transfers.Transfer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class NIOListener
extends Thread {
    private static final long SELECTOR_SLEEP = 1000L;
    private static final Logger LOGGER = Logger.getLogger("Communication");
    private static final int BACKLOG_QUEUE_SIZE = 7000;
    private static boolean stop = false;
    private static final LinkedList<ChangeRequest> pendingChanges = new LinkedList();
    private static NIOEventManager eventManager;
    private static Selector selector;
    private static final HashMap<Integer, ServerSocketChannel> servers;
    private static final HashMap<SocketChannel, ChangeRequest> pendingInterest;
    private static NIOConnection closingConnection;

    public NIOListener() {
        this.setName("NIO Listener");
    }

    public static void init(NIOEventManager nem) throws IOException {
        selector = SelectorProvider.provider().openSelector();
        eventManager = nem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startServer(Node n) throws NIOException {
        NIONode nn = (NIONode)n;
        String ip = nn.ip;
        int port = nn.port;
        try {
            ServerSocketChannel ssc = ServerSocketChannel.open();
            servers.put(port, ssc);
            ssc.configureBlocking(false);
            InetSocketAddress inet = null;
            inet = ip == null ? new InetSocketAddress(port) : new InetSocketAddress(ip, port);
            ssc.socket().bind(inet, 7000);
            ChangeRequest cr = new ChangeRequest(ssc, 16, false);
            LinkedList<ChangeRequest> linkedList = pendingChanges;
            synchronized (linkedList) {
                pendingChanges.add(cr);
                selector.wakeup();
            }
        }
        catch (IOException e) {
            throw new NIOException(NIOException.ErrorType.STARTING_SERVER, (Throwable)e);
        }
    }

    public void closeServers() {
        try {
            for (ServerSocketChannel ssc : servers.values()) {
                ssc.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("Error closing server connection", e);
        }
    }

    public void closeConnections() {
        SocketChannel[] allSockets;
        for (SocketChannel sc : allSockets = NIOConnection.getAllSockets().toArray(new SocketChannel[NIOConnection.getAllSockets().size()])) {
            if (closingConnection != null && closingConnection.getSocket() == sc) continue;
            if (sc.isConnected()) {
                SelectionKey key = sc.keyFor(selector);
                LOGGER.debug("Close channel " + sc.hashCode() + " from closeConnections");
                this.closeChannel(key, sc);
                continue;
            }
            LOGGER.warn("Connection " + sc.hashCode() + " is not connected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeSocket(SocketChannel sc) {
        ChangeRequest cr = new ChangeRequest(sc, 0, true);
        LinkedList<ChangeRequest> linkedList = pendingChanges;
        synchronized (linkedList) {
            pendingChanges.add(cr);
            selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changeInterest(SocketChannel sc, int interest) {
        ChangeRequest cr = new ChangeRequest(sc, interest, false);
        LinkedList<ChangeRequest> linkedList = pendingChanges;
        synchronized (linkedList) {
            pendingChanges.add(cr);
            selector.wakeup();
        }
    }

    @Override
    public void run() {
        LOGGER.info("NIO Listener started");
        while (!stop) {
            try {
                this.applyInterestChanges();
                selector.select(1000L);
                this.processKeys(selector.selectedKeys().iterator());
            }
            catch (IOException e) {
                LOGGER.error("Error listening on connection changes", e);
            }
        }
        LOGGER.info("Closing all connections " + (closingConnection != null ? "but " + closingConnection : ""));
        this.closeServers();
        this.closeConnections();
        while (NIOConnection.areAliveConnections()) {
            try {
                this.applyInterestChanges();
                selector.select(1000L);
                this.processKeys(selector.selectedKeys().iterator());
            }
            catch (IOException e) {
                LOGGER.debug("Error listening on closing connection changes", e);
            }
        }
        eventManager.listennerStopped();
        LOGGER.info("NIO Listener stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyInterestChanges() throws IOException {
        LinkedList<ChangeRequest> linkedList = pendingChanges;
        synchronized (linkedList) {
            Iterator changes = pendingChanges.iterator();
            while (changes.hasNext()) {
                try {
                    SocketChannel sc;
                    ChangeRequest change = (ChangeRequest)changes.next();
                    if (change.close) {
                        sc = (SocketChannel)change.channel;
                        if (!sc.isConnected()) continue;
                        SelectionKey key = sc.keyFor(selector);
                        LOGGER.debug("Closing channel " + sc.hashCode() + " no more data to write");
                        this.closeChannel(key, sc);
                        continue;
                    }
                    if (change.type != 16) {
                        sc = (SocketChannel)change.channel;
                        if (!sc.isConnected() && change.type != 8) {
                            pendingInterest.put(sc, change);
                            continue;
                        }
                        ((SelectableChannel)change.channel).register(selector, change.type);
                        if (change.type != 4) continue;
                        sc.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)NIOProperties.NETWORK_BUFFER_SIZE);
                        continue;
                    }
                    ((SelectableChannel)change.channel).register(selector, change.type);
                }
                catch (ClosedChannelException e) {
                    LOGGER.error("Exception closing channel ", e);
                }
            }
            pendingChanges.clear();
        }
    }

    private void processKeys(Iterator<SelectionKey> selectedKeys) {
        while (selectedKeys.hasNext()) {
            SelectionKey key = selectedKeys.next();
            selectedKeys.remove();
            if (!key.isValid()) continue;
            if (key.isAcceptable()) {
                this.accept(key);
                continue;
            }
            if (key.isConnectable()) {
                this.connect(key);
                continue;
            }
            if (key.isReadable()) {
                this.read(key);
                continue;
            }
            if (!key.isWritable()) continue;
            this.write(key);
        }
    }

    public static void shutdown(NIOConnection connection) {
        closingConnection = connection;
        stop = true;
        selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NIOConnection startConnection(Node targetNode) {
        NIONode n = (NIONode)targetNode;
        try {
            SocketChannel sc = SocketChannel.open();
            sc.configureBlocking(false);
            if (n.ip == null) {
                sc.connect(new InetSocketAddress("127.0.0.1", n.port));
            } else {
                sc.connect(new InetSocketAddress(n.ip, n.port));
            }
            sc.socket().setKeepAlive(true);
            NIOConnection nc = new NIOConnection(eventManager, sc, n);
            ChangeRequest cr = new ChangeRequest(sc, 8, false);
            LinkedList<ChangeRequest> linkedList = pendingChanges;
            synchronized (linkedList) {
                pendingChanges.add(cr);
                selector.wakeup();
            }
            return nc;
        }
        catch (Exception e) {
            NIOException ne = new NIOException(NIOException.ErrorType.STARTING_CONNECTION, (Throwable)e);
            eventManager.addEvent(new ErrorEvent(null, ne));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SocketChannel restartConnection(NIONode targetNode) {
        try {
            SocketChannel sc = SocketChannel.open();
            sc.configureBlocking(false);
            if (targetNode.ip == null) {
                sc.connect(new InetSocketAddress("127.0.0.1", targetNode.port));
            } else {
                sc.connect(new InetSocketAddress(targetNode.ip, targetNode.port));
            }
            sc.socket().setKeepAlive(true);
            ChangeRequest cr = new ChangeRequest(sc, 8, false);
            LinkedList<ChangeRequest> linkedList = pendingChanges;
            synchronized (linkedList) {
                pendingChanges.add(cr);
                selector.wakeup();
            }
            return sc;
        }
        catch (Exception e) {
            NIOException ne = new NIOException(NIOException.ErrorType.RESTARTING_CONNECTION, (Throwable)e);
            eventManager.addEvent(new ErrorEvent(null, ne));
            return null;
        }
    }

    private void accept(SelectionKey key) {
        try {
            ServerSocketChannel ssc = (ServerSocketChannel)key.channel();
            SocketChannel sc = ssc.accept();
            sc.configureBlocking(false);
            NIOListener.changeInterest(sc, 1);
            String address = sc.socket().getInetAddress().getHostAddress();
            int port = sc.socket().getPort();
            NIONode n = new NIONode(address, port);
            NIOConnection nc = new NIOConnection(eventManager, sc, n);
            eventManager.addEvent(new NewTransferEvent(nc, new ReceiveTransfer(Transfer.Type.COMMAND)));
        }
        catch (Exception e) {
            NIOException ne = new NIOException(NIOException.ErrorType.ACCEPTING_CONNECTION, (Throwable)e);
            eventManager.addEvent(new ErrorEvent(null, ne));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(SelectionKey key) {
        SocketChannel sc = (SocketChannel)key.channel();
        try {
            sc.finishConnect();
            LinkedList<ChangeRequest> linkedList = pendingChanges;
            synchronized (linkedList) {
                ChangeRequest cr = pendingInterest.get(sc);
                if (cr != null) {
                    pendingChanges.add(cr);
                } else if (pendingChanges.isEmpty()) {
                    cr = new ChangeRequest(sc, 1, false);
                    pendingChanges.add(cr);
                }
            }
        }
        catch (Exception e) {
            LinkedList<ChangeRequest> linkedList = pendingChanges;
            synchronized (linkedList) {
                pendingInterest.remove(sc);
            }
            NIOException ne = new NIOException(NIOException.ErrorType.FINISHING_CONNECTION, (Throwable)e);
            eventManager.addEvent(new ErrorEvent(sc, ne));
            key.cancel();
            try {
                sc.close();
            }
            catch (Exception ee) {
                NIOException ne2 = new NIOException(NIOException.ErrorType.FINISHING_CONNECTION, (Throwable)ee);
                eventManager.addEvent(new ErrorEvent(sc, ne2));
            }
        }
    }

    private void read(SelectionKey key) {
        SocketChannel sc = (SocketChannel)key.channel();
        try {
            ByteBuffer readBuffer = ByteBuffer.allocate(NIOProperties.PACKET_SIZE);
            try {
                int size = sc.read(readBuffer);
                if (size == -1) {
                    LOGGER.debug("Close channel " + sc.hashCode() + " no more data to read");
                    this.closeChannel(key, sc);
                    return;
                }
                LOGGER.debug(size + " bytes read from socket " + sc.hashCode());
            }
            catch (IOException e) {
                LOGGER.error("Exception reading buffer in channel " + sc.hashCode() + ". Canceling key", e);
                NIOException ne = new NIOException(NIOException.ErrorType.READ, (Throwable)e);
                eventManager.addEvent(new ErrorEvent(sc, ne));
                this.closeChannel(key, sc);
            }
            readBuffer.flip();
            PacketEntry p = new PacketEntry(sc, readBuffer);
            eventManager.addEvent(p);
        }
        catch (Exception e) {
            LOGGER.error("Exception reading key in channel " + sc.hashCode(), e);
            NIOException ne = new NIOException(NIOException.ErrorType.READ, (Throwable)e);
            eventManager.addEvent(new ErrorEvent(sc, ne));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(SelectionKey key) {
        SocketChannel sc = (SocketChannel)key.channel();
        NIOConnection nc = NIOConnection.getConnection(sc);
        LinkedList<ByteBuffer> sendBuffer = nc.getSendBuffer();
        ByteBuffer writeBuffer = null;
        LinkedList<ByteBuffer> linkedList = sendBuffer;
        synchronized (linkedList) {
            if (sendBuffer.isEmpty()) {
                if (nc.getCurrentTransfer() != null) {
                    NIOListener.changeInterest(sc, 1);
                    eventManager.addEvent(new EmptyBufferEvent(sc));
                }
                return;
            }
            writeBuffer = sendBuffer.getFirst();
        }
        if (writeBuffer != null) {
            try {
                if (writeBuffer.remaining() > 0) {
                    int written = sc.write(writeBuffer);
                    LOGGER.debug(written + " bytes written to socket " + sc.hashCode());
                }
            }
            catch (IOException e) {
                LOGGER.error("Error writting key in channel " + this.hashCode() + " . Closing Channel " + sc.hashCode());
                NIOException ne = new NIOException(NIOException.ErrorType.WRITE, (Throwable)e);
                eventManager.addEvent(new ErrorEvent(sc, ne));
                this.closeChannel(key, sc);
                return;
            }
            if (writeBuffer.remaining() == 0) {
                LinkedList<ByteBuffer> linkedList2 = sendBuffer;
                synchronized (linkedList2) {
                    sendBuffer.removeFirst();
                    Integer count = sendBuffer.size();
                    if (count == 0) {
                        NIOListener.changeInterest(sc, 1);
                        eventManager.addEvent(new EmptyBufferEvent(sc));
                    } else if (count < NIOProperties.MIN_BUFFERED_PACKETS) {
                        eventManager.addEvent(new LowBufferEvent(sc));
                    }
                }
            }
        }
    }

    private void closeChannel(SelectionKey key, SocketChannel sc) {
        if (key != null) {
            key.cancel();
        }
        if (sc.isOpen()) {
            eventManager.addEvent(new ClosedChannelEvent(sc));
            try {
                sc.close();
            }
            catch (IOException e) {
                LOGGER.error("Could not close channel " + sc);
            }
        }
    }

    static {
        servers = new HashMap();
        pendingInterest = new HashMap();
    }

    public static class ChangeRequest {
        private final Channel channel;
        private final int type;
        private final boolean close;

        public ChangeRequest(Channel socket, int type, boolean close) {
            this.channel = socket;
            this.type = type;
            this.close = close;
        }
    }
}

