/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.nio;

import es.bsc.comm.Node;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class NIONode
implements Node,
Externalizable {
    public String ip;
    public int port;

    public NIONode() {
    }

    public NIONode(String ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    @Override
    public boolean compareTo(Node n) {
        NIONode nn = (NIONode)n;
        if (this.ip == null) {
            return nn.ip == null && nn.port == this.port;
        }
        return nn.ip != null && nn.ip.compareTo(this.ip) == 0 && nn.port == this.port;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.port);
        if (this.ip != null) {
            out.writeUTF(this.ip);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.port = in.readInt();
        if (in.available() > 0) {
            this.ip = in.readUTF();
        }
    }

    public String toString() {
        return this.ip + ":" + this.port;
    }
}

