/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.transfers;

import es.bsc.comm.CommException;
import es.bsc.comm.Connection;
import es.bsc.comm.EventManager;
import es.bsc.comm.InternalConnection;
import es.bsc.comm.nio.NIOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public abstract class Transfer {
    protected static final int SIZE_SIZE = 8;
    protected static final int TYPE_SIZE = 4;
    protected static final int DEST_SIZE = 4;
    protected static final int INIT_SIZE = 8;
    protected static final int HEADER_SIZE = 16;
    protected static final Logger LOGGER = Logger.getLogger("Communication");
    protected Type type;
    protected Destination destination;
    protected String fileName;
    protected byte[] array;
    protected Object object;
    protected boolean sizeInit = false;
    protected long totalSize;
    protected long remainingSize;

    public Type getType() {
        return this.type;
    }

    public boolean isData() {
        return this.type == Type.DATA;
    }

    public boolean isCommand() {
        return this.type == Type.COMMAND;
    }

    public abstract Direction getDirection();

    public Destination getDestination() {
        return this.destination;
    }

    public boolean isFile() {
        return this.destination == Destination.FILE;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isObject() {
        return this.destination == Destination.OBJECT;
    }

    public Object getObject() {
        return this.object;
    }

    public boolean isArray() {
        return this.destination == Destination.ARRAY;
    }

    public byte[] getArray() {
        return this.array;
    }

    protected void setSize(long size) {
        this.totalSize = size;
        this.remainingSize = size;
        this.sizeInit = true;
    }

    public boolean isInitialized() {
        return this.sizeInit;
    }

    public boolean isComplete() {
        return this.remainingSize == 0L && this.sizeInit;
    }

    public boolean isShutdown() {
        return false;
    }

    public abstract boolean checkViability(boolean var1, LinkedList<ByteBuffer> var2, LinkedList<ByteBuffer> var3) throws NIOException;

    public abstract void start(LinkedList<ByteBuffer> var1, LinkedList<ByteBuffer> var2);

    public abstract long progress(LinkedList<ByteBuffer> var1, LinkedList<ByteBuffer> var2);

    public abstract void notifyCompletion(Connection var1, EventManager<?> var2);

    public abstract void notifyError(Connection var1, EventManager<?> var2, CommException var3);

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + "[" + (Object)((Object)this.getDirection()) + " " + (Object)((Object)this.type) + " " + (Object)((Object)this.destination) + "]";
    }

    public abstract void pause(InternalConnection var1);

    public static enum Destination {
        OBJECT,
        FILE,
        ARRAY;

    }

    public static enum Type {
        COMMAND,
        DATA;

    }

    public static enum Direction {
        SEND,
        RECEIVE;

    }
}

