/*
 * Decompiled with CFR 0.152.
 */
package org.opennebula.client.host;

import java.util.AbstractList;
import java.util.Iterator;
import org.opennebula.client.Client;
import org.opennebula.client.OneResponse;
import org.opennebula.client.Pool;
import org.opennebula.client.PoolElement;
import org.opennebula.client.host.Host;
import org.w3c.dom.Node;

public class HostPool
extends Pool
implements Iterable<Host> {
    private static final String ELEMENT_NAME = "HOST";
    private static final String INFO_METHOD = "hostpool.info";
    private static final String MONITORING = "hostpool.monitoring";

    public HostPool(Client client) {
        super(ELEMENT_NAME, client, INFO_METHOD);
    }

    @Override
    public PoolElement factory(Node node) {
        return new Host(node, this.client);
    }

    public static OneResponse info(Client client) {
        return Pool.info(client, INFO_METHOD);
    }

    public static OneResponse monitoring(Client client) {
        return client.call(MONITORING, new Object[0]);
    }

    @Override
    public OneResponse info() {
        return super.info();
    }

    public OneResponse monitoring() {
        return HostPool.monitoring(this.client);
    }

    @Override
    public Iterator<Host> iterator() {
        AbstractList<Host> abstractList = new AbstractList<Host>(){

            @Override
            public int size() {
                return HostPool.this.getLength();
            }

            @Override
            public Host get(int n) {
                return (Host)HostPool.this.item(n);
            }
        };
        return abstractList.iterator();
    }

    @Override
    public Host getById(int n) {
        return (Host)super.getById(n);
    }
}

