/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.gat.master;

import integratedtoolkit.api.ITExecution;
import integratedtoolkit.gat.master.GATAdaptor;
import integratedtoolkit.types.data.LogicalData;
import integratedtoolkit.types.data.Transferable;
import integratedtoolkit.types.data.location.DataLocation;
import integratedtoolkit.types.data.operation.Copy;
import integratedtoolkit.types.data.operation.DataOperation;
import integratedtoolkit.types.resources.Resource;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.FileInterface;

public class GATCopy
extends Copy.ImmediateCopy {
    private static final String ERR_NO_TGT_URI = "No valid target URIs";
    private static final String ERR_NO_SRC_URI = "No valid source URIs";

    public GATCopy(LogicalData srcData, DataLocation prefSrc, DataLocation prefTgt, LogicalData tgtData, Transferable reason, DataOperation.EventListener listener) {
        super(srcData, prefSrc, prefTgt, tgtData, reason, listener);
        integratedtoolkit.types.data.location.URI uri;
        String path;
        Iterator i$ = prefTgt.getURIs().iterator();
        while (i$.hasNext() && !(path = (uri = (integratedtoolkit.types.data.location.URI)i$.next()).getPath()).startsWith(File.separator)) {
            Resource host = uri.getHost();
            this.tgtLoc = DataLocation.getLocation(host, host.getCompleteRemotePath(ITExecution.ParamType.FILE_T, path));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void specificCopy() throws Exception {
        Object internalURI;
        LinkedList<integratedtoolkit.types.data.location.URI> targetURIs = this.tgtLoc.getURIs();
        LinkedList<Object> gatTargetUris = new LinkedList<Object>();
        for (integratedtoolkit.types.data.location.URI uri : targetURIs) {
            internalURI = (URI)uri.getInternalURI(GATAdaptor.ID);
            if (internalURI == null) continue;
            gatTargetUris.add(internalURI);
        }
        if (gatTargetUris.isEmpty()) {
            throw new GATCopyException(ERR_NO_TGT_URI);
        }
        LinkedList<URI> gatSrcUris = new LinkedList<URI>();
        internalURI = this.srcData;
        synchronized (internalURI) {
            URI internalURI2;
            LinkedList<integratedtoolkit.types.data.location.URI> sourceURIs;
            if (this.srcLoc != null) {
                sourceURIs = this.srcLoc.getURIs();
                for (integratedtoolkit.types.data.location.URI uri : sourceURIs) {
                    URI internalURI22 = (URI)uri.getInternalURI(GATAdaptor.ID);
                    if (internalURI22 == null) continue;
                    gatSrcUris.add(internalURI22);
                }
            }
            sourceURIs = this.srcData.getURIs();
            for (integratedtoolkit.types.data.location.URI uri : sourceURIs) {
                internalURI2 = (URI)uri.getInternalURI(GATAdaptor.ID);
                if (internalURI2 == null) continue;
                gatSrcUris.add(internalURI2);
            }
            if (gatSrcUris.isEmpty()) {
                if (this.srcData.isInMemory()) {
                    try {
                        this.srcData.writeToFile();
                        sourceURIs = this.srcData.getURIs();
                        for (integratedtoolkit.types.data.location.URI uri : sourceURIs) {
                            internalURI2 = (URI)uri.getInternalURI(GATAdaptor.ID);
                            if (internalURI2 == null) continue;
                            gatSrcUris.add(internalURI2);
                        }
                    }
                    catch (Exception e) {
                        logger.fatal("Exception  writing object to file.", e);
                        throw new GATCopyException(ERR_NO_SRC_URI);
                    }
                } else {
                    throw new GATCopyException(ERR_NO_SRC_URI);
                }
            }
        }
        GATInvocationException exception = new GATInvocationException("default logical file");
        for (URI src : gatSrcUris) {
            for (URI uRI : gatTargetUris) {
                try {
                    GATCopy.doCopy(src, uRI);
                }
                catch (Exception e) {
                    exception.add("default logical file", e);
                    continue;
                }
                return;
            }
        }
        throw exception;
    }

    private static void doCopy(URI src, URI dest) throws Exception {
        FileInterface f = null;
        f = GAT.createFile(GATAdaptor.context, src).getFileInterface();
        f.copy(dest);
    }

    private static class GATCopyException
    extends Exception {
        public GATCopyException(String msg) {
            super(msg);
        }
    }
}

