/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.gat.master;

import integratedtoolkit.gat.master.GATWorkerNode;
import integratedtoolkit.gat.master.ScriptExecutor;
import integratedtoolkit.util.Tracer;
import java.net.URISyntaxException;
import java.util.LinkedList;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.File;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.ResourceBroker;
import org.gridlab.gat.resources.SoftwareDescription;

public class GATTracer
extends Tracer {
    private static final GATContext context = new GATContext();

    public static void addPreference(String name, String value) {
        context.addPreference(name, value);
    }

    public static Job startTracing(GATWorkerNode worker, int numTasks) {
        if (debug) {
            logger.debug("Starting trace for woker " + worker.getHost());
        }
        if (numTasks <= 0) {
            if (debug) {
                logger.debug("Resource " + worker.getName() + " has 0 slots, it won't appear in the trace");
            }
            return null;
        }
        int hostId = Tracer.registerHost(worker.getName(), numTasks);
        String user = worker.getUser() == null || worker.getUser().isEmpty() ? "" : worker.getUser() + "@";
        SoftwareDescription sd = new SoftwareDescription();
        String uriString = "any://" + user + worker.getHost();
        sd.addAttribute("uri", uriString);
        sd.setExecutable(worker.getInstallDir() + "/" + "trace.sh");
        sd.setArguments("init", worker.getWorkingDir() + worker.getName(), String.valueOf(hostId), String.valueOf(numTasks));
        if (debug) {
            try {
                File outFile = GAT.createFile(context, "any:///" + System.getProperty("it.appLogDir") + "/trace/tracer.out");
                sd.setStdout(outFile);
                File errFile = GAT.createFile(context, "any:///" + System.getProperty("it.appLogDir") + "/trace/tracer.err");
                sd.setStderr(errFile);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        sd.addAttribute("sandbox.root", "/tmp/");
        sd.addAttribute("sandbox.useroot", "true");
        sd.addAttribute("sandbox.delete", "false");
        Job job = null;
        try {
            URI brokerURI = new URI(uriString);
            ResourceBroker broker = GAT.createResourceBroker(context, brokerURI);
            logger.debug("Starting tracer init job for worker " + uriString + " submited.");
            job = broker.submitJob(new JobDescription(sd));
        }
        catch (Exception e) {
            logger.error("Error initializing tracing system in node " + worker.getHost(), e);
            return null;
        }
        return job;
    }

    public static boolean isReady(Job job) {
        if (job.getState() == Job.JobState.STOPPED) {
            String uri = (String)((JobDescription)job.getJobDescription()).getSoftwareDescription().getAttributes().get("uri");
            if (debug) {
                logger.debug("Initialized tracing system in " + uri);
            }
            return true;
        }
        if (job.getState() == Job.JobState.SUBMISSION_ERROR) {
            logger.error("Error initializing tracing system, host " + job);
            return true;
        }
        return false;
    }

    public static void waitForTracing(Job job) {
        Long timeout = System.currentTimeMillis() + 60000L;
        while (System.currentTimeMillis() < timeout) {
            if (GATTracer.isReady(job)) {
                if (debug) {
                    logger.debug("Tracing ready");
                }
                return;
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
        logger.error("Error initializing tracing system, " + job + " job still pending.");
    }

    public static void generatePackage(GATWorkerNode node) {
        LinkedList<URI> traceScripts = new LinkedList<URI>();
        LinkedList<String> traceParams = new LinkedList<String>();
        String host = node.getHost();
        String installDir = node.getInstallDir();
        String workingDir = node.getWorkingDir() + node.getName();
        String user = node.getUser();
        user = user == null ? "" : user + "@";
        try {
            traceScripts.add(new URI("any://" + user + host + "/" + installDir + "/" + "trace.sh"));
        }
        catch (URISyntaxException e) {
            logger.error("Error deleting tracing host", e);
        }
        String pars = "package " + workingDir + " " + host;
        traceParams.add(pars);
        new ScriptExecutor(traceScripts, traceParams);
    }

    static {
        String brokerAdaptor = System.getProperty("it.gat.broker.adaptor");
        logger.debug("Using GAT Adaptor " + brokerAdaptor);
        context.addPreference("ResourceBroker.adaptor.name", brokerAdaptor);
    }
}

