/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types;

import integratedtoolkit.types.TaskParams;
import integratedtoolkit.types.data.DataInstanceId;
import integratedtoolkit.types.parameter.Parameter;
import java.util.concurrent.atomic.AtomicInteger;

public class Task
implements Comparable<Task> {
    private static final ColorConf[] COLORS = new ColorConf[]{new ColorConf("#0000ff", "#ffffff"), new ColorConf("#ffff00", "#000000"), new ColorConf("#00ff00", "#000000"), new ColorConf("#00ffff", "#000000"), new ColorConf("#ff00ff", "#ffffff"), new ColorConf("#c0c0c0", "#000000"), new ColorConf("#6600ff", "#ffffff"), new ColorConf("#9900ff", "#ffffff"), new ColorConf("#990000", "#ffffff"), new ColorConf("#999900", "#ffffff"), new ColorConf("#996600", "#ffffff"), new ColorConf("#ff0000", "#ffffff")};
    private long appId;
    private int taskId;
    private TaskState status;
    private TaskParams taskParams;
    private boolean enforcedSceduling;
    private boolean strongEnforcedScheduling;
    private DataInstanceId enforcingData;
    private String lastResource;
    private long initialTimeStamp;
    private static final int FIRST_TASK_ID = 1;
    private static AtomicInteger nextTaskId = new AtomicInteger(1);

    public Task(Long appId, String methodClass, String methodName, boolean priority, boolean hasTarget, Parameter[] parameters) {
        this.appId = appId;
        this.taskId = nextTaskId.getAndIncrement();
        this.status = TaskState.TO_ANALYSE;
        this.taskParams = new TaskParams(methodClass, methodName, priority, hasTarget, parameters);
    }

    public Task(Long appId, String namespace, String service, String port, String operation, boolean priority, boolean hasTarget, Parameter[] parameters) {
        this.appId = appId;
        this.taskId = nextTaskId.getAndIncrement();
        this.status = TaskState.TO_ANALYSE;
        this.taskParams = new TaskParams(namespace, service, port, operation, priority, hasTarget, parameters);
    }

    public static int getCurrentTaskCount() {
        return nextTaskId.get();
    }

    public long getAppId() {
        return this.appId;
    }

    public int getId() {
        return this.taskId;
    }

    public TaskState getStatus() {
        return this.status;
    }

    public void setStatus(TaskState status) {
        this.status = status;
    }

    public void setInitialTimeStamp(long time) {
        this.initialTimeStamp = time;
    }

    public void forceScheduling() {
        this.enforcedSceduling = true;
        this.strongEnforcedScheduling = false;
    }

    public void forceStrongScheduling() {
        this.enforcedSceduling = true;
        this.strongEnforcedScheduling = true;
    }

    public void unforceScheduling() {
        this.enforcedSceduling = false;
        this.strongEnforcedScheduling = false;
    }

    public void setEnforcingData(DataInstanceId dataId) {
        this.enforcingData = dataId;
    }

    public TaskParams getTaskParams() {
        return this.taskParams;
    }

    public boolean isSchedulingForced() {
        return this.enforcedSceduling;
    }

    public boolean isSchedulingStrongForced() {
        return this.strongEnforcedScheduling;
    }

    public String getLastResource() {
        return this.lastResource;
    }

    public void setLastResource(String lastResource) {
        this.lastResource = lastResource;
    }

    public DataInstanceId getEnforcingData() {
        return this.enforcingData;
    }

    public long getInitialTimeStamp() {
        return this.initialTimeStamp;
    }

    public String getDotDescription() {
        ColorConf color = COLORS[this.taskParams.getId() % COLORS.length];
        String shape = this.taskParams.getType() == TaskParams.Type.METHOD ? "circle" : "diamond";
        return this.getId() + "[shape=" + shape + ", " + "style=filled fillcolor=\"" + color.fillColor + "\" fontcolor=\"" + color.fontColor + "\"];";
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[[Task id: ").append(this.getId()).append("]");
        buffer.append(", [Status: ").append((Object)this.getStatus()).append("]");
        buffer.append(", ").append(this.getTaskParams().toString()).append("]");
        return buffer.toString();
    }

    @Override
    public int compareTo(Task task) {
        if (task == null) {
            throw new NullPointerException();
        }
        return this.getId() - task.getId();
    }

    public boolean equals(Object o) {
        return o instanceof Task && this.taskId == ((Task)o).taskId;
    }

    public int hashCode() {
        return super.hashCode();
    }

    private static class ColorConf {
        String fillColor;
        String fontColor;

        ColorConf(String fillColor, String fontColor) {
            this.fillColor = fillColor;
            this.fontColor = fontColor;
        }
    }

    public static enum TaskState {
        TO_ANALYSE,
        TO_SCHEDULE,
        TO_RESCHEDULE,
        TO_EXECUTE,
        FINISHED,
        FAILED;

    }
}

