/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.data;

import integratedtoolkit.types.data.DataInstanceId;
import java.io.Serializable;

public abstract class DataAccessId
implements Serializable {
    public abstract int getDataId();

    public static class RWAccessId
    extends DataAccessId {
        private DataInstanceId readDataInstance;
        private DataInstanceId writtenDataInstance;

        public RWAccessId() {
        }

        public RWAccessId(int dataId, int rVersionId, int wVersionId) {
            this.readDataInstance = new DataInstanceId(dataId, rVersionId);
            this.writtenDataInstance = new DataInstanceId(dataId, wVersionId);
        }

        public RWAccessId(DataInstanceId rdi, DataInstanceId wdi) {
            this.readDataInstance = rdi;
            this.writtenDataInstance = wdi;
        }

        @Override
        public int getDataId() {
            return this.readDataInstance.getDataId();
        }

        public int getRVersionId() {
            return this.readDataInstance.getVersionId();
        }

        public int getWVersionId() {
            return this.writtenDataInstance.getVersionId();
        }

        public DataInstanceId getReadDataInstance() {
            return this.readDataInstance;
        }

        public DataInstanceId getWrittenDataInstance() {
            return this.writtenDataInstance;
        }

        public String toString() {
            return "Read data: " + this.readDataInstance + ", Written data: " + this.writtenDataInstance;
        }
    }

    public static class WAccessId
    extends DataAccessId {
        private DataInstanceId writtenDataInstance;

        public WAccessId() {
        }

        public WAccessId(int dataId, int wVersionId) {
            this.writtenDataInstance = new DataInstanceId(dataId, wVersionId);
        }

        public WAccessId(DataInstanceId wdi) {
            this.writtenDataInstance = wdi;
        }

        @Override
        public int getDataId() {
            return this.writtenDataInstance.getDataId();
        }

        public int getWVersionId() {
            return this.writtenDataInstance.getVersionId();
        }

        public DataInstanceId getWrittenDataInstance() {
            return this.writtenDataInstance;
        }

        public String toString() {
            return "Written data: " + this.writtenDataInstance;
        }
    }

    public static class RAccessId
    extends DataAccessId {
        private DataInstanceId readDataInstance;

        public RAccessId() {
        }

        public RAccessId(int dataId, int rVersionId) {
            this.readDataInstance = new DataInstanceId(dataId, rVersionId);
        }

        public RAccessId(DataInstanceId rdi) {
            this.readDataInstance = rdi;
        }

        @Override
        public int getDataId() {
            return this.readDataInstance.getDataId();
        }

        public int getRVersionId() {
            return this.readDataInstance.getVersionId();
        }

        public DataInstanceId getReadDataInstance() {
            return this.readDataInstance;
        }

        public String toString() {
            return "Read data: " + this.readDataInstance;
        }
    }
}

