/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.data.location;

import integratedtoolkit.types.resources.Resource;
import java.util.HashMap;
import java.util.Map;

public class URI
implements Comparable<URI> {
    private final String scheme;
    private final Resource host;
    private final String path;
    private final HashMap<String, Object> internal;
    protected static final String ANY_PROT = "any://";

    public URI(Resource host, String path) {
        this.scheme = ANY_PROT;
        this.host = host;
        this.path = path;
        this.internal = new HashMap();
    }

    public URI(String scheme, Resource host, String path) {
        this.scheme = scheme;
        this.host = host;
        this.path = path;
        this.internal = new HashMap();
    }

    public void setInternalURI(String adaptor, Object uri) {
        this.internal.put(adaptor, uri);
    }

    public Object getInternalURI(String adaptor) {
        Object o = this.internal.get(adaptor);
        if (o == null) {
            this.host.setInternalURI(this);
            o = this.internal.get(adaptor);
        }
        return o;
    }

    public Resource getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String toString() {
        return this.scheme + this.host.getName() + "/" + this.path;
    }

    public String debugString() {
        StringBuilder sb = new StringBuilder(this.scheme + this.host.toString() + "/" + this.path + "\n");
        for (Map.Entry<String, Object> e : this.internal.entrySet()) {
            sb.append("\t * ").append(e.getKey()).append(" -> ").append(e.getValue()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(URI o) {
        if (o == null) {
            throw new NullPointerException();
        }
        int compare = this.host.getName().compareTo(o.host.getName());
        if (compare == 0) {
            compare = this.path.compareTo(o.path);
        }
        return compare;
    }
}

