/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.resources;

import integratedtoolkit.types.AdaptorDescription;
import integratedtoolkit.types.Implementation;
import integratedtoolkit.types.annotations.Constraints;
import integratedtoolkit.types.resources.WorkerResourceDescription;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.w3c.dom.Node;

public class MethodResourceDescription
extends WorkerResourceDescription {
    public static final MethodResourceDescription EMPTY = new MethodResourceDescription();
    private static final String UNASSIGNED = "[unassigned]";
    protected List<String> hostQueue;
    protected String processorArchitecture = "[unassigned]";
    protected int processorCPUCount = 0;
    protected int processorCoreCount = 0;
    protected float processorSpeed = 0.0f;
    protected float memoryPhysicalSize = 0.0f;
    protected float memoryVirtualSize = 0.0f;
    protected float memoryAccessTime = 0.0f;
    protected float memorySTR = 0.0f;
    protected float storageElemSize = 0.0f;
    protected float storageElemAccessTime = 0.0f;
    protected float storageElemSTR = 0.0f;
    protected String operatingSystemType = "[unassigned]";
    protected List<String> appSoftware;
    protected int slots = 0;
    protected Float value = Float.valueOf(0.0f);
    protected TreeMap<String, AdaptorDescription> adaptorsDesc;
    public static final String PROC_ARCH = "ProcessorArch";
    public static final String PROC_CPU_COUNT = "ProcessorCPUCount";
    public static final String PROC_CORE_COUNT = "ProcessorCoreCount";
    public static final String PROC_SPEED = "ProcessorSpeed";
    public static final String MEM_PHYSICAL_SIZE = "MemoryPhysicalSize";
    public static final String MEM_VIRTUAL_SIZE = "MemoryVirtualSize";
    public static final String MEM_ACCESS_TIME = "MemoryAccessTime";
    public static final String MEM_STR = "MemorySTR";
    public static final String STORAGE_ELEM_SIZE = "StorageElemSize";
    public static final String STORAGE_ACCESS_TIME = "StorageElemAccessTime";
    public static final String STORAGE_ELEM_STR = "StorageElemSTR";
    public static final String OS_TYPE = "OperatingSystemType";
    public static final String HOST_QUEUE = "HostQueue";
    public static final String APP_SOFTWARE = "AppSoftware";

    public MethodResourceDescription() {
        this.hostQueue = new LinkedList<String>();
        this.appSoftware = new LinkedList<String>();
    }

    public MethodResourceDescription(Constraints constraints) {
        this.hostQueue = new LinkedList<String>();
        String queueString = constraints.hostQueue();
        if (queueString.compareTo(UNASSIGNED) != 0) {
            for (String value : queueString.split(",")) {
                this.hostQueue.add(value.trim());
            }
        }
        this.processorArchitecture = constraints.processorArchitecture();
        this.processorCPUCount = constraints.processorCPUCount();
        this.processorCoreCount = constraints.processorCoreCount();
        this.processorSpeed = constraints.processorSpeed();
        this.memoryPhysicalSize = constraints.memoryPhysicalSize();
        this.memoryVirtualSize = constraints.memoryVirtualSize();
        this.memoryAccessTime = constraints.memoryAccessTime();
        this.memorySTR = constraints.memorySTR();
        this.storageElemSize = constraints.storageElemSize();
        this.storageElemAccessTime = constraints.storageElemAccessTime();
        this.storageElemSTR = constraints.storageElemSTR();
        this.operatingSystemType = constraints.operatingSystemType();
        this.appSoftware = new LinkedList<String>();
        String software = constraints.appSoftware();
        if (software.compareTo(UNASSIGNED) != 0) {
            for (String value : software.split(",")) {
                this.appSoftware.add(value.trim());
            }
        }
    }

    public MethodResourceDescription(String description) {
        String[] constraints = description.split(";");
        this.hostQueue = new LinkedList<String>();
        this.appSoftware = new LinkedList<String>();
        block32: for (String c : constraints) {
            String key = c.split(":")[0].trim();
            String val = c.split(":")[1].trim();
            switch (key) {
                case "ProcessorArch": {
                    this.processorArchitecture = val;
                    continue block32;
                }
                case "ProcessorCPUCount": {
                    this.processorCPUCount = Integer.parseInt(val);
                    continue block32;
                }
                case "ProcessorCoreCount": {
                    this.processorCoreCount = Integer.parseInt(val);
                    continue block32;
                }
                case "ProcessorSpeed": {
                    this.processorSpeed = Float.parseFloat(val);
                    continue block32;
                }
                case "MemoryPhysicalSize": {
                    this.memoryPhysicalSize = Float.parseFloat(val);
                    continue block32;
                }
                case "MemoryVirtualSize": {
                    this.memoryVirtualSize = Float.parseFloat(val);
                    continue block32;
                }
                case "MemoryAccessTime": {
                    this.memoryAccessTime = Float.parseFloat(val);
                    continue block32;
                }
                case "MemorySTR": {
                    this.memorySTR = Float.parseFloat(val);
                    continue block32;
                }
                case "StorageElemSize": {
                    this.storageElemSize = Float.parseFloat(val);
                    continue block32;
                }
                case "StorageElemAccessTime": {
                    this.storageElemAccessTime = Float.parseFloat(val);
                    continue block32;
                }
                case "StorageElemSTR": {
                    this.storageElemSTR = Float.parseFloat(val);
                    continue block32;
                }
                case "OperatingSystemType": {
                    this.operatingSystemType = val;
                    continue block32;
                }
                case "HostQueue": {
                    if (val.compareTo(UNASSIGNED) == 0) continue block32;
                    for (String host : val.split(",")) {
                        this.hostQueue.add(host.trim());
                    }
                    continue block32;
                }
                case "AppSoftware": {
                    if (val.compareTo(UNASSIGNED) == 0) continue block32;
                    for (String app : val.split(",")) {
                        this.appSoftware.add(app.trim());
                    }
                    continue block32;
                }
            }
        }
    }

    public MethodResourceDescription(MethodResourceDescription clone) {
        super(clone);
        int i;
        this.processorArchitecture = clone.processorArchitecture;
        this.processorCPUCount = clone.processorCPUCount;
        this.processorCoreCount = clone.processorCoreCount;
        this.processorSpeed = clone.processorSpeed;
        this.memoryPhysicalSize = clone.memoryPhysicalSize;
        this.memoryVirtualSize = clone.memoryVirtualSize;
        this.memoryAccessTime = clone.memoryAccessTime;
        this.memorySTR = clone.memorySTR;
        this.storageElemSize = clone.storageElemSize;
        this.storageElemAccessTime = clone.storageElemAccessTime;
        this.storageElemSTR = clone.storageElemSTR;
        this.operatingSystemType = clone.operatingSystemType;
        this.hostQueue = new LinkedList<String>();
        for (i = 0; i < clone.hostQueue.size(); ++i) {
            this.hostQueue.add(clone.hostQueue.get(i));
        }
        this.appSoftware = new LinkedList<String>();
        for (i = 0; i < clone.appSoftware.size(); ++i) {
            this.appSoftware.add(clone.appSoftware.get(i));
        }
        this.slots = clone.slots;
        this.value = clone.value;
    }

    public MethodResourceDescription(Node n) {
        this.hostQueue = new LinkedList<String>();
        this.appSoftware = new LinkedList<String>();
        for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
            Node capabilities = n.getChildNodes().item(i);
            if ("Capabilities".equals(capabilities.getNodeName())) {
                this.parseCapabilities(capabilities);
                continue;
            }
            if (!"Price".equals(capabilities.getNodeName())) continue;
            this.value = Float.valueOf(Float.parseFloat(capabilities.getTextContent()));
        }
    }

    private void parseCapabilities(Node capabilities) {
        for (int j = 0; j < capabilities.getChildNodes().getLength(); ++j) {
            if ("Host".equals(capabilities.getChildNodes().item(j).getNodeName())) {
                this.parseHost(capabilities.getChildNodes().item(j));
                continue;
            }
            if ("Processor".equals(capabilities.getChildNodes().item(j).getNodeName())) {
                this.parseProcessor(capabilities.getChildNodes().item(j));
                continue;
            }
            if ("OS".equals(capabilities.getChildNodes().item(j).getNodeName())) {
                this.parseOS(capabilities.getChildNodes().item(j));
                continue;
            }
            if ("StorageElement".equals(capabilities.getChildNodes().item(j).getNodeName())) {
                this.parseStorage(capabilities.getChildNodes().item(j));
                continue;
            }
            if ("Memory".equals(capabilities.getChildNodes().item(j).getNodeName())) {
                this.parseMemory(capabilities.getChildNodes().item(j));
                continue;
            }
            if (!"ApplicationSoftware".equals(capabilities.getChildNodes().item(j).getNodeName())) continue;
            this.parseApps(capabilities.getChildNodes().item(j));
        }
    }

    private void parseHost(Node host) {
        for (int k = 0; k < host.getChildNodes().getLength(); ++k) {
            if (!"Queue".equals(host.getChildNodes().item(k).getNodeName())) continue;
            this.hostQueue.add(host.getChildNodes().item(k).getTextContent());
        }
    }

    private void parseProcessor(Node processor) {
        for (int k = 0; k < processor.getChildNodes().getLength(); ++k) {
            if ("Architecture".equals(processor.getChildNodes().item(k).getNodeName())) {
                this.processorArchitecture = processor.getChildNodes().item(k).getTextContent();
                continue;
            }
            if ("CPUCount".equals(processor.getChildNodes().item(k).getNodeName())) {
                this.processorCPUCount = Integer.parseInt(processor.getChildNodes().item(k).getTextContent());
                continue;
            }
            if ("CoreCount".equals(processor.getChildNodes().item(k).getNodeName())) {
                this.processorCoreCount = Integer.parseInt(processor.getChildNodes().item(k).getTextContent());
                if (this.processorCPUCount != 0) continue;
                this.processorCPUCount = 1;
                continue;
            }
            if (!"Speed".equals(processor.getChildNodes().item(k).getNodeName())) continue;
            this.processorSpeed = Float.parseFloat(processor.getChildNodes().item(k).getTextContent());
        }
    }

    private void parseOS(Node os) {
        for (int k = 0; k < os.getChildNodes().getLength(); ++k) {
            if (!"OSType".equals(os.getChildNodes().item(k).getNodeName())) continue;
            this.operatingSystemType = os.getChildNodes().item(k).getTextContent();
        }
    }

    private void parseStorage(Node storage) {
        for (int k = 0; k < storage.getChildNodes().getLength(); ++k) {
            if ("Size".equals(storage.getChildNodes().item(k).getNodeName())) {
                this.storageElemSize = Float.parseFloat(storage.getChildNodes().item(k).getTextContent());
                continue;
            }
            if ("AccessTime".equals(storage.getChildNodes().item(k).getNodeName())) {
                this.storageElemAccessTime = Float.parseFloat(storage.getChildNodes().item(k).getTextContent());
                continue;
            }
            if (!"STR".equals(storage.getChildNodes().item(k).getNodeName())) continue;
            this.storageElemSTR = Float.parseFloat(storage.getChildNodes().item(k).getTextContent());
        }
    }

    private void parseMemory(Node memory) {
        for (int k = 0; k < memory.getChildNodes().getLength(); ++k) {
            if ("PhysicalSize".equals(memory.getChildNodes().item(k).getNodeName())) {
                this.memoryPhysicalSize = Float.parseFloat(memory.getChildNodes().item(k).getTextContent());
                continue;
            }
            if ("VirtualSize".equals(memory.getChildNodes().item(k).getNodeName())) {
                this.memoryVirtualSize = Float.parseFloat(memory.getChildNodes().item(k).getTextContent());
                continue;
            }
            if ("AccessTime".equals(memory.getChildNodes().item(k).getNodeName())) {
                this.memoryAccessTime = Float.parseFloat(memory.getChildNodes().item(k).getTextContent());
                continue;
            }
            if (!"STR".equals(memory.getChildNodes().item(k).getNodeName())) continue;
            this.memorySTR = Float.parseFloat(memory.getChildNodes().item(k).getTextContent());
        }
    }

    private void parseApps(Node apps) {
        for (int k = 0; k < apps.getChildNodes().getLength(); ++k) {
            if ("#text".equals(apps.getChildNodes().item(k).getNodeName())) continue;
            for (int app = 0; app < apps.getChildNodes().getLength(); ++app) {
                this.appSoftware.add(apps.getChildNodes().item(app).getTextContent());
            }
        }
    }

    public int getSlots() {
        return this.slots;
    }

    public void setSlots(int qty) {
        this.slots = qty;
    }

    public void addSlot() {
        ++this.slots;
    }

    public String getProcessorArchitecture() {
        return this.processorArchitecture;
    }

    public void setProcessorArchitecture(String architecture) {
        this.processorArchitecture = architecture;
    }

    public int getProcessorCPUCount() {
        return this.processorCPUCount;
    }

    public void setProcessorCPUCount(int count) {
        this.processorCPUCount = count;
    }

    public int getProcessorCoreCount() {
        return this.processorCoreCount;
    }

    public void setProcessorCoreCount(int count) {
        this.processorCoreCount = count;
    }

    public float getProcessorSpeed() {
        return this.processorSpeed;
    }

    public void setProcessorSpeed(float ghz) {
        this.processorSpeed = ghz;
    }

    public float getMemoryPhysicalSize() {
        return this.memoryPhysicalSize;
    }

    public void setMemoryPhysicalSize(float gb) {
        this.memoryPhysicalSize = gb;
    }

    public float getMemoryVirtualSize() {
        return this.memoryVirtualSize;
    }

    public void setMemoryVirtualSize(float gb) {
        this.memoryVirtualSize = gb;
    }

    public float getMemoryAccessTime() {
        return this.memoryAccessTime;
    }

    public void setMemoryAccessTime(float ns) {
        this.memoryAccessTime = ns;
    }

    public float getMemorySTR() {
        return this.memorySTR;
    }

    public void setMemorySTR(float gBs) {
        this.memorySTR = gBs;
    }

    public float getStorageElemSize() {
        return this.storageElemSize;
    }

    public void setStorageElemSize(float gb) {
        this.storageElemSize = gb;
    }

    public float getStorageElemAccessTime() {
        return this.storageElemAccessTime;
    }

    public void setStorageElemAccessTime(float ms) {
        this.storageElemAccessTime = ms;
    }

    public float getStorageElemSTR() {
        return this.storageElemSTR;
    }

    public void setStorageElemSTR(float mbs) {
        this.storageElemSTR = mbs;
    }

    public List<String> getHostQueue() {
        return this.hostQueue;
    }

    public void setHostQueue(List<String> hostQueue) {
        this.hostQueue = new LinkedList<String>(hostQueue);
    }

    public void addHostQueue(String queue) {
        this.hostQueue.add(queue);
    }

    public String getOperatingSystemType() {
        return this.operatingSystemType;
    }

    public void setOperatingSystemType(String osType) {
        this.operatingSystemType = osType;
    }

    public List<String> getAppSoftware() {
        return this.appSoftware;
    }

    public void setAppSoftware(List<String> appSoftware) {
        this.appSoftware = new LinkedList<String>(appSoftware);
    }

    public void resetAppSoftware() {
        this.appSoftware = new LinkedList<String>();
    }

    public void addAppSoftware(String software) {
        this.appSoftware.add(software);
    }

    public Float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = Float.valueOf(value);
    }

    public void join(MethodResourceDescription mr2) {
        int i;
        this.processorCPUCount = Math.max(this.processorCPUCount, mr2.processorCPUCount);
        this.processorCoreCount = Math.max(this.processorCoreCount, mr2.processorCoreCount);
        this.processorSpeed = Math.max(this.processorSpeed, mr2.processorSpeed);
        this.memoryPhysicalSize = Math.max(this.memoryPhysicalSize, mr2.memoryPhysicalSize);
        this.memoryVirtualSize = Math.max(this.memoryVirtualSize, mr2.memoryVirtualSize);
        this.memoryAccessTime = Math.max(this.memoryAccessTime, mr2.memoryAccessTime);
        this.memorySTR = Math.max(this.memorySTR, mr2.memorySTR);
        this.storageElemSize = Math.max(this.storageElemSize, mr2.storageElemSize);
        this.storageElemAccessTime = Math.max(this.storageElemAccessTime, mr2.storageElemAccessTime);
        this.storageElemSTR = Math.max(this.storageElemSTR, mr2.storageElemSTR);
        if (this.processorArchitecture.compareTo(UNASSIGNED) == 0) {
            this.processorArchitecture = mr2.processorArchitecture;
        }
        if (this.operatingSystemType.compareTo(UNASSIGNED) == 0) {
            this.operatingSystemType = mr2.operatingSystemType;
        }
        for (i = 0; i < mr2.hostQueue.size(); ++i) {
            if (this.hostQueue.contains(mr2.hostQueue.get(i))) continue;
            this.hostQueue.add(mr2.hostQueue.get(i));
        }
        for (i = 0; i < mr2.appSoftware.size(); ++i) {
            if (this.appSoftware.contains(mr2.appSoftware.get(i))) continue;
            this.appSoftware.add(mr2.appSoftware.get(i));
        }
        this.slots += mr2.slots;
    }

    public float difference(MethodResourceDescription mr2) {
        int weight = 10000;
        float processorDif = this.processorCoreCount - mr2.processorCoreCount;
        float memoryDif = this.memoryPhysicalSize - mr2.memoryPhysicalSize;
        return processorDif * (float)weight + memoryDif;
    }

    public boolean contains(MethodResourceDescription rc2) {
        boolean contained = this.checkCompatibility(this.operatingSystemType, rc2.operatingSystemType);
        contained = contained && this.hostQueue.containsAll(rc2.hostQueue);
        contained = contained && this.appSoftware.containsAll(rc2.appSoftware);
        contained = contained && this.checkProcessor(rc2);
        contained = contained && this.checkMemory(rc2);
        contained = contained && this.checkStorage(rc2);
        return contained;
    }

    private boolean checkProcessor(MethodResourceDescription rc2) {
        return this.checkCompatibility(this.processorArchitecture, rc2.processorArchitecture) && this.checkInclusion(this.processorCoreCount, rc2.processorCoreCount) && this.checkInclusion(this.processorCPUCount, rc2.processorCPUCount) && this.checkInclusion(this.processorSpeed, rc2.processorSpeed);
    }

    private boolean checkMemory(MethodResourceDescription rc2) {
        return this.checkInclusion(this.memoryPhysicalSize, rc2.memoryPhysicalSize) && this.checkInclusion(this.memoryVirtualSize, rc2.memoryVirtualSize) && this.checkInclusion(this.memorySTR, rc2.memorySTR) && this.checkInclusion(rc2.memoryAccessTime, this.memoryAccessTime);
    }

    private boolean checkStorage(MethodResourceDescription rc2) {
        return this.checkInclusion(rc2.storageElemAccessTime, this.storageElemAccessTime) && this.checkInclusion(this.storageElemSTR, rc2.storageElemSTR) && this.checkInclusion(this.storageElemSize, rc2.storageElemSize);
    }

    private boolean checkCompatibility(String value1, String value2) {
        return value1.equals(value2) || value1.equals(UNASSIGNED) || value2.equals(UNASSIGNED);
    }

    private boolean checkInclusion(int value1, int value2) {
        return value1 >= value2 || value1 == 0 || value2 == 0;
    }

    private boolean checkInclusion(float value1, float value2) {
        return value1 >= value2 || value1 == 0.0f || value2 == 0.0f;
    }

    public Integer canHostSimultaneously(MethodResourceDescription rc2) {
        float ratio;
        float min = Float.MAX_VALUE;
        if (rc2.processorCoreCount != 0) {
            min = ratio = (float)this.processorCoreCount / (float)rc2.processorCoreCount;
        }
        if (rc2.processorCPUCount != 0) {
            min = ratio = (float)this.processorCPUCount / (float)rc2.processorCPUCount;
        }
        if (rc2.memoryPhysicalSize != 0.0f) {
            ratio = this.memoryPhysicalSize / rc2.memoryPhysicalSize;
            min = Math.min(min, ratio);
        }
        if (rc2.memoryVirtualSize != 0.0f) {
            ratio = this.memoryVirtualSize / rc2.memoryVirtualSize;
            min = Math.min(min, ratio);
        }
        if (rc2.storageElemSize != 0.0f) {
            ratio = this.storageElemSize / rc2.storageElemSize;
            min = Math.min(min, ratio);
        }
        return (int)min;
    }

    public MethodResourceDescription multiply(int amount) {
        MethodResourceDescription rd = new MethodResourceDescription();
        rd.processorCoreCount = this.processorCoreCount * amount;
        rd.processorCPUCount = this.processorCPUCount * amount;
        rd.memoryPhysicalSize = this.memoryPhysicalSize * (float)amount;
        rd.memoryVirtualSize = this.memoryVirtualSize * (float)amount;
        rd.storageElemSize = this.storageElemSize * (float)amount;
        return rd;
    }

    public void increase(MethodResourceDescription rd) {
        this.processorCPUCount += rd.processorCPUCount;
        this.processorCoreCount += rd.processorCoreCount;
        this.memoryPhysicalSize += rd.memoryPhysicalSize;
        this.memoryVirtualSize += rd.memoryVirtualSize;
        this.storageElemSize += rd.storageElemSize;
    }

    public void reduce(MethodResourceDescription rd) {
        this.processorCPUCount -= rd.processorCPUCount;
        this.processorCoreCount -= rd.processorCoreCount;
        this.memoryPhysicalSize -= rd.memoryPhysicalSize;
        this.memoryVirtualSize -= rd.memoryVirtualSize;
        this.storageElemSize -= rd.storageElemSize;
    }

    @Override
    public boolean canHost(Implementation<?> impl) {
        if (impl.getType() == Implementation.Type.METHOD) {
            MethodResourceDescription wd = (MethodResourceDescription)impl.getRequirements();
            return this.contains(wd);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[FEATURES");
        sb.append(" [PROCESSOR");
        sb.append(" ARCHITECTURE=").append(this.processorArchitecture);
        sb.append(" CPUS=").append(this.processorCPUCount);
        sb.append(" CORES=").append(this.processorCoreCount);
        sb.append(" SPEED=").append(this.processorSpeed);
        sb.append("]");
        sb.append(" [MEMORY");
        sb.append(" PHYSICAL=").append(this.memoryPhysicalSize);
        sb.append(" VIRTUAL=").append(this.memoryVirtualSize);
        sb.append(" ACCESS_TIME=").append(this.memoryAccessTime);
        sb.append(" STR=").append(this.memorySTR);
        sb.append("]");
        sb.append(" [STORAGE");
        sb.append(" SIZE=").append(this.storageElemSize);
        sb.append(" ACCESS_TIME=").append(this.storageElemAccessTime);
        sb.append(" STR=").append(this.storageElemSTR);
        sb.append("]");
        sb.append(" [OS ");
        sb.append(this.operatingSystemType);
        sb.append("]");
        sb.append(" [QUEUES ");
        for (String queue : this.hostQueue) {
            sb.append(queue).append(" ");
        }
        sb.append(" [SOFTWARE ");
        for (String app : this.appSoftware) {
            sb.append(app).append(" ");
        }
        sb.append("]");
        sb.append("]");
        return sb.toString();
    }
}

