/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.connectors.amazon;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.CreateSecurityGroupRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.DescribeKeyPairsResult;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsResult;
import com.amazonaws.services.ec2.model.ImportKeyPairRequest;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceState;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.KeyPairInfo;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import integratedtoolkit.connectors.AbstractSSHConnector;
import integratedtoolkit.connectors.ConnectorException;
import integratedtoolkit.connectors.amazon.AmazonVM;
import integratedtoolkit.types.resources.description.CloudMethodResourceDescription;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class EC2
extends AbstractSSHConnector {
    private static String accessKeyId;
    private static String secretKeyId;
    private static String keyPairName;
    private static String keyLocation;
    private static String securityGroupName;
    private static String placementCode;
    private static int placement;
    private static String MAX_VM_CREATION_TIME;
    private static AmazonEC2Client client;

    public EC2(String name, HashMap<String, String> h) {
        super(name, h);
        accessKeyId = h.get("ec2-cred-access-key-id");
        secretKeyId = h.get("ec2-cred-secret-key-id");
        securityGroupName = h.get("ec2-security-group-name");
        placementCode = h.get("ec2-placement");
        placement = AmazonVM.translatePlacement(placementCode);
        client = new AmazonEC2Client((AWSCredentials)new BasicAWSCredentials(accessKeyId, secretKeyId));
        if (h.get("max-vm-creation-time") != null) {
            MAX_VM_CREATION_TIME = h.get("max-vm-creation-time");
        }
        boolean found = false;
        DescribeKeyPairsResult dkpr = client.describeKeyPairs();
        for (KeyPairInfo kp : dkpr.getKeyPairs()) {
            if (kp.getKeyName().compareTo(keyPairName) != 0) continue;
            found = true;
            break;
        }
        if (!found) {
            try {
                ImportKeyPairRequest ikpReq = new ImportKeyPairRequest(keyPairName, EC2.getPublicKey());
                client.importKeyPair(ikpReq);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        found = false;
        DescribeSecurityGroupsResult dsgr = client.describeSecurityGroups();
        for (SecurityGroup sg : dsgr.getSecurityGroups()) {
            if (sg.getGroupName().compareTo(securityGroupName) != 0) continue;
            found = true;
            break;
        }
        if (!found) {
            try {
                CreateSecurityGroupRequest sg = new CreateSecurityGroupRequest(securityGroupName, "Default compss security");
                client.createSecurityGroup(sg);
                IpPermission ipp = new IpPermission();
                ipp.setToPort(Integer.valueOf(22));
                ipp.setFromPort(Integer.valueOf(22));
                ipp.setIpProtocol("tcp");
                ArrayList<String> ipranges = new ArrayList<String>();
                ipranges.add("0.0.0.0/0");
                ipp.setIpRanges(ipranges);
                ArrayList<IpPermission> list_ipp = new ArrayList<IpPermission>();
                list_ipp.add(ipp);
                AuthorizeSecurityGroupIngressRequest asgi = new AuthorizeSecurityGroupIngressRequest(securityGroupName, list_ipp);
                client.authorizeSecurityGroupIngress(asgi);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void destroy(Object worker) throws ConnectorException {
        try {
            RunInstancesResult workerInstance = (RunInstancesResult)worker;
            String instanceId = ((Instance)workerInstance.getReservation().getInstances().get(0)).getInstanceId();
            ArrayList<String> instanceIds = new ArrayList<String>();
            instanceIds.add(instanceId);
            TerminateInstancesRequest tir = new TerminateInstancesRequest(instanceIds);
            client.terminateInstances(tir);
        }
        catch (Exception e) {
            throw new ConnectorException(e);
        }
    }

    private static String getPublicKey() throws Exception {
        try (BufferedReader br = null;){
            br = new BufferedReader(new FileReader(keyLocation + File.separator + keyPairName + ".pub"));
            StringBuilder key = new StringBuilder();
            String sb = br.readLine();
            while (sb != null) {
                key.append(sb).append("\n");
                sb = br.readLine();
            }
            String string = key.toString();
            return string;
        }
    }

    private RunInstancesResult createMachine(String instanceCode, String diskImage) throws InterruptedException {
        RunInstancesRequest runInstancesRequest = new RunInstancesRequest(diskImage, Integer.valueOf(1), Integer.valueOf(1));
        Placement placement = new Placement(placementCode);
        runInstancesRequest.setPlacement(placement);
        runInstancesRequest.setInstanceType(instanceCode);
        runInstancesRequest.setKeyName(keyPairName);
        ArrayList<String> groupId = new ArrayList<String>();
        groupId.add(securityGroupName);
        runInstancesRequest.setSecurityGroups(groupId);
        return client.runInstances(runInstancesRequest);
    }

    public String getId() {
        return "amazon.ec2";
    }

    public String getDefaultUser() {
        return "ec2-user";
    }

    public String getDefaultWDir() {
        return "/home/ec2-user/wDir/";
    }

    public String getDefaultIDir() {
        return "/home/ec2-user/iDir/";
    }

    public Object create(String name, CloudMethodResourceDescription requested) throws ConnectorException {
        String arch = requested.getImage().getArch();
        logger.debug((Object)("Requesting machine creation " + name + ", with arch " + arch + ", description: " + requested));
        String instanceCode = AmazonVM.classifyMachine(requested.getProcessorCoreCount(), requested.getMemoryPhysicalSize() * 1024.0f, requested.getStorageElemSize() * 1024.0f, arch);
        try {
            RunInstancesResult res = this.createMachine(instanceCode, requested.getImage().getName());
            logger.debug((Object)"Request for VM creation sent");
            return res;
        }
        catch (Exception e) {
            logger.error((Object)("Error creating machine " + name), (Throwable)e);
            throw new ConnectorException(e);
        }
    }

    public CloudMethodResourceDescription waitUntilCreation(Object vm, CloudMethodResourceDescription requested) throws ConnectorException {
        CloudMethodResourceDescription granted = new CloudMethodResourceDescription();
        Integer poll_time = 5;
        Integer polls = 0;
        int errors = 0;
        DescribeInstancesResult dir = null;
        InstanceState status = ((Instance)((RunInstancesResult)vm).getReservation().getInstances().get(0)).getState();
        while (status.getCode() == 0) {
            try {
                Thread.sleep(poll_time * 1000);
                if (poll_time * polls >= Integer.parseInt(MAX_VM_CREATION_TIME) * 60) {
                    throw new ConnectorException("Maximum VM creation time reached.");
                }
                Integer n = polls;
                Integer n2 = polls = Integer.valueOf(polls + 1);
                DescribeInstancesRequest describeInstancesRequest = new DescribeInstancesRequest();
                ArrayList<String> l = new ArrayList<String>();
                l.add(((Instance)((RunInstancesResult)vm).getReservation().getInstances().get(0)).getInstanceId());
                describeInstancesRequest.setInstanceIds(l);
                dir = client.describeInstances(describeInstancesRequest);
                status = ((Instance)((Reservation)dir.getReservations().get(0)).getInstances().get(0)).getState();
                errors = 0;
            }
            catch (Exception e) {
                if (++errors != 3) continue;
                throw new ConnectorException(e);
            }
        }
        Instance instance = (Instance)((Reservation)dir.getReservations().get(0)).getInstances().get(0);
        String instanceType = instance.getInstanceType();
        String instanceId = instance.getInstanceId();
        String ip = instance.getPublicIpAddress();
        granted.setName(ip);
        AmazonVM vmInfo = new AmazonVM(instanceId, granted, instanceType, placement);
        int cpuCount = vmInfo.getType().getCpucount();
        granted.setProcessorCoreCount(cpuCount);
        granted.setProcessorArchitecture(requested.getProcessorArchitecture());
        granted.setProcessorSpeed(requested.getProcessorSpeed());
        float memorySize = vmInfo.getType().getMemory() / 1024.0f;
        granted.setMemoryAccessTime(requested.getMemoryAccessTime());
        granted.setMemoryPhysicalSize(memorySize);
        granted.setMemorySTR(requested.getMemorySTR());
        granted.setMemoryVirtualSize(requested.getMemoryVirtualSize());
        float homeSize = vmInfo.getType().getDisk() / 1024.0f;
        granted.setStorageElemAccessTime(requested.getStorageElemAccessTime());
        granted.setStorageElemSTR(requested.getStorageElemSTR());
        granted.setStorageElemSize(homeSize);
        granted.setOperatingSystemType("Linux");
        granted.setSlots(requested.getSlots());
        List apps = requested.getAppSoftware();
        for (int i = 0; i < apps.size(); ++i) {
            granted.addAppSoftware((String)apps.get(i));
        }
        granted.setType(instanceType);
        granted.setImage(requested.getImage());
        granted.setValue(this.getMachineCostPerHour(granted).floatValue());
        return granted;
    }

    public float getMachineCostPerTimeSlot(CloudMethodResourceDescription rc) {
        return AmazonVM.getPrice(rc.getType(), placement);
    }

    public long getTimeSlot() {
        return 3600000L;
    }

    static {
        MAX_VM_CREATION_TIME = "10";
    }
}

