/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.gat.worker;

import integratedtoolkit.util.ErrorManager;
import integratedtoolkit.util.Serializer;
import java.io.File;
import java.lang.reflect.Method;

public class GATWorker {
    protected static final int NUM_HEADER_PARS = 5;
    protected static final int FILE_PAR = 0;
    protected static final int BOOL_PAR = 1;
    protected static final int CHAR_PAR = 2;
    protected static final int STRING_PAR = 3;
    protected static final int BYTE_PAR = 4;
    protected static final int SHORT_PAR = 5;
    protected static final int INT_PAR = 6;
    protected static final int LONG_PAR = 7;
    protected static final int FLOAT_PAR = 8;
    protected static final int DOUBLE_PAR = 9;
    protected static final int OBJECT_PAR = 10;

    public static void main(String[] args) {
        int i;
        Object[] values;
        Class[] types;
        boolean debug = Boolean.parseBoolean(args[0]);
        String className = args[1];
        String methodName = args[2];
        boolean hasTarget = Boolean.parseBoolean(args[3]);
        int numParams = Integer.parseInt(args[4]);
        if (args.length < 2 * numParams + 5) {
            ErrorManager.error("Application class not found");
        }
        if (hasTarget) {
            types = new Class[numParams - 1];
            values = new Object[numParams - 1];
        } else {
            types = new Class[numParams];
            values = new Object[numParams];
        }
        boolean[] isFile = new boolean[numParams];
        boolean[] mustWrite = new boolean[numParams];
        String[] renamings = new String[numParams];
        int pos = 5;
        Object target = null;
        for (int i2 = 0; i2 < numParams; ++i2) {
            int argType = Integer.parseInt(args[pos]);
            switch (argType) {
                case 0: {
                    types[i2] = String.class;
                    values[i2] = args[pos + 1];
                    break;
                }
                case 10: {
                    String renaming = renamings[i2] = args[pos + 1];
                    mustWrite[i2] = args[pos + 2].equals("W");
                    Object o = null;
                    try {
                        o = Serializer.deserialize(renaming);
                    }
                    catch (Exception e) {
                        ErrorManager.error("Error deserializing object parameter " + i2 + " with renaming " + renaming + ", method " + methodName + ", class " + className);
                    }
                    if (hasTarget && i2 == numParams - 1) {
                        if (o == null) {
                            ErrorManager.error("Target object with renaming " + renaming + ", method " + methodName + ", class " + className + " is null!");
                        }
                        target = o;
                    } else {
                        if (o == null) {
                            ErrorManager.error("Object parameter " + i2 + " with renaming " + renaming + ", method " + methodName + ", class " + className + " is null!");
                        }
                        types[i2] = o.getClass();
                        values[i2] = o;
                    }
                    ++pos;
                    break;
                }
                case 1: {
                    types[i2] = Boolean.TYPE;
                    values[i2] = new Boolean(args[pos + 1]);
                    break;
                }
                case 2: {
                    types[i2] = Character.TYPE;
                    values[i2] = new Character(args[pos + 1].charAt(0));
                    break;
                }
                case 3: {
                    types[i2] = String.class;
                    int numSubStrings = Integer.parseInt(args[pos + 1]);
                    String aux = "";
                    for (int j = 2; j <= numSubStrings + 1; ++j) {
                        aux = aux + args[pos + j];
                        if (j >= numSubStrings + 1) continue;
                        aux = aux + " ";
                    }
                    values[i2] = aux;
                    pos += numSubStrings;
                    break;
                }
                case 4: {
                    types[i2] = Byte.TYPE;
                    values[i2] = new Byte(args[pos + 1]);
                    break;
                }
                case 5: {
                    types[i2] = Short.TYPE;
                    values[i2] = new Short(args[pos + 1]);
                    break;
                }
                case 6: {
                    types[i2] = Integer.TYPE;
                    values[i2] = new Integer(args[pos + 1]);
                    break;
                }
                case 7: {
                    types[i2] = Long.TYPE;
                    values[i2] = new Long(args[pos + 1]);
                    break;
                }
                case 8: {
                    types[i2] = Float.TYPE;
                    values[i2] = new Float(args[pos + 1]);
                    break;
                }
                case 9: {
                    types[i2] = Double.TYPE;
                    values[i2] = new Double(args[pos + 1]);
                }
            }
            isFile[i2] = argType == 0;
            pos += 2;
        }
        if (debug) {
            System.out.println("WORKER - Parameters of execution:");
            System.out.println("  * Method class: " + className);
            System.out.println("  * Method name: " + methodName);
            System.out.print("  * Parameter types:");
            for (Class c : types) {
                System.out.print(" " + c.getName());
            }
            System.out.println("");
            System.out.print("  * Parameter values:");
            for (Object v : values) {
                System.out.print(" " + v);
            }
            System.out.println("");
        }
        Method method = null;
        try {
            Class<?> methodClass = Class.forName(className);
            method = methodClass.getMethod(methodName, types);
        }
        catch (ClassNotFoundException e) {
            ErrorManager.error("Application class not found");
        }
        catch (SecurityException e) {
            ErrorManager.error("Security exception");
        }
        catch (NoSuchMethodException e) {
            ErrorManager.error("Requested method not found");
        }
        Object retValue = null;
        try {
            retValue = method.invoke(target, values);
        }
        catch (Exception e) {
            ErrorManager.error("Error invoking requested method");
        }
        boolean allOutFilesCreated = true;
        for (i = 0; i < numParams; ++i) {
            String filepath;
            File f;
            if (!isFile[i] || (f = new File(filepath = (String)values[i])).exists()) continue;
            String errMsg = "ERROR: File with path '" + values[i] + "' has not been generated by task '" + methodName + "'" + "' (in class '" + className + "' at method '" + methodName + "', parameter number: " + (i + 1) + " )";
            System.out.println(errMsg);
            allOutFilesCreated = false;
        }
        for (i = 0; i < numParams; ++i) {
            if (!mustWrite[i]) continue;
            try {
                if (hasTarget && i == numParams - 1) {
                    Serializer.serialize(target, renamings[i]);
                    continue;
                }
                Serializer.serialize(values[i], renamings[i]);
                continue;
            }
            catch (Exception e) {
                ErrorManager.error("Error serializing object parameter " + i + " with renaming " + renamings[i] + ", method " + methodName + ", class " + className);
            }
        }
        if (retValue != null) {
            String renaming = args[pos + 1];
            try {
                Serializer.serialize(retValue, renaming);
            }
            catch (Exception e) {
                ErrorManager.error("Error serializing object return value with renaming " + renaming + ", method " + methodName + ", class " + className);
            }
        }
        if (!allOutFilesCreated) {
            ErrorManager.error("ERROR: One or more OUT files have not been created by task '" + methodName + "'");
        }
    }
}

