/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types;

import integratedtoolkit.ITConstants;
import integratedtoolkit.types.Implementation;
import integratedtoolkit.types.parameter.Parameter;
import integratedtoolkit.types.resources.MethodResourceDescription;

public class MethodImplementation
extends Implementation<MethodResourceDescription> {
    private static ITConstants.Lang lang = ITConstants.Lang.JAVA;
    private String declaringClass;

    public MethodImplementation(String methodClass, int coreId, int implementationId, MethodResourceDescription annot) {
        super(coreId, implementationId, annot);
        this.declaringClass = methodClass;
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public void setDeclaringClass(String declaringClass) {
        this.declaringClass = declaringClass;
    }

    public static String getSignature(String declaringClass, String methodName, boolean hasTarget, boolean hasReturn, Parameter[] parameters) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(methodName).append("(");
        if (lang != ITConstants.Lang.PYTHON) {
            int numPars = parameters.length;
            if (hasTarget) {
                --numPars;
            }
            if (hasReturn) {
                --numPars;
            }
            if (numPars > 0) {
                buffer.append((Object)parameters[0].getType());
                for (int i = 1; i < numPars; ++i) {
                    buffer.append(",").append((Object)parameters[i].getType());
                }
            }
        }
        buffer.append(")").append(declaringClass);
        return buffer.toString();
    }

    @Override
    public Implementation.Type getType() {
        return Implementation.Type.METHOD;
    }

    @Override
    public String toString() {
        return super.toString() + " Method declared in class " + this.declaringClass + ": " + ((MethodResourceDescription)this.requirements).toString();
    }

    static {
        String l = System.getProperty("it.lang");
        if (l != null) {
            if ("c".equalsIgnoreCase(l)) {
                lang = ITConstants.Lang.C;
            } else if ("python".equalsIgnoreCase(l)) {
                lang = ITConstants.Lang.PYTHON;
            }
        }
    }
}

