/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources.cpi.local;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.gridlab.gat.CommandNotFoundException;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.engine.util.CommandRunner;
import org.gridlab.gat.engine.util.ProcessBundle;
import org.gridlab.gat.engine.util.StreamForwarder;
import org.gridlab.gat.io.FileInputStream;
import org.gridlab.gat.io.FileOutputStream;
import org.gridlab.gat.monitoring.Metric;
import org.gridlab.gat.monitoring.MetricListener;
import org.gridlab.gat.resources.AbstractJobDescription;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.SoftwareDescription;
import org.gridlab.gat.resources.WrapperJobDescription;
import org.gridlab.gat.resources.cpi.ResourceBrokerCpi;
import org.gridlab.gat.resources.cpi.Sandbox;
import org.gridlab.gat.resources.cpi.WrapperJobCpi;
import org.gridlab.gat.resources.cpi.local.LocalJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalResourceBrokerAdaptor
extends ResourceBrokerCpi {
    protected static Logger logger = LoggerFactory.getLogger(LocalResourceBrokerAdaptor.class);

    public static String getDescription() {
        return "The Local ResourceBroker Adaptor implements the ResourceBroker using the Java ProcessBuilder facility.";
    }

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map capabilities = ResourceBrokerCpi.getSupportedCapabilities();
        capabilities.put("beginMultiJob", true);
        capabilities.put("endMultiJob", true);
        capabilities.put("submitJob", true);
        return capabilities;
    }

    public static String[] getSupportedSchemes() {
        return new String[]{"local", "fork", ""};
    }

    public LocalResourceBrokerAdaptor(GATContext gatContext, URI brokerURI) throws GATObjectCreationException {
        super(gatContext, brokerURI);
        if (!brokerURI.refersToLocalHost()) {
            throw new GATObjectCreationException("The LocalResourceBrokerAdaptor doesn't refer to localhost, but to a remote host: " + brokerURI.toString());
        }
        String path = brokerURI.getUnresolvedPath();
        if (path != null && !path.equals("")) {
            throw new GATObjectCreationException("The LocalResourceBrokerAdaptor does not understand the specified path: " + path);
        }
    }

    public Job submitJob(AbstractJobDescription abstractDescription, MetricListener listener, String metricDefinitionName) throws GATInvocationException {
        StreamForwarder forwarder;
        String exe;
        if (!(abstractDescription instanceof JobDescription)) {
            throw new GATInvocationException("can only handle JobDescriptions: " + abstractDescription.getClass());
        }
        JobDescription description = (JobDescription)abstractDescription;
        SoftwareDescription sd = description.getSoftwareDescription();
        if (sd == null) {
            throw new GATInvocationException("The job description does not contain a software description");
        }
        if (description.getProcessCount() < 1) {
            throw new GATInvocationException("Adaptor cannot handle: process count < 1: " + description.getProcessCount());
        }
        if (description.getResourceCount() != 1) {
            throw new GATInvocationException("Adaptor cannot handle: resource count > 1: " + description.getResourceCount());
        }
        String home = System.getProperty("user.home");
        if (home == null) {
            throw new GATInvocationException("local broker could not get user home dir");
        }
        Sandbox sandbox = new Sandbox(this.gatContext, description, "localhost", home, true, true, false, false);
        LocalJob localJob = new LocalJob(this.gatContext, description, sandbox);
        LocalJob job = null;
        if (description instanceof WrapperJobDescription) {
            WrapperJobCpi tmp = new WrapperJobCpi(this.gatContext, (Job)localJob, listener, metricDefinitionName);
            listener = tmp;
            job = tmp;
        } else {
            job = localJob;
        }
        if (listener != null && metricDefinitionName != null) {
            Metric metric = localJob.getMetricDefinitionByName(metricDefinitionName).createMetric(null);
            localJob.addMetricListener(listener, metric);
        }
        localJob.setState(Job.JobState.PRE_STAGING);
        localJob.waitForTrigger(Job.JobState.PRE_STAGING);
        sandbox.prestage();
        if (sandbox.getResolvedExecutable() != null) {
            exe = sandbox.getResolvedExecutable().getPath();
            try {
                new CommandRunner(new String[]{"chmod", "+x", exe});
            }
            catch (Throwable t) {}
        } else {
            exe = this.getExecutable(description);
        }
        String[] args = this.getArgumentsArray(description);
        File f = new File(sandbox.getSandboxPath());
        Map env = sd.getEnvironment();
        ProcessBundle bundle = new ProcessBundle(description.getProcessCount(), exe, args, f, env);
        localJob.setSubmissionTime();
        localJob.setState(Job.JobState.SCHEDULED);
        try {
            localJob.setState(Job.JobState.RUNNING);
            localJob.waitForTrigger(Job.JobState.RUNNING);
            localJob.setStartTime();
            bundle.startBundle();
            localJob.setProcess(bundle);
        }
        catch (IOException e) {
            throw new CommandNotFoundException("LocalResourceBrokerAdaptor", (Throwable)e);
        }
        if (!sd.streamingStderrEnabled()) {
            try {
                if (sd.getStderr() != null) {
                    FileOutputStream err = GAT.createFileOutputStream((GATContext)this.gatContext, (org.gridlab.gat.io.File)sd.getStderr());
                    forwarder = new StreamForwarder(bundle.getStderr(), (OutputStream)err, sd.getExecutable() + " [stderr]");
                    localJob.setErrorStream(forwarder);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Created stderr forwarder to file " + sd.getStderr());
                    }
                } else {
                    new StreamForwarder(bundle.getStderr(), null, sd.getExecutable() + " [stderr]");
                }
            }
            catch (GATObjectCreationException e) {
                throw new GATInvocationException("Unable to create file output stream for stderr!", (Throwable)e);
            }
        }
        if (!sd.streamingStdoutEnabled()) {
            try {
                if (sd.getStdout() != null) {
                    FileOutputStream out = GAT.createFileOutputStream((GATContext)this.gatContext, (org.gridlab.gat.io.File)sd.getStdout());
                    forwarder = new StreamForwarder(bundle.getStdout(), (OutputStream)out, sd.getExecutable() + " [stdout]");
                    localJob.setOutputStream(forwarder);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Created stdout forwarder to file " + sd.getStdout());
                    }
                } else {
                    new StreamForwarder(bundle.getStdout(), null, sd.getExecutable() + " [stdout]");
                }
            }
            catch (GATObjectCreationException e) {
                throw new GATInvocationException("Unable to create file output stream for stdout!", (Throwable)e);
            }
        }
        if (!sd.streamingStdinEnabled() && sd.getStdin() != null) {
            try {
                FileInputStream in = GAT.createFileInputStream((GATContext)this.gatContext, (org.gridlab.gat.io.File)sd.getStdin());
                bundle.setStdin(sd.getExecutable(), (InputStream)in);
            }
            catch (GATObjectCreationException e) {
                throw new GATInvocationException("Unable to create file input stream for stdin!", (Throwable)e);
            }
        }
        localJob.monitorState();
        return job;
    }
}

