/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.util;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.log4j.Logger;

public class Serializer {
    private static final Logger LOGGER = Logger.getLogger("Communication");

    private Serializer() {
    }

    public static void serialize(Object o, String file) throws IOException {
        try {
            Serializer.serializeBinary(o, file);
        }
        catch (NotSerializableException nse) {
            LOGGER.debug("Can not serialize " + o + " by binary serializer", nse);
            try {
                Serializer.serializeXML(o, file);
            }
            catch (IOException ioe) {
                LOGGER.debug("Can not serialize " + o + " by XML serializer", ioe);
                throw ioe;
            }
        }
    }

    public static byte[] serialize(Object o) throws IOException {
        try {
            return Serializer.serializeBinary(o);
        }
        catch (NotSerializableException nse) {
            LOGGER.debug("Can not serialize " + o + " by binary serializer", nse);
            try {
                return Serializer.serializeXML(o);
            }
            catch (IOException ioe) {
                LOGGER.debug("Can not serialize " + o + " by XML serializer", ioe);
                throw ioe;
            }
        }
    }

    public static Object deserialize(String file) throws IOException, ClassNotFoundException {
        try {
            return Serializer.deserializeBinary(file);
        }
        catch (Exception e) {
            LOGGER.debug("Can not deserialize " + file + " by binary serializer", e);
            try {
                return Serializer.deserializeXML(file);
            }
            catch (IOException ioe) {
                LOGGER.debug("Cannot deserialize " + file + " by XML serializer", ioe);
                throw ioe;
            }
        }
    }

    public static Object deserialize(byte[] b) throws IOException, ClassNotFoundException {
        try {
            return Serializer.deserializeBinary(b);
        }
        catch (IOException e) {
            LOGGER.debug("Can not deserialize by binary serializer", e);
            try {
                return Serializer.deserializeXML(b);
            }
            catch (IOException ioe) {
                LOGGER.debug("Can not deserialize " + b + " by XML serializer", ioe);
                throw ioe;
            }
        }
    }

    private static void serializeBinary(Object o, String file) throws IOException {
        FileOutputStream fout = new FileOutputStream(file);
        ObjectOutputStream oos = new ObjectOutputStream(fout);
        oos.writeObject(o);
        oos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] serializeBinary(Object o) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(bos);
            out.writeObject(o);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {}
            try {
                bos.close();
            }
            catch (IOException ex) {}
        }
    }

    private static Object deserializeBinary(String file) throws IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(file);
        ObjectInputStream ois = new ObjectInputStream(fis);
        Object o = ois.readObject();
        ois.close();
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object deserializeBinary(byte[] data) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(bis);
            Object object = in.readObject();
            return object;
        }
        finally {
            try {
                bis.close();
            }
            catch (IOException ex) {}
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    private static void serializeXML(Object o, String file) throws IOException {
        FileOutputStream fout = new FileOutputStream(file);
        XMLEncoder e = new XMLEncoder(new BufferedOutputStream(fout));
        e.writeObject(o);
        e.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] serializeXML(Object o) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLEncoder e = null;
        try {
            e = new XMLEncoder(new BufferedOutputStream(bos));
            e.writeObject(o);
        }
        finally {
            if (e != null) {
                e.close();
            }
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
        return bos.toByteArray();
    }

    private static Object deserializeXML(String file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        XMLDecoder d = new XMLDecoder(new BufferedInputStream(fis));
        Object o = d.readObject();
        d.close();
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object deserializeXML(byte[] data) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        XMLDecoder d = null;
        try {
            d = new XMLDecoder(new BufferedInputStream(bis));
            Object object = d.readObject();
            return object;
        }
        finally {
            if (d != null) {
                d.close();
            }
            try {
                bis.close();
            }
            catch (IOException ex) {}
        }
    }
}

