/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.nio.commands;

import es.bsc.comm.Connection;
import integratedtoolkit.nio.NIOAgent;
import integratedtoolkit.nio.commands.Command;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class CommandTaskDone
extends Command
implements Externalizable {
    private int jobID;
    private boolean successful;

    public CommandTaskDone() {
    }

    public CommandTaskDone(NIOAgent ng, int jobID, boolean successful) {
        super(ng);
        this.jobID = jobID;
        this.successful = successful;
    }

    @Override
    public Command.CommandType getType() {
        return Command.CommandType.TASK_DONE;
    }

    @Override
    public void handle(Connection c) {
        NIOAgent nm = this.agent;
        nm.receivedTaskDone(c, this.jobID, this.successful);
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public int getJobID() {
        return this.jobID;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.jobID = in.readInt();
        this.successful = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.jobID);
        out.writeBoolean(this.successful);
    }

    public String toString() {
        return "Job" + this.jobID + " finishes " + (this.successful ? "properly" : "with some errors");
    }
}

