/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.data.location;

import integratedtoolkit.types.data.location.DataLocation;
import integratedtoolkit.types.data.location.PrivateLocation;
import integratedtoolkit.types.data.location.URI;
import integratedtoolkit.types.resources.Resource;
import integratedtoolkit.util.SharedDiskManager;
import java.io.File;
import java.util.LinkedList;

public class SharedLocation
extends DataLocation {
    private final String diskName;
    private final String path;

    SharedLocation(String sharedDisk, String path) {
        this.diskName = sharedDisk;
        this.path = path;
    }

    @Override
    public URI getURIInHost(Resource host) {
        String diskPath = SharedDiskManager.getMounpoint(host, this.diskName);
        if (diskPath == null) {
            return null;
        }
        return new URI(host, diskPath + this.path);
    }

    @Override
    public DataLocation.Type getType() {
        return DataLocation.Type.SHARED;
    }

    @Override
    public LinkedList<URI> getURIs() {
        LinkedList<URI> uris = new LinkedList<URI>();
        for (Resource host : SharedDiskManager.getAllMachinesfromDisk(this.diskName)) {
            String diskPath = SharedDiskManager.getMounpoint(host, this.diskName);
            uris.add(new URI(host, diskPath + this.path));
        }
        return uris;
    }

    @Override
    public LinkedList<Resource> getHosts() {
        return SharedDiskManager.getAllMachinesfromDisk(this.diskName);
    }

    @Override
    public boolean isTarget(DataLocation target) {
        String targetPath;
        String targetDisk;
        if (target.getType() == DataLocation.Type.PRIVATE) {
            PrivateLocation privateLoc = (PrivateLocation)target;
            targetDisk = null;
            targetPath = privateLoc.uri.getPath();
        } else {
            SharedLocation sharedloc = (SharedLocation)target;
            targetDisk = sharedloc.diskName;
            targetPath = sharedloc.path;
        }
        return targetDisk != null && targetDisk.contentEquals(this.diskName) && targetPath.contentEquals(targetPath);
    }

    public String toString() {
        return "shared:" + this.diskName + File.separator + this.path;
    }

    @Override
    public String getSharedDisk() {
        return this.diskName;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getLocationKey() {
        return this.path + ":shared:" + this.diskName;
    }

    @Override
    public int compareTo(DataLocation o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (o.getClass() != SharedLocation.class) {
            return this.getClass().getName().compareTo("integratedtoolkit.types.data.location.SharedLocation");
        }
        SharedLocation sl = (SharedLocation)o;
        int compare = this.diskName.compareTo(sl.diskName);
        if (compare == 0) {
            compare = this.path.compareTo(sl.path);
        }
        return compare;
    }
}

