/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.data.operation;

import integratedtoolkit.types.data.LogicalData;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public abstract class DataOperation {
    private static int opCount = 0;
    private final int operationId;
    private final List<EventListener> listeners;
    private OpEndState endState = null;
    private Exception endException = null;
    protected static final Logger logger = Logger.getLogger("integratedtoolkit.Communication");
    protected static final boolean debug = logger.isDebugEnabled();
    private String name;

    public DataOperation(LogicalData ld, EventListener listener) {
        try {
            this.name = ld.getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.listeners = new LinkedList<EventListener>();
        this.listeners.add(listener);
        this.operationId = opCount++;
    }

    public DataOperation(LogicalData ld, List<EventListener> eventListeners) {
        try {
            this.name = ld.getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.listeners = eventListeners;
        this.operationId = opCount++;
    }

    public int getId() {
        return this.operationId;
    }

    public String getName() {
        return this.name;
    }

    public List<EventListener> getEventListeners() {
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(EventListener eventListener) {
        List<EventListener> list = this.listeners;
        synchronized (list) {
            if (this.endState == null) {
                this.listeners.add(eventListener);
            } else {
                switch (this.endState) {
                    case OP_OK: {
                        eventListener.notifyEnd(this);
                        break;
                    }
                    case OP_IN_PROGRESS: {
                        break;
                    }
                    case OP_WAITING_SOURCES: {
                        break;
                    }
                    default: {
                        eventListener.notifyFailure(this, this.endException);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListeners(List<EventListener> eventListeners) {
        List<EventListener> list = this.listeners;
        synchronized (list) {
            if (this.endState == null) {
                this.listeners.addAll(eventListeners);
            } else {
                switch (this.endState) {
                    case OP_OK: {
                        for (EventListener eventListener : eventListeners) {
                            eventListener.notifyEnd(this);
                        }
                        break;
                    }
                    case OP_IN_PROGRESS: {
                        break;
                    }
                    case OP_WAITING_SOURCES: {
                        break;
                    }
                    default: {
                        for (EventListener eventListener : eventListeners) {
                            eventListener.notifyFailure(this, this.endException);
                        }
                    }
                }
            }
        }
    }

    public void end(OpEndState state) {
        this.notifyEnd(state, null);
    }

    public void end(OpEndState state, Exception e) {
        this.notifyEnd(state, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEnd(OpEndState state, Exception e) {
        List<EventListener> list = this.listeners;
        synchronized (list) {
            this.endState = state;
            this.endException = e;
            switch (state) {
                case OP_OK: {
                    for (EventListener listener : this.listeners) {
                        listener.notifyEnd(this);
                    }
                    break;
                }
                case OP_IN_PROGRESS: {
                    break;
                }
                case OP_WAITING_SOURCES: {
                    break;
                }
                default: {
                    for (EventListener listener : this.listeners) {
                        listener.notifyFailure(this, e);
                    }
                }
            }
        }
    }

    public static abstract class EventListener {
        private static final AtomicInteger nextId = new AtomicInteger(0);
        private int id = nextId.getAndIncrement();

        public Integer getId() {
            return this.id;
        }

        public abstract void notifyEnd(DataOperation var1);

        public abstract void notifyFailure(DataOperation var1, Exception var2);
    }

    public static enum OpEndState {
        OP_OK,
        OP_IN_PROGRESS,
        OP_FAILED,
        OP_PREPARATION_FAILED,
        OP_WAITING_SOURCES;

    }
}

