/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import integratedtoolkit.types.resources.Resource;
import integratedtoolkit.util.Machine;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class SharedDiskManager {
    private static HashMap<String, LinkedList<Resource>> shared2Machines = new HashMap();
    private static HashMap<Resource, Machine> machine2Shareds = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMachine(Resource host) {
        Machine m = new Machine(host);
        HashMap<Resource, Machine> hashMap = machine2Shareds;
        synchronized (hashMap) {
            machine2Shareds.put(host, m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSharedToMachine(String diskName, String mountpoint, Resource host) {
        HashMap<Resource, Machine> hashMap = machine2Shareds;
        synchronized (hashMap) {
            machine2Shareds.get(host).addSharedDisk(diskName, mountpoint);
            LinkedList<Resource> machines = shared2Machines.get(diskName);
            if (machines == null) {
                machines = new LinkedList();
                shared2Machines.put(diskName, machines);
            }
            machines.add(host);
        }
    }

    public static String getSharedName(Resource host, String path) {
        Machine m = machine2Shareds.get(host);
        if (m == null) {
            return null;
        }
        return m.getSharedName(path);
    }

    public static String getSharedStatus() {
        StringBuilder sb = new StringBuilder("Shared disk in machines:\n");
        for (Map.Entry<String, LinkedList<Resource>> entry : shared2Machines.entrySet()) {
            sb.append(entry.getKey()).append("--> {");
            for (int i = 0; i < entry.getValue().size(); ++i) {
                sb.append(entry.getValue().get(i).getName()).append(", ");
            }
            sb.append("}\n");
        }
        sb.append("Machines :\n");
        for (Map.Entry<Object, Object> entry : machine2Shareds.entrySet()) {
            sb.append(((Resource)entry.getKey()).getName()).append("--> {");
            for (Map.Entry<String, String> me : ((Machine)entry.getValue()).name2Mountpoint.entrySet()) {
                sb.append(me.getKey()).append("@").append(me.getValue()).append(", ");
            }
            sb.append("}\n");
        }
        return sb.toString();
    }

    public static LinkedList<String> getAllSharedNames(Resource host) {
        Machine m = machine2Shareds.get(host);
        if (m == null) {
            return new LinkedList<String>();
        }
        return m.getAllSharedNames();
    }

    public static String getMounpoint(Resource host, String sharedDisk) {
        Machine m = machine2Shareds.get(host);
        if (m == null) {
            return null;
        }
        return m.getPath(sharedDisk);
    }

    public static LinkedList<Resource> getAllMachinesfromDisk(String diskName) {
        return shared2Machines.get(diskName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, String> terminate(Resource host) {
        Machine m;
        HashMap<Resource, Machine> hashMap = machine2Shareds;
        synchronized (hashMap) {
            m = machine2Shareds.remove(host);
            if (m != null) {
                for (String sharedName : m.allShared) {
                    shared2Machines.get(sharedName).remove(host);
                }
            }
        }
        if (m != null) {
            return m.name2Mountpoint;
        }
        return new HashMap<String, String>();
    }
}

