/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.connectors.vmm;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import integratedtoolkit.connectors.vmm.VMDescription;
import integratedtoolkit.connectors.vmm.VMRequest;
import integratedtoolkit.connectors.vmm.VMs;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class VMMClient {
    private Client client = new Client();
    private WebResource resource;
    private static final Logger logger = Logger.getLogger((String)"integratedtoolkit.Components.TaskDispatcher.TaskScheduler");

    public VMMClient(String url) {
        this.resource = this.client.resource(url);
    }

    public String createVM(String name, String image, int cpus, int ramMb, int diskGb, String applicationId) throws Exception {
        VMRequest vm = new VMRequest(name, image, cpus, ramMb, diskGb, applicationId);
        VMs vms = new VMs();
        vms.getVms().add(vm);
        JSONObject obj = new JSONObject((Object)vms);
        logger.debug((Object)"Submitting vm creation ...");
        ClientResponse cr = (ClientResponse)this.resource.path("vms").type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)obj.toString());
        if (cr.getStatus() == Response.Status.OK.getStatusCode()) {
            String s = (String)cr.getEntity(String.class);
            JSONObject res = new JSONObject(s);
            String id = (String)res.getJSONArray("ids").getJSONObject(0).get("id");
            logger.debug((Object)("VM submitted with id " + id));
            return id;
        }
        logger.error((Object)("Incorrect return code: " + cr.getStatus() + "." + cr.getClientResponseStatus().getReasonPhrase()));
        throw new Exception("Incorrect return code: " + cr.getStatus() + "." + cr.getClientResponseStatus().getReasonPhrase());
    }

    public VMDescription getVMDescription(String id) throws Exception {
        logger.debug((Object)"Getting vm description ...");
        ClientResponse cr = (ClientResponse)this.resource.path("vms").path(id).get(ClientResponse.class);
        if (cr.getStatus() == Response.Status.OK.getStatusCode()) {
            String s = (String)cr.getEntity(String.class);
            logger.debug((Object)("Obtained description " + s));
            return new VMDescription(new JSONObject(s));
        }
        logger.error((Object)("Incorrect return code: " + cr.getStatus() + "." + cr.getClientResponseStatus().getReasonPhrase()));
        throw new Exception("Incorrect return code: " + cr.getStatus() + "." + cr.getClientResponseStatus().getReasonPhrase());
    }

    public void deleteVM(String vmId) throws Exception {
        logger.debug((Object)"Getting vm description ...");
        ClientResponse cr = (ClientResponse)this.resource.path("vms").path(vmId).delete(ClientResponse.class);
        if (cr.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
            logger.error((Object)("Incorrect return code: " + cr.getStatus() + "." + cr.getClientResponseStatus().getReasonPhrase()));
            throw new Exception("Incorrect return code: " + cr.getStatus() + "." + cr.getClientResponseStatus().getReasonPhrase());
        }
    }
}

