/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.joyent.cloudapi.v6_5.features;

import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.joyent.cloudapi.v6_5.domain.Machine;
import org.jclouds.joyent.cloudapi.v6_5.options.CreateMachineOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;

@Headers(keys={"X-Api-Version"}, values={"{jclouds.api-version}"})
@RequestFilters(value={BasicAuthentication.class})
@Consumes(value={"application/json"})
@Path(value="/my/machines")
public interface MachineApi {
    @Named(value="ListMachines")
    @GET
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<Machine> list();

    @Named(value="GetMachine")
    @GET
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Machine get(@PathParam(value="id") String var1);

    @Named(value="CreateMachine")
    @POST
    public Machine createWithDataset(@QueryParam(value="dataset") String var1, CreateMachineOptions var2);

    @Named(value="CreateMachine")
    @POST
    public Machine createWithDataset(@QueryParam(value="dataset") String var1);

    @Named(value="StopMachine")
    @POST
    @Produces(value={"application/x-www-form-urlencoded"})
    @Path(value="/{id}")
    @Payload(value="action=stop")
    public void stop(@PathParam(value="id") String var1);

    @Named(value="StartMachine")
    @POST
    @Produces(value={"application/x-www-form-urlencoded"})
    @Path(value="/{id}")
    @Payload(value="action=start")
    public void start(@PathParam(value="id") String var1);

    @Named(value="RestartMachine")
    @POST
    @Produces(value={"application/x-www-form-urlencoded"})
    @Path(value="/{id}")
    @Payload(value="action=reboot")
    public void reboot(@PathParam(value="id") String var1);

    @Named(value="ResizeMachine")
    @POST
    @Produces(value={"application/x-www-form-urlencoded"})
    @Path(value="/{id}")
    @Payload(value="action=resize&package={package}")
    public void resize(@PathParam(value="id") String var1, @PayloadParam(value="package") String var2);

    @Named(value="DeleteMachine")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void delete(@PathParam(value="id") String var1);
}

