/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.joyent.cloudapi.v6_5.options;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Map;
import org.jclouds.http.options.BaseHttpRequestOptions;
import org.jclouds.util.Maps2;

public class CreateMachineOptions
extends BaseHttpRequestOptions {
    private String name;
    private String pkg;
    private Map<String, String> metadata = ImmutableMap.of();

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CreateMachineOptions) {
            CreateMachineOptions other = (CreateMachineOptions)CreateMachineOptions.class.cast(object);
            return Objects.equal(this.name, other.name) && Objects.equal(this.pkg, other.pkg) && Objects.equal(this.metadata, other.metadata);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.name, this.pkg, this.metadata);
    }

    @Override
    public String toString() {
        Objects.ToStringHelper toString = Objects.toStringHelper("").omitNullValues();
        toString.add("name", this.name).add("package", this.name);
        if (this.metadata.size() > 0) {
            toString.add("metadata", this.metadata);
        }
        return toString.toString();
    }

    @Override
    public Multimap<String, String> buildQueryParameters() {
        Multimap<String, String> params = super.buildQueryParameters();
        if (this.name != null) {
            params.put("name", this.name);
        }
        if (this.pkg != null) {
            params.put("package", this.pkg);
        }
        params.putAll(Multimaps.forMap(Maps2.transformKeys(this.metadata, new Function<String, String>(){

            @Override
            public String apply(String input) {
                return "metadata." + input;
            }
        })));
        return params;
    }

    public CreateMachineOptions name(String name) {
        this.name = Preconditions.checkNotNull(name, "name");
        return this;
    }

    public CreateMachineOptions packageName(String packageName) {
        this.pkg = Preconditions.checkNotNull(packageName, "packageName");
        return this;
    }

    public CreateMachineOptions metadata(Map<String, String> metadata) {
        Preconditions.checkNotNull(metadata, "metadata");
        this.metadata = ImmutableMap.copyOf(metadata);
        return this;
    }

    public static class Builder {
        public static CreateMachineOptions name(String name) {
            CreateMachineOptions options = new CreateMachineOptions();
            return options.name(name);
        }

        public static CreateMachineOptions packageName(String packageName) {
            CreateMachineOptions options = new CreateMachineOptions();
            return options.packageName(packageName);
        }

        public static CreateMachineOptions metadata(Map<String, String> metadata) {
            CreateMachineOptions options = new CreateMachineOptions();
            return options.metadata(metadata);
        }
    }
}

