/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import integratedtoolkit.components.ResourceUser;
import integratedtoolkit.types.Implementation;
import integratedtoolkit.types.MethodImplementation;
import integratedtoolkit.types.ResourceCreationRequest;
import integratedtoolkit.types.resources.CloudMethodWorker;
import integratedtoolkit.types.resources.MethodResourceDescription;
import integratedtoolkit.types.resources.description.CloudMethodResourceDescription;
import integratedtoolkit.util.CloudManager;
import integratedtoolkit.util.CoreManager;
import integratedtoolkit.util.ErrorManager;
import integratedtoolkit.util.ProjectManager;
import integratedtoolkit.util.ResourceManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.log4j.Logger;

public class ResourceOptimizer
extends Thread {
    private final Object alarmClock = new Object();
    private boolean running;
    private Integer maxNumberOfVMs;
    private Integer minNumberOfVMs;
    private ResourceUser resUser;
    private static boolean cleanUp;
    private static boolean redo;
    private static final Logger resourcesLogger;
    private static final Logger logger;
    private static final boolean debug;
    private static final int SLEEP_TIME = 20000;
    private static final int EVERYTHING_BLOCKED_MAX_RETRIES = 3;
    private static final String PERSISTENT_BLOCK_ERR = "Persistent block detected.\nNo task could be scheduled or sent to any of the available resources.\nShutting down COMPSs now...";
    private int everythingBlockedRetryCount = -1;

    ResourceOptimizer(ResourceUser resUser) {
        if (debug) {
            logger.debug((Object)"Initializing Resource Optimizer");
        }
        this.resUser = resUser;
        redo = false;
        logger.info((Object)"Initialization finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(ResourceUser.WorkloadStatus status) {
        Object object = this.alarmClock;
        synchronized (object) {
            this.running = false;
            this.alarmClock.notify();
            cleanUp = true;
        }
        resourcesLogger.info((Object)status.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        if (ResourceManager.useCloud()) {
            this.initialCreations();
        }
        while (this.running) {
            try {
                do {
                    boolean potentialBlock;
                    redo = false;
                    ResourceUser.WorkloadStatus workload = this.resUser.getWorkload();
                    int runningTasks = workload.getRunningTaskCount();
                    int ordinaryTasks = workload.getOrdinaryCount();
                    int blockedTasks = workload.getNoResourceCount();
                    boolean bl = potentialBlock = runningTasks == 0 && ordinaryTasks == 0 && blockedTasks > 0;
                    if (ResourceManager.useCloud()) {
                        this.applyPolicies(workload);
                        int VMsBeingCreated = CloudManager.getPendingRequests().size();
                        potentialBlock = potentialBlock && VMsBeingCreated == 0;
                    }
                    this.handlePotentialBlock(potentialBlock);
                } while (redo);
                try {
                    Object runningTasks = this.alarmClock;
                    synchronized (runningTasks) {
                        if (this.running) {
                            this.alarmClock.wait(20000L);
                        }
                    }
                }
                catch (InterruptedException ex) {
                    logger.error((Object)"Exception", (Throwable)ex);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Exception", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimizeNow() {
        Object object = this.alarmClock;
        synchronized (object) {
            this.alarmClock.notify();
            redo = true;
        }
    }

    public void cleanUp() {
        cleanUp = true;
    }

    public void handlePotentialBlock(boolean potentialBlock) {
        if (potentialBlock) {
            ++this.everythingBlockedRetryCount;
            if (this.everythingBlockedRetryCount > 0) {
                if (this.everythingBlockedRetryCount < 3) {
                    int retriesLeft = 3 - this.everythingBlockedRetryCount;
                    ErrorManager.warn((String)("No task could be scheduled to any of the available resources.\nThis could end up blocking COMPSs. Will check it again in 20 seconds.\nPossible causes: \n    -Network problems: non-reachable nodes, sshd service not started, etc.\n    -There isn't any computing resource that fits the defined tasks constraints.\nIf this happens " + retriesLeft + " more time" + (retriesLeft > 1 ? "s" : "") + ", the runtime will shutdown."));
                } else {
                    ErrorManager.error((String)PERSISTENT_BLOCK_ERR);
                }
            }
        } else {
            this.everythingBlockedRetryCount = 0;
        }
    }

    private void initialCreations() {
        int alreadyCreated = ResourceOptimizer.addBasicNodes();
        ResourceOptimizer.addExtraNodes(alreadyCreated);
    }

    public static int addBasicNodes() {
        int coreCount = CoreManager.getCoreCount();
        LinkedList<ConstraintsCore>[] unfulfilledConstraints = ResourceOptimizer.getUnfulfilledConstraints();
        int unfulfilledConstraintsCores = 0;
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            if (unfulfilledConstraints[coreId].size() <= 0) continue;
            unfulfilledConstraintsCores += unfulfilledConstraints[coreId].size();
            break;
        }
        if (unfulfilledConstraintsCores == 0) {
            return 0;
        }
        HashMap<String, LinkedList<ConstraintsCore>> arch2Constraints = ResourceOptimizer.classifyArchitectures(unfulfilledConstraints);
        ResourceOptimizer.reduceArchitecturesConstraints(arch2Constraints);
        ResourceOptimizer.reassignUnassignedConstraints(arch2Constraints);
        ResourceOptimizer.reduceArchitecturesConstraints(arch2Constraints);
        int createdCount = 0;
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            while (!unfulfilledConstraints[coreId].isEmpty()) {
                ConstraintsCore cc = unfulfilledConstraints[coreId].removeFirst();
                cc.confirmed();
                ResourceCreationRequest rcr = CloudManager.askForResources(cc.desc, false);
                if (rcr == null) continue;
                resourcesLogger.info((Object)("ORDER_CREATION = [\n\tTYPE = " + rcr.getRequested().getType() + "\n\tPROVIDER = " + rcr.getProvider() + "\n]"));
                if (debug) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("EXPECTED_SIM_TASKS = [").append("\n");
                    for (int i = 0; i < rcr.requestedSimultaneousTaskCount().length; ++i) {
                        for (int j = 0; j < rcr.requestedSimultaneousTaskCount()[i].length; ++j) {
                            sb.append("\t").append("IMPLEMENTATION_INFO = [").append("\n");
                            sb.append("\t").append("\t").append("COREID = ").append(i).append("\n");
                            sb.append("\t").append("\t").append("IMPLID = ").append(j).append("\n");
                            sb.append("\t").append("\t").append("SIM_TASKS = ").append(rcr.requestedSimultaneousTaskCount()[i][j]).append("\n");
                            sb.append("\t").append("]").append("\n");
                        }
                    }
                    sb.append("]");
                    resourcesLogger.debug((Object)sb.toString());
                }
                ++createdCount;
            }
        }
        if (debug) {
            resourcesLogger.debug((Object)("DEBUG_MSG = [\n\tIn order to be able to execute all cores, Resource Manager has asked for " + createdCount + " Cloud resources\n]"));
        }
        return createdCount;
    }

    private static LinkedList<ConstraintsCore>[] getUnfulfilledConstraints() {
        int coreCount = CoreManager.getCoreCount();
        LinkedList[] unfulfilledConstraints = new LinkedList[coreCount];
        int[] maxSimTasks = ResourceManager.getTotalSlots();
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            unfulfilledConstraints[coreId] = new LinkedList();
            if (maxSimTasks[coreId] != 0) continue;
            Implementation[] impls = CoreManager.getCoreImplementations((int)coreId);
            for (int implId = 0; implId < impls.length; ++implId) {
                Implementation impl = impls[implId];
                if (impl.getType() != Implementation.Type.METHOD) continue;
                MethodResourceDescription requirements = (MethodResourceDescription)impl.getRequirements();
                CloudMethodResourceDescription cd = new CloudMethodResourceDescription(requirements);
                ConstraintsCore cc = new ConstraintsCore(cd, coreId, unfulfilledConstraints[coreId]);
                unfulfilledConstraints[coreId].add(cc);
            }
        }
        return unfulfilledConstraints;
    }

    private static HashMap<String, LinkedList<ConstraintsCore>> classifyArchitectures(LinkedList<ConstraintsCore>[] constraints) {
        HashMap<String, LinkedList<ConstraintsCore>> archs = new HashMap<String, LinkedList<ConstraintsCore>>();
        for (int coreId = 0; coreId < CoreManager.getCoreCount(); ++coreId) {
            if (constraints[coreId] == null) continue;
            for (ConstraintsCore cc : constraints[coreId]) {
                String arch = cc.desc.getProcessorArchitecture();
                LinkedList<ConstraintsCore> archConstr = archs.get(arch);
                if (archConstr == null) {
                    archConstr = new LinkedList();
                    archs.put(arch, archConstr);
                }
                archConstr.add(cc);
            }
        }
        return archs;
    }

    private static void reduceArchitecturesConstraints(HashMap<String, LinkedList<ConstraintsCore>> arch2Ctrs) {
        for (LinkedList<ConstraintsCore> arch : arch2Ctrs.values()) {
            ConstraintsCore[] ctrs = new ConstraintsCore[arch.size()];
            int i = 0;
            for (ConstraintsCore cc : arch) {
                ctrs[i++] = cc;
            }
            Integer[] mergedTo = new Integer[arch.size()];
            for (i = 0; i < ctrs.length; ++i) {
                if (mergedTo[i] != null) continue;
                String OS = ctrs[i].desc.getOperatingSystemType();
                for (int j = i + 1; j < ctrs.length; ++j) {
                    if (mergedTo[j] != null || OS.compareTo(ctrs[j].desc.getOperatingSystemType()) != 0 && OS.compareTo("[unassigned]") != 0 && ctrs[j].desc.getOperatingSystemType().compareTo("[unassigned]") != 0) continue;
                    mergedTo[j] = i;
                    ctrs[i].join(ctrs[j]);
                    arch.remove(ctrs[j]);
                }
            }
        }
    }

    private static void reassignUnassignedConstraints(HashMap<String, LinkedList<ConstraintsCore>> arch2Ctrs) {
        LinkedList<ConstraintsCore> unassignedList = arch2Ctrs.get("[unassigned]");
        if (unassignedList == null) {
            return;
        }
        if (arch2Ctrs.size() == 1) {
            return;
        }
        if (arch2Ctrs.size() == 2) {
            for (Map.Entry<String, LinkedList<ConstraintsCore>> ctrs : arch2Ctrs.entrySet()) {
                if (ctrs.getKey().compareTo("[unassigned]") == 0) continue;
                ctrs.getValue().addAll(unassignedList);
                return;
            }
        }
        LinkedList assignedList = new LinkedList();
        for (Map.Entry<String, LinkedList<ConstraintsCore>> ctrs : arch2Ctrs.entrySet()) {
            if (ctrs.getKey().compareTo("[unassigned]") == 0) continue;
            assignedList.addAll(ctrs.getValue());
        }
        while (!unassignedList.isEmpty()) {
            ConstraintsCore unassigned = unassignedList.removeFirst();
            CloudMethodResourceDescription candidate = unassigned.desc;
            String bestArch = "";
            Float bestDifference = Float.valueOf(Float.MAX_VALUE);
            for (ConstraintsCore assigned : assignedList) {
                CloudMethodResourceDescription option = assigned.desc;
                float difference = candidate.difference(option);
                if (bestDifference.floatValue() < 0.0f) {
                    if (!(difference < 0.0f) || !(difference > bestDifference.floatValue())) continue;
                    bestArch = option.getProcessorArchitecture();
                    bestDifference = Float.valueOf(difference);
                    continue;
                }
                if (!(difference < bestDifference.floatValue())) continue;
                bestArch = option.getProcessorArchitecture();
                bestDifference = Float.valueOf(difference);
            }
            unassigned.desc.setProcessorArchitecture(bestArch);
            arch2Ctrs.get(bestArch).add(unassigned);
        }
    }

    public static int addExtraNodes(int alreadyCreated) {
        int vmCount;
        String minVMs = ProjectManager.getCloudProperty("minVMCount");
        int minVMsCount = 0;
        if (minVMs != null) {
            minVMsCount = Integer.parseInt(minVMs);
        }
        String initialVMs = ProjectManager.getCloudProperty("InitialVMs");
        int initialVMsCount = 0;
        if (initialVMs != null) {
            initialVMsCount = Integer.parseInt(initialVMs);
        }
        if ((vmCount = (initialVMsCount = Math.max(minVMsCount, initialVMsCount)) - alreadyCreated) <= 0) {
            return 0;
        }
        if (debug) {
            resourcesLogger.debug((Object)("DEBUG_MSG = [\n\tALREADY_CREATED_INSTANCES = " + alreadyCreated + "\n\tMAXIMUM_NEW_PETITIONS = " + vmCount + "\n]"));
        }
        return vmCount;
    }

    private void applyPolicies(ResourceUser.WorkloadStatus workload) {
        long creationTime;
        int currentCloudVMCount = CloudManager.getCurrentVMCount();
        try {
            creationTime = CloudManager.getNextCreationTime();
        }
        catch (Exception ex) {
            creationTime = 120000L;
        }
        try {
            String minAmountString;
            ProjectManager.refresh();
            String maxAmountString = ProjectManager.getCloudProperty("maxVMCount");
            if (maxAmountString != null) {
                this.maxNumberOfVMs = Integer.parseInt(maxAmountString);
            }
            if ((minAmountString = ProjectManager.getCloudProperty("minVMCount")) != null) {
                this.minNumberOfVMs = Integer.parseInt(minAmountString);
            }
            if (this.maxNumberOfVMs != null && this.minNumberOfVMs != null && this.minNumberOfVMs > this.maxNumberOfVMs) {
                this.minNumberOfVMs = this.maxNumberOfVMs;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Cannot refresh project", (Throwable)e);
        }
        int coreCount = workload.getCoreCount();
        int noResourceCount = workload.getNoResourceCount();
        int[] noResourceCounts = workload.getNoResourceCounts();
        long[] minCoreTime = new long[coreCount];
        long[] meanCoreTime = new long[coreCount];
        long[] maxCoreTime = new long[coreCount];
        long[] minRemainingCoreTime = new long[coreCount];
        long[] meanRemainingCoreTime = new long[coreCount];
        long[] maxRemainingCoreTime = new long[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            minCoreTime[coreId] = Math.min(workload.getCoreMinTime(coreId), creationTime);
            meanCoreTime[coreId] = Math.min(workload.getCoreMeanTime(coreId), creationTime);
            maxCoreTime[coreId] = Math.min(workload.getCoreMaxTime(coreId), creationTime);
            long meanRunningCoreTime = workload.getRunningCoreMeanTime(coreId);
            minRemainingCoreTime[coreId] = minCoreTime[coreId] - meanRunningCoreTime < 0L ? 0L : Math.min(minCoreTime[coreId] - meanRunningCoreTime, creationTime);
            meanRemainingCoreTime[coreId] = meanCoreTime[coreId] - meanRunningCoreTime < 0L ? 0L : Math.min(meanCoreTime[coreId] - meanRunningCoreTime, creationTime);
            maxRemainingCoreTime[coreId] = maxCoreTime[coreId] - meanRunningCoreTime < 0L ? 0L : Math.min(maxCoreTime[coreId] - meanRunningCoreTime, creationTime);
        }
        long[] runningMinCoreTime = new long[coreCount];
        long[] runningMeanCoreTime = new long[coreCount];
        long[] runningMaxCoreTime = new long[coreCount];
        long[] readyMinCoreTime = new long[coreCount];
        long[] readyMeanCoreTime = new long[coreCount];
        long[] readyMaxCoreTime = new long[coreCount];
        long[] pendingMinCoreTime = new long[coreCount];
        long[] pendingMeanCoreTime = new long[coreCount];
        long[] pendingMaxCoreTime = new long[coreCount];
        int[] realSlots = ResourceManager.getAvailableSlots();
        int[] totalSlots = ResourceManager.getTotalSlots();
        int[] runningCounts = workload.getRunningTaskCounts();
        int[] readyCounts = workload.getReadyTaskCounts();
        int[] pendingCounts = workload.getWaitingTaskCounts();
        for (int i = 0; i < coreCount; ++i) {
            runningMinCoreTime[i] = minRemainingCoreTime[i] * (long)runningCounts[i];
            readyMinCoreTime[i] = runningMinCoreTime[i] + minCoreTime[i] * (long)readyCounts[i];
            pendingMinCoreTime[i] = readyMinCoreTime[i] + minCoreTime[i] * (long)pendingCounts[i];
            runningMeanCoreTime[i] = meanRemainingCoreTime[i] * (long)runningCounts[i];
            readyMeanCoreTime[i] = runningMeanCoreTime[i] + meanCoreTime[i] * (long)readyCounts[i];
            pendingMeanCoreTime[i] = readyMeanCoreTime[i] + meanCoreTime[i] * (long)pendingCounts[i];
            runningMaxCoreTime[i] = maxRemainingCoreTime[i] * (long)runningCounts[i];
            readyMaxCoreTime[i] = runningMaxCoreTime[i] + maxCoreTime[i] * (long)readyCounts[i];
            pendingMaxCoreTime[i] = readyMaxCoreTime[i] + maxCoreTime[i] * (long)pendingCounts[i];
        }
        if (debug) {
            logger.debug((Object)("Applying VM optimization policies (currentVMs: " + currentCloudVMCount + " maxVMs: " + this.maxNumberOfVMs + " minVMs: " + this.minNumberOfVMs + ")"));
        }
        if (!cleanUp) {
            LinkedList<Integer> requiredVMs = this.checkNeededMachines(noResourceCount, noResourceCounts, totalSlots);
            if (!requiredVMs.isEmpty()) {
                logger.debug((Object)"Required VMs. Mandatory Increase");
                float[] creationRecommendations = this.recommendCreations(coreCount, creationTime, readyMinCoreTime, readyMeanCoreTime, readyMaxCoreTime, totalSlots, realSlots);
                for (Integer coreId : requiredVMs) {
                    creationRecommendations[coreId.intValue()] = Math.max(creationRecommendations[coreId], 1.0f);
                }
                this.mandatoryIncrease(creationRecommendations, requiredVMs);
                return;
            }
            if (this.minNumberOfVMs != null && this.minNumberOfVMs > currentCloudVMCount) {
                logger.debug((Object)("Current VM (" + currentCloudVMCount + ") count smaller than minimum VMs (" + this.minNumberOfVMs + "). Mandatory Increse"));
                float[] creationRecommendations = this.orderCreations(coreCount, creationTime, readyMinCoreTime, readyMeanCoreTime, readyMaxCoreTime, totalSlots, realSlots);
                this.mandatoryIncrease(creationRecommendations, new LinkedList<Integer>());
                return;
            }
            if (this.maxNumberOfVMs != null && this.maxNumberOfVMs < currentCloudVMCount) {
                logger.debug((Object)("Current VM (" + currentCloudVMCount + ") count bigger than maximum VMs (" + this.maxNumberOfVMs + "). Mandatory reduction"));
                float[] destroyRecommendations = this.deleteRecommendations(coreCount, 20000L, pendingMinCoreTime, pendingMeanCoreTime, pendingMaxCoreTime, totalSlots, realSlots);
                this.mandatoryReduction(destroyRecommendations);
                return;
            }
        }
        if (this.maxNumberOfVMs == null || this.maxNumberOfVMs > currentCloudVMCount) {
            logger.debug((Object)("Current VM (" + currentCloudVMCount + ") count smaller than maximum VMs (" + this.maxNumberOfVMs + ")"));
            float[] creationRecommendations = this.recommendCreations(coreCount, creationTime, readyMinCoreTime, readyMeanCoreTime, readyMaxCoreTime, totalSlots, realSlots);
            if (this.optionalIncrease(creationRecommendations)) {
                return;
            }
        }
        if (this.minNumberOfVMs == null || this.minNumberOfVMs < currentCloudVMCount) {
            logger.debug((Object)("Current VM (" + currentCloudVMCount + ") count bigger than minimum VMs (" + this.minNumberOfVMs + ")"));
            float[] destroyRecommendations = this.deleteRecommendations(coreCount, 20000L, pendingMinCoreTime, pendingMeanCoreTime, pendingMaxCoreTime, totalSlots, realSlots);
            if (this.optionalReduction(destroyRecommendations)) {
                return;
            }
        }
    }

    private void mandatoryIncrease(float[] creationRecommendations, LinkedList<Integer> requiredVMs) {
        PriorityQueue<ValueResourceDescription> pq = new PriorityQueue<ValueResourceDescription>();
        boolean[] required = new boolean[creationRecommendations.length];
        Iterator i$ = requiredVMs.iterator();
        while (i$.hasNext()) {
            int coreId = (Integer)i$.next();
            required[coreId] = true;
        }
        for (int coreId = 0; coreId < creationRecommendations.length; ++coreId) {
            Implementation[] impls;
            for (Implementation impl : impls = CoreManager.getCoreImplementations((int)coreId)) {
                if (impl.getType() == Implementation.Type.SERVICE) continue;
                MethodResourceDescription contraints = (MethodResourceDescription)((MethodImplementation)impl).getRequirements();
                ValueResourceDescription v = new ValueResourceDescription();
                v.constraints = contraints;
                v.value = creationRecommendations[coreId];
                v.prioritary = required[coreId];
                pq.add(v);
            }
        }
        ResourceOptimizer.requestOneCreation(pq, true);
    }

    private boolean optionalIncrease(float[] creationRecommendations) {
        PriorityQueue<ValueResourceDescription> pq = new PriorityQueue<ValueResourceDescription>();
        for (int coreId = 0; coreId < creationRecommendations.length; ++coreId) {
            Implementation[] impls;
            if (!(creationRecommendations[coreId] > 1.0f)) continue;
            for (Implementation impl : impls = CoreManager.getCoreImplementations((int)coreId)) {
                if (impl.getType() == Implementation.Type.SERVICE) continue;
                MethodResourceDescription contraints = (MethodResourceDescription)((MethodImplementation)impl).getRequirements();
                ValueResourceDescription v = new ValueResourceDescription();
                v.constraints = contraints;
                v.value = creationRecommendations[coreId];
                v.prioritary = false;
                pq.add(v);
            }
        }
        ResourceCreationRequest rcr = ResourceOptimizer.requestOneCreation(pq, false);
        return rcr != null;
    }

    private boolean optionalReduction(float[] destroyRecommendations) {
        LinkedList<CloudMethodWorker> nonCritical = this.trimReductionOptions(ResourceManager.getNonCriticalDynamicResources(), destroyRecommendations, false);
        Object[] nonCriticalSolution = CloudManager.getBestDestruction(nonCritical, destroyRecommendations);
        if (nonCriticalSolution == null) {
            return false;
        }
        CloudMethodWorker res = (CloudMethodWorker)((Object)nonCriticalSolution[0]);
        float[] record = (float[])nonCriticalSolution[1];
        CloudMethodResourceDescription rd = (CloudMethodResourceDescription)((Object)nonCriticalSolution[3]);
        if (debug) {
            logger.debug((Object)("Best resource to remove is " + res.getName() + "and record is [" + record[0] + "," + record[1] + "," + record[2]));
        }
        if (record[1] > 0.0f) {
            logger.debug((Object)"Optional destroy recommendation not applied");
            return false;
        }
        logger.debug((Object)"Optional destroy recommendation applied");
        CloudMethodResourceDescription finalDescription = rd;
        finalDescription.setName(res.getName());
        CloudManager.destroyResources(res, finalDescription);
        return true;
    }

    private void mandatoryReduction(float[] destroyRecommendations) {
        CloudMethodResourceDescription rd;
        CloudMethodWorker res;
        boolean criticalIsBetter;
        LinkedList<CloudMethodWorker> critical = this.trimReductionOptions(ResourceManager.getCriticalDynamicResources(), destroyRecommendations, false);
        LinkedList<CloudMethodWorker> nonCritical = this.trimReductionOptions(ResourceManager.getNonCriticalDynamicResources(), destroyRecommendations, false);
        Object[] criticalSolution = CloudManager.getBestDestruction(critical, destroyRecommendations);
        Object[] nonCriticalSolution = CloudManager.getBestDestruction(nonCritical, destroyRecommendations);
        if (criticalSolution == null) {
            if (nonCriticalSolution == null) {
                return;
            }
            criticalIsBetter = false;
        } else if (nonCriticalSolution == null) {
            criticalIsBetter = true;
        } else {
            criticalIsBetter = false;
            float[] noncriticalValues = (float[])nonCriticalSolution[1];
            float[] criticalValues = (float[])criticalSolution[1];
            if (noncriticalValues[0] == criticalValues[0]) {
                if (noncriticalValues[1] == criticalValues[1]) {
                    if (noncriticalValues[2] < criticalValues[2]) {
                        criticalIsBetter = true;
                    }
                } else if (noncriticalValues[1] > criticalValues[1]) {
                    criticalIsBetter = true;
                }
            } else if (noncriticalValues[0] > criticalValues[0]) {
                criticalIsBetter = true;
            }
        }
        if (criticalIsBetter) {
            res = (CloudMethodWorker)((Object)criticalSolution[0]);
            rd = (CloudMethodResourceDescription)((Object)criticalSolution[3]);
        } else {
            if (nonCriticalSolution == null) {
                return;
            }
            res = (CloudMethodWorker)((Object)nonCriticalSolution[0]);
            rd = (CloudMethodResourceDescription)((Object)nonCriticalSolution[3]);
        }
        CloudMethodResourceDescription finalDescription = new CloudMethodResourceDescription(rd);
        finalDescription.setName(res.getName());
        CloudManager.destroyResources(res, finalDescription);
    }

    private LinkedList<CloudMethodWorker> trimReductionOptions(Collection<CloudMethodWorker> options, float[] recommendations, boolean aggressive) {
        if (debug) {
            logger.debug((Object)" * Trimming reduction options");
        }
        LinkedList<CloudMethodWorker> resources = new LinkedList<CloudMethodWorker>();
        for (CloudMethodWorker resource : options) {
            boolean add;
            boolean bl = add = !aggressive;
            if (debug) {
                logger.debug((Object)("\tEvaluating " + resource.getName() + ". Default reduction is " + add));
            }
            LinkedList<Integer> executableCores = resource.getExecutableCores();
            Iterator i$ = executableCores.iterator();
            while (i$.hasNext()) {
                int coreId = (Integer)i$.next();
                if (!aggressive && recommendations[coreId] < 1.0f) {
                    if (debug) {
                        logger.debug((Object)("\t\tVM not removed because of not agressive and recomendations < 1 (" + recommendations[coreId] + ")"));
                    }
                    add = false;
                    break;
                }
                if (!aggressive || !(recommendations[coreId] > 0.0f)) continue;
                if (debug) {
                    logger.debug((Object)("\t\tVM removed because of agressive and recomendations > 0 (" + recommendations[coreId] + ")"));
                }
                add = true;
                break;
            }
            if (!add) continue;
            if (debug) {
                logger.debug((Object)"\t\tVM added to candidate to remove.");
            }
            resources.add(resource);
        }
        return resources;
    }

    private static ResourceCreationRequest requestOneCreation(PriorityQueue<ValueResourceDescription> pq, boolean include) {
        ValueResourceDescription v;
        while ((v = pq.poll()) != null) {
            ResourceCreationRequest rcr = CloudManager.askForResources(v.value < 1.0f ? 1 : (int)v.value, v.constraints, include);
            if (rcr == null) continue;
            resourcesLogger.info((Object)("ORDER_CREATION = [\n\tTYPE = " + rcr.getRequested().getType() + "\n\tPROVIDER = " + rcr.getProvider() + "\n]"));
            if (debug) {
                StringBuilder sb = new StringBuilder();
                sb.append("EXPECTED_SIM_TASKS = [").append("\n");
                for (int i = 0; i < CoreManager.getCoreCount(); ++i) {
                    for (int j = 0; j < rcr.requestedSimultaneousTaskCount()[i].length; ++j) {
                        sb.append("\t").append("IMPLEMENTATION_INFO = [").append("\n");
                        sb.append("\t").append("\t").append("COREID = ").append(i).append("\n");
                        sb.append("\t").append("\t").append("IMPLID = ").append(j).append("\n");
                        sb.append("\t").append("\t").append("SIM_TASKS = ").append(rcr.requestedSimultaneousTaskCount()[i][j]).append("\n");
                        sb.append("\t").append("]").append("\n");
                    }
                }
                sb.append("]");
                resourcesLogger.debug((Object)sb.toString());
            }
            return rcr;
        }
        return null;
    }

    private LinkedList<Integer> checkNeededMachines(int noResourceCount, int[] noResourceCountPerCore, int[] slotCountPerCore) {
        LinkedList<Integer> needed = new LinkedList<Integer>();
        if (noResourceCount == 0) {
            return needed;
        }
        for (int i = 0; i < CoreManager.getCoreCount(); ++i) {
            if (noResourceCountPerCore[i] <= 0 || slotCountPerCore[i] != 0) continue;
            needed.add(i);
        }
        return needed;
    }

    private float[] recommendCreations(int coreCount, long creationTime, long[] aggregatedMinCoreTime, long[] aggregatedMeanCoreTime, long[] aggregatedMaxCoreTime, int[] totalSlots, int[] realSlots) {
        float[] creations = new float[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            long totalTime;
            long realTime = (long)realSlots[coreId] * creationTime;
            long embraceableLoad = totalTime = (long)totalSlots[coreId] * creationTime;
            long remainingLoad = aggregatedMeanCoreTime[coreId] - embraceableLoad;
            if (debug) {
                logger.debug((Object)"* Calculating increase recomendations");
                logger.debug((Object)("\tRemaining load = " + aggregatedMeanCoreTime[coreId] + "-( " + totalSlots[coreId] + " * " + creationTime + " ) = " + remainingLoad));
            }
            if (remainingLoad > 0L) {
                creations[coreId] = (int)(remainingLoad / creationTime);
                if (!debug) continue;
                logger.debug((Object)("\tRecomended slots = " + creations[coreId] + " ( " + remainingLoad + " / " + creationTime + " )"));
                continue;
            }
            creations[coreId] = 0.0f;
        }
        return creations;
    }

    private float[] orderCreations(int coreCount, long creationTime, long[] aggregatedMinCoreTime, long[] aggregatedMeanCoreTime, long[] aggregatedMaxCoreTime, int[] totalSlots, int[] realSlots) {
        float[] creations = new float[coreCount];
        int maxI = 0;
        float maxRatio = 0.0f;
        for (int i = 0; i < CoreManager.getCoreCount(); ++i) {
            float ratio;
            if (aggregatedMeanCoreTime[i] <= 0L || totalSlots[i] <= 0 || !((ratio = (float)(aggregatedMeanCoreTime[i] / (long)totalSlots[i])) > maxRatio)) continue;
            maxI = i;
            maxRatio = ratio;
        }
        creations[maxI] = 1.0f;
        return creations;
    }

    private float[] deleteRecommendations(int coreCount, long limitTime, long[] aggregatedMinCoreTime, long[] aggregatedMeanCoreTime, long[] aggregatedMaxCoreTime, int[] totalSlots, int[] realSlots) {
        if (debug) {
            logger.debug((Object)("* Delete Recomendations calculations:\n\tcoreCount: " + coreCount + " limitTime: " + limitTime));
        }
        float[] destructions = new float[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            long embraceableLoad = limitTime * (long)realSlots[coreId];
            if (embraceableLoad == 0L) {
                destructions[coreId] = 0.0f;
                if (!debug) continue;
                logger.debug((Object)("\tembraceableLoad [ " + coreId + "] = " + limitTime + " * " + realSlots[coreId] + " = " + embraceableLoad));
                logger.debug((Object)("\tdestructions [ " + coreId + "] = 0"));
                continue;
            }
            if (aggregatedMinCoreTime[coreId] > 0L) {
                double unusedTime = (double)embraceableLoad / 2.0 - (double)aggregatedMeanCoreTime[coreId];
                destructions[coreId] = (float)(unusedTime / (double)limitTime);
                if (!debug) continue;
                logger.debug((Object)("\tembraceableLoad [ " + coreId + "] = " + limitTime + " * " + realSlots[coreId] + " = " + embraceableLoad));
                logger.debug((Object)("\tunused [ " + coreId + "] =  ( " + embraceableLoad + " / 2) - " + aggregatedMeanCoreTime[coreId] + " = " + unusedTime));
                logger.debug((Object)("\tdestructions [ " + coreId + "] = " + destructions[coreId]));
                continue;
            }
            destructions[coreId] = embraceableLoad / limitTime;
        }
        return destructions;
    }

    static {
        resourcesLogger = Logger.getLogger((String)"integratedtoolkit.Resources");
        logger = Logger.getLogger((String)"integratedtoolkit.Components.TaskDispatcher.TaskScheduler");
        debug = logger.isDebugEnabled();
    }

    private static class ValueResourceDescription
    implements Comparable<ValueResourceDescription> {
        boolean prioritary = false;
        float value;
        MethodResourceDescription constraints;

        private ValueResourceDescription() {
        }

        @Override
        public int compareTo(ValueResourceDescription o) {
            if (this.prioritary && !o.prioritary) {
                return 1;
            }
            if (!this.prioritary && o.prioritary) {
                return -1;
            }
            float dif = this.value - o.value;
            if (dif > 0.0f) {
                return 1;
            }
            if (dif < 0.0f) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return this.value + (this.prioritary ? "!" : "") + this.constraints;
        }
    }

    private static class ConstraintsCore {
        CloudMethodResourceDescription desc;
        LinkedList<ConstraintsCore>[] cores;

        public ConstraintsCore(CloudMethodResourceDescription desc, int core, LinkedList<ConstraintsCore> coreList) {
            this.desc = desc;
            this.cores = new LinkedList[CoreManager.getCoreCount()];
            this.cores[core] = coreList;
        }

        public void join(ConstraintsCore c2) {
            this.desc.join(c2.desc);
            c2.desc = this.desc;
            for (int coreId = 0; coreId < CoreManager.getCoreCount(); ++coreId) {
                if (this.cores[coreId] != null) {
                    if (c2.cores[coreId] != null) {
                        this.cores[coreId].remove(c2);
                        continue;
                    }
                    c2.cores[coreId] = this.cores[coreId];
                    continue;
                }
                this.cores[coreId] = c2.cores[coreId];
            }
        }

        public void confirmed() {
            for (int coreId = 0; coreId < CoreManager.getCoreCount(); ++coreId) {
                if (this.cores[coreId] == null) continue;
                this.cores[coreId].clear();
            }
        }

        public String toString() {
            LinkedList<Integer> cores = new LinkedList<Integer>();
            for (int i = 0; i < CoreManager.getCoreCount(); ++i) {
                if (this.cores[i] == null) continue;
                cores.add(i);
            }
            return this.desc.toString() + " compleix pels cores " + cores;
        }
    }
}

