/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.components.impl;

import integratedtoolkit.api.ITExecution;
import integratedtoolkit.components.impl.DataInfoProvider;
import integratedtoolkit.components.impl.RuntimeMonitor;
import integratedtoolkit.components.impl.TaskDispatcher;
import integratedtoolkit.types.Task;
import integratedtoolkit.types.TaskParams;
import integratedtoolkit.types.data.AccessParams;
import integratedtoolkit.types.data.DataAccessId;
import integratedtoolkit.types.data.DataInstanceId;
import integratedtoolkit.types.data.FileInfo;
import integratedtoolkit.types.data.operation.ResultListener;
import integratedtoolkit.types.parameter.DependencyParameter;
import integratedtoolkit.types.parameter.FileParameter;
import integratedtoolkit.types.parameter.ObjectParameter;
import integratedtoolkit.types.parameter.Parameter;
import integratedtoolkit.types.request.ap.EndOfAppRequest;
import integratedtoolkit.types.request.ap.WaitForTaskRequest;
import integratedtoolkit.types.resources.Worker;
import integratedtoolkit.util.CoreManager;
import integratedtoolkit.util.ElementNotFoundException;
import integratedtoolkit.util.ErrorManager;
import integratedtoolkit.util.Graph;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Logger;

public class TaskAnalyser {
    private static final String TASK_FAILED = "Task failed: ";
    private DataInfoProvider DIP;
    private TaskDispatcher TD;
    private Graph<Integer, Task> depGraph = new Graph();
    private TreeMap<Integer, Integer> writers;
    private HashMap<Integer, Integer> currentTaskCount = new HashMap();
    private HashMap<Long, Integer> appIdToTotalTaskCount;
    private HashMap<Long, Integer> appIdToTaskCount;
    private HashMap<Long, Semaphore> appIdToSemaphore;
    private HashMap<Long, TreeSet<Integer>> appIdToWrittenFiles;
    private Hashtable<Integer, List<Semaphore>> waitedTasks;
    private static final Logger logger = Logger.getLogger("integratedtoolkit.Components.TaskProcessor.TaskAnalyser");
    private static final boolean debug = logger.isDebugEnabled();
    private static final boolean drawGraph = System.getProperty("it.graph") != null && System.getProperty("it.graph").equals("true");
    private static int synchronizationId;

    public TaskAnalyser() {
        this.writers = new TreeMap();
        this.appIdToTaskCount = new HashMap();
        this.appIdToTotalTaskCount = new HashMap();
        this.appIdToSemaphore = new HashMap();
        this.appIdToWrittenFiles = new HashMap();
        this.waitedTasks = new Hashtable();
        synchronizationId = 0;
        logger.info("Initialization finished");
    }

    public void setCoWorkers(DataInfoProvider DIP, TaskDispatcher TD) {
        this.DIP = DIP;
        this.TD = TD;
    }

    public Task getTask(int taskId) {
        return this.depGraph.get(taskId);
    }

    public void processTask(Task currentTask) {
        TaskParams params = currentTask.getTaskParams();
        logger.info("New " + (params.getType() == TaskParams.Type.METHOD ? "method" : "service") + " task(" + params.getName() + "), ID = " + currentTask.getId());
        if (drawGraph) {
            RuntimeMonitor.addTaskToGraph(currentTask);
            if (synchronizationId > 0) {
                RuntimeMonitor.addEdgeToGraph("Synchro" + synchronizationId, String.valueOf(currentTask.getId()), "");
            }
        }
        int currentTaskId = currentTask.getId();
        Parameter[] parameters = params.getParameters();
        this.depGraph.addNode(currentTaskId, currentTask);
        Integer methodId = params.getId();
        Integer actualCount = this.currentTaskCount.get(methodId);
        if (actualCount == null) {
            actualCount = 0;
        }
        this.currentTaskCount.put(methodId, actualCount + 1);
        Long appId = currentTask.getAppId();
        Integer taskCount = this.appIdToTaskCount.get(appId);
        if (taskCount == null) {
            taskCount = 0;
        }
        Integer n = taskCount;
        Integer n2 = taskCount = Integer.valueOf(taskCount + 1);
        this.appIdToTaskCount.put(appId, taskCount);
        Integer totalTaskCount = this.appIdToTotalTaskCount.get(appId);
        if (totalTaskCount == null) {
            totalTaskCount = 0;
        }
        n2 = totalTaskCount;
        Integer n3 = totalTaskCount = Integer.valueOf(totalTaskCount + 1);
        this.appIdToTotalTaskCount.put(appId, totalTaskCount);
        boolean isWaiting = true;
        block16: for (Parameter p : parameters) {
            DataAccessId daId;
            if (debug) {
                logger.debug("* Parameter : " + p);
            }
            AccessParams.AccessMode am = null;
            switch (p.getDirection()) {
                case IN: {
                    am = AccessParams.AccessMode.R;
                    break;
                }
                case OUT: {
                    am = AccessParams.AccessMode.W;
                    break;
                }
                case INOUT: {
                    am = AccessParams.AccessMode.RW;
                }
            }
            switch (p.getType()) {
                case FILE_T: {
                    FileParameter fp = (FileParameter)p;
                    daId = this.DIP.registerFileAccess(am, fp.getLocation(), methodId);
                    break;
                }
                case OBJECT_T: {
                    ObjectParameter op = (ObjectParameter)p;
                    daId = this.DIP.registerObjectAccess(am, op.getValue(), op.getCode(), methodId);
                    break;
                }
                default: {
                    continue block16;
                }
            }
            DependencyParameter dp = (DependencyParameter)p;
            dp.setDataAccessId(daId);
            switch (am) {
                case R: {
                    isWaiting = this.checkDependencyForRead(currentTask, dp) && isWaiting;
                    continue block16;
                }
                case RW: {
                    isWaiting = this.checkDependencyForRead(currentTask, dp) && isWaiting;
                    this.registerOutputValues(currentTask, dp);
                    continue block16;
                }
                case W: {
                    this.registerOutputValues(currentTask, dp);
                }
            }
        }
        if (params.getType() == TaskParams.Type.SERVICE && params.hasTargetObject()) {
            this.checkSchedulingConstraints(currentTask);
        }
        try {
            if (!this.depGraph.hasPredecessors(currentTaskId)) {
                if (debug) {
                    logger.debug("Task " + currentTaskId + " has NO dependencies, send for schedule");
                }
                LinkedList<Task> s = new LinkedList<Task>();
                s.add(currentTask);
                this.currentTaskCount.put(params.getId(), this.currentTaskCount.get(params.getId()) - 1);
                this.TD.scheduleTasks(s, false, new int[CoreManager.getCoreCount()]);
            } else if (isWaiting) {
                this.TD.newWaitingTask(methodId);
            }
        }
        catch (ElementNotFoundException e) {
            ErrorManager.fatal("Error checking dependencies for task " + currentTaskId, e);
            return;
        }
    }

    private boolean checkDependencyForRead(Task currentTask, DependencyParameter dp) {
        int dataId = dp.getDataAccessId().getDataId();
        Integer lastWriterId = this.writers.get(dataId);
        if (lastWriterId != null && lastWriterId > 0 && this.depGraph.get(lastWriterId) != null && lastWriterId.intValue() != currentTask.getId()) {
            if (debug) {
                logger.debug("Last writer for datum " + dp.getDataAccessId().getDataId() + " is task " + lastWriterId);
                logger.debug("Adding dependency between task " + lastWriterId + " and task " + currentTask.getId());
            }
            if (drawGraph) {
                try {
                    boolean b = true;
                    for (Task t : this.depGraph.getSuccessors(lastWriterId)) {
                        if (t.getId() != currentTask.getId()) continue;
                        b = false;
                    }
                    if (b) {
                        RuntimeMonitor.addEdgeToGraph(String.valueOf(lastWriterId), String.valueOf(currentTask.getId()), String.valueOf(dp.getDataAccessId().getDataId()));
                    }
                }
                catch (Exception e) {
                    logger.error("Error drawing dependency in graph", e);
                }
            }
            try {
                this.depGraph.addEdge(lastWriterId, currentTask.getId());
                return !this.depGraph.hasPredecessors(lastWriterId);
            }
            catch (ElementNotFoundException e) {
                ErrorManager.fatal("Error when adding a dependency between tasks " + lastWriterId + " and " + currentTask.getId(), e);
            }
        } else if (drawGraph && lastWriterId != null && lastWriterId < 0) {
            RuntimeMonitor.addEdgeToGraph("Synchro" + -lastWriterId.intValue(), String.valueOf(currentTask.getId()), "");
        }
        return true;
    }

    public void registerOutputValues(Task currentTask, DependencyParameter dp) {
        int currentTaskId = currentTask.getId();
        int dataId = dp.getDataAccessId().getDataId();
        Long appId = currentTask.getAppId();
        this.writers.put(dataId, currentTaskId);
        if (dp.getType() == ITExecution.ParamType.FILE_T) {
            TreeSet<Integer> idsWritten = this.appIdToWrittenFiles.get(appId);
            if (idsWritten == null) {
                idsWritten = new TreeSet();
                this.appIdToWrittenFiles.put(appId, idsWritten);
            }
            idsWritten.add(dataId);
        }
        if (debug) {
            logger.debug("New writer for datum " + dp.getDataAccessId().getDataId() + " is task " + currentTaskId);
        }
    }

    public void checkSchedulingConstraints(Task task) {
        DataInstanceId dependingDataId = null;
        TaskParams params = task.getTaskParams();
        DependencyParameter dependentParameter = params.hasReturnValue() ? (DependencyParameter)params.getParameters()[params.getParameters().length - 2] : (DependencyParameter)params.getParameters()[params.getParameters().length - 1];
        switch (dependentParameter.getDirection()) {
            case IN: {
                DataAccessId.RAccessId raId = (DataAccessId.RAccessId)dependentParameter.getDataAccessId();
                dependingDataId = raId.getReadDataInstance();
                break;
            }
            case INOUT: {
                DataAccessId.RWAccessId rwaId = (DataAccessId.RWAccessId)dependentParameter.getDataAccessId();
                dependingDataId = rwaId.getReadDataInstance();
                break;
            }
        }
        if (dependingDataId != null && params.getType() == TaskParams.Type.SERVICE && dependingDataId.getVersionId() > 1) {
            task.setEnforcingData(dependingDataId);
            task.forceStrongScheduling();
        }
    }

    public void updateGraph(Task task, int implId, Worker<?> resource) {
        List<Semaphore> sems;
        Semaphore sem;
        int taskId = task.getId();
        if (task.getStatus() == Task.TaskState.FAILED) {
            ErrorManager.warn(TASK_FAILED + task);
        }
        Long appId = task.getAppId();
        Integer taskCount = this.appIdToTaskCount.get(appId) - 1;
        this.appIdToTaskCount.put(appId, taskCount);
        if (taskCount == 0 && (sem = this.appIdToSemaphore.remove(appId)) != null) {
            this.appIdToTaskCount.remove(appId);
            sem.release();
        }
        if ((sems = this.waitedTasks.remove(taskId)) != null) {
            for (Semaphore sem2 : sems) {
                sem2.release();
            }
        }
        LinkedList<DataAccessId> readedData = new LinkedList<DataAccessId>();
        for (Parameter param : task.getTaskParams().getParameters()) {
            ITExecution.ParamType type = param.getType();
            if (type != ITExecution.ParamType.FILE_T && type != ITExecution.ParamType.OBJECT_T) continue;
            DependencyParameter dPar = (DependencyParameter)param;
            DataAccessId dAccId = dPar.getDataAccessId();
            readedData.add(dAccId);
        }
        this.DIP.dataHasBeenRead(readedData, task.getTaskParams().getId());
        LinkedList<Task> toSchedule = new LinkedList<Task>();
        try {
            Iterator<Task> i = this.depGraph.getIteratorOverSuccessors(taskId);
            while (i.hasNext()) {
                Task succ = i.next();
                int succId = succ.getId();
                this.depGraph.removeEdge(taskId, succId);
                if (this.depGraph.hasPredecessors(succId)) continue;
                toSchedule.add(succ);
            }
        }
        catch (ElementNotFoundException e) {
            ErrorManager.fatal("Error removing the dependencies of task " + taskId, e);
        }
        if (!toSchedule.isEmpty()) {
            if (debug) {
                StringBuilder sb = new StringBuilder("All dependencies solved for tasks: ");
                for (Task t : toSchedule) {
                    sb.append(t.getId()).append("(").append(t.getTaskParams().getName()).append(") ");
                }
                logger.debug(sb);
            }
            int[] successors = new int[CoreManager.getCoreCount()];
            for (Task t : toSchedule) {
                try {
                    Iterator<Task> i = this.depGraph.getIteratorOverSuccessors(t.getId());
                    while (i.hasNext()) {
                        Task succ = i.next();
                        int succId = succ.getId();
                        boolean hasPreds = false;
                        Iterator<Task> j = this.depGraph.getIteratorOverPredecessors(succId);
                        while (j.hasNext()) {
                            Task pred = j.next();
                            int predId = pred.getId();
                            hasPreds = hasPreds || this.depGraph.hasPredecessors(predId);
                        }
                        if (hasPreds) continue;
                        int n = t.getTaskParams().getId();
                        successors[n] = successors[n] + 1;
                    }
                    this.currentTaskCount.put(t.getTaskParams().getId(), this.currentTaskCount.get(t.getTaskParams().getId()) - 1);
                }
                catch (Exception e) {
                    ErrorManager.fatal("Error updating the waiting tasks of " + taskId, e);
                }
            }
            this.TD.scheduleTasks(toSchedule, true, successors);
        }
        this.TD.notifyJobEnd(task, implId, resource);
        if (this.appIdToSemaphore.get(appId) != null) {
            this.checkResultFileTransfer(task);
        }
        this.depGraph.removeNode(taskId);
    }

    private void checkResultFileTransfer(Task t) {
        LinkedList<DataInstanceId> fileIds = new LinkedList<DataInstanceId>();
        block10: for (Parameter p : t.getTaskParams().getParameters()) {
            switch (p.getType()) {
                case FILE_T: {
                    FileParameter fp = (FileParameter)p;
                    switch (fp.getDirection()) {
                        case IN: {
                            break;
                        }
                        case INOUT: {
                            DataInstanceId dId = ((DataAccessId.RWAccessId)fp.getDataAccessId()).getWrittenDataInstance();
                            if (this.writers.get(dId.getDataId()).intValue() != t.getId()) break;
                            fileIds.add(dId);
                            break;
                        }
                        case OUT: {
                            DataInstanceId dId = ((DataAccessId.WAccessId)fp.getDataAccessId()).getWrittenDataInstance();
                            if (this.writers.get(dId.getDataId()).intValue() != t.getId()) break;
                            fileIds.add(dId);
                        }
                    }
                    continue block10;
                }
            }
        }
        int numFT = fileIds.size();
        if (numFT > 0) {
            for (DataInstanceId fileId : fileIds) {
                try {
                    int id = fileId.getDataId();
                    this.DIP.blockDataAndGetResultFile(id, new ResultListener(new Semaphore(0)));
                    this.DIP.unblockDataId(id);
                }
                catch (Exception e) {}
            }
        }
    }

    public void findWaitedTask(WaitForTaskRequest request) {
        int dataId = request.getDataId();
        AccessParams.AccessMode am = request.getAccessMode();
        Semaphore sem = request.getSemaphore();
        Integer lastWriterId = this.writers.get(dataId);
        if (drawGraph && lastWriterId != null) {
            if (am == AccessParams.AccessMode.RW) {
                this.writers.put(dataId, -synchronizationId);
            }
            ++synchronizationId;
            try {
                RuntimeMonitor.addSynchroToGraph(synchronizationId);
                RuntimeMonitor.addEdgeToGraph(String.valueOf(lastWriterId), "Synchro" + synchronizationId, String.valueOf(dataId));
                if (synchronizationId > 0) {
                    RuntimeMonitor.addEdgeToGraph("Synchro" + (synchronizationId - 1), "Synchro" + synchronizationId, String.valueOf(dataId));
                }
            }
            catch (Exception e) {
                logger.error("Error adding task to graph file", e);
            }
        }
        if (lastWriterId == null || this.depGraph.get(lastWriterId) == null) {
            sem.release();
        } else {
            List<Semaphore> list = this.waitedTasks.get(lastWriterId);
            if (list == null) {
                list = new LinkedList<Semaphore>();
                this.waitedTasks.put(lastWriterId, list);
            }
            list.add(sem);
        }
    }

    public void noMoreTasks(EndOfAppRequest request) {
        Long appId = request.getAppId();
        Integer count = this.appIdToTaskCount.get(appId);
        if (drawGraph) {
            RuntimeMonitor.commitGraph();
        }
        if (count == null || count == 0) {
            this.appIdToTaskCount.remove(appId);
            request.getSemaphore().release();
        } else {
            this.appIdToSemaphore.put(appId, request.getSemaphore());
        }
    }

    public TreeSet<Integer> getAndRemoveWrittenFiles(Long appId) {
        TreeSet<Integer> data = this.appIdToWrittenFiles.remove(appId);
        return data;
    }

    public void shutdown() {
        if (drawGraph) {
            RuntimeMonitor.removeTemporaryGraph();
        }
    }

    public String getGraphDOTFormat() {
        return this.depGraph.getGraphDotFormat();
    }

    public String getTaskStateRequest() {
        StringBuilder sb = new StringBuilder("\t<TasksInfo>\n");
        for (Map.Entry<Long, Integer> e : this.appIdToTotalTaskCount.entrySet()) {
            Long appId = e.getKey();
            Integer totalTaskCount = e.getValue();
            Integer taskCount = this.appIdToTaskCount.get(appId);
            if (taskCount == null) {
                taskCount = 0;
            }
            int completed = totalTaskCount - taskCount;
            sb.append("\t\t<Application id=\"").append(appId).append("\">\n");
            sb.append("\t\t\t<TotalCount>").append(totalTaskCount).append("</TotalCount>\n");
            sb.append("\t\t\t<InProgress>").append(taskCount).append("</InProgress>\n");
            sb.append("\t\t\t<Completed>").append(completed).append("</Completed>\n");
            sb.append("\t\t</Application>\n");
        }
        sb.append("\t</TasksInfo>\n");
        return sb.toString();
    }

    public void deleteFile(FileInfo fileInfo) {
        Task task;
        int dataId = fileInfo.getDataId();
        Integer taskId = this.writers.get(dataId);
        if (taskId != null && (task = this.depGraph.get(taskId)) != null) {
            return;
        }
        for (TreeSet<Integer> files : this.appIdToWrittenFiles.values()) {
            files.remove(fileInfo.getDataId());
        }
    }
}

